/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.interceptor;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StartTagType;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.interceptor.BaseInterceptor;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlFilteringInterceptor
extends BaseInterceptor {
    private static Logger logger = LoggerFactory.getLogger(HtmlFilteringInterceptor.class);
    private boolean considerSiteSettingsForFiltering;
    private Set<String> filteredTags = Collections.emptySet();
    private boolean removeContentBetweenTags;

    private static Set<String> convertToTagSet(String tags) {
        if (StringUtils.isEmpty((String)tags)) {
            return null;
        }
        HashSet<String> tagSet = new HashSet<String>();
        for (String tag : StringUtils.split((String)tags, (String)" ,")) {
            String toBeFiltered = tag.trim().toLowerCase();
            if (toBeFiltered.length() <= 0) continue;
            tagSet.add(toBeFiltered);
        }
        return tagSet;
    }

    protected static String filterTags(String content, Set<String> filteredTags, boolean removeContentBetweenTags) {
        String result;
        if (filteredTags.isEmpty()) {
            return content;
        }
        long timer = System.currentTimeMillis();
        boolean modified = false;
        Source src = new Source((CharSequence)content);
        src.setLogger(null);
        OutputDocument out = new OutputDocument(src);
        for (String filteredTagName : filteredTags) {
            for (StartTag startTag : src.getAllStartTags(filteredTagName)) {
                if (startTag.getTagType() != StartTagType.NORMAL) continue;
                Element element = startTag.getElement();
                EndTag endTag = element.getEndTag();
                if (removeContentBetweenTags && endTag != null) {
                    out.remove((Segment)element);
                } else {
                    out.remove((Segment)startTag);
                    if (endTag != null) {
                        out.remove((Segment)endTag);
                    }
                }
                modified = true;
            }
        }
        String string = result = modified ? out.toString() : content;
        if (logger.isDebugEnabled()) {
            logger.debug("Filter HTML tags took " + (System.currentTimeMillis() - timer) + " ms");
        }
        return result;
    }

    @Override
    public Value beforeSetValue(JCRNodeWrapper node, String name, ExtendedPropertyDefinition definition, Value originalValue) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        String result;
        String content = originalValue.getString();
        if (StringUtils.isEmpty((String)content) || !content.contains("<")) {
            if (logger.isDebugEnabled()) {
                logger.debug("The value does not contain any HTML tags. Skip filtering.");
            }
            return originalValue;
        }
        Set<String> tags = this.filteredTags;
        boolean doFiltering = false;
        if (this.considerSiteSettingsForFiltering && node.getResolveSite().isHtmlMarkupFilteringEnabled()) {
            JCRSiteNode resolveSite = node.getResolveSite();
            if (resolveSite != null && resolveSite.hasProperty("j:doTagFiltering") && (tags = HtmlFilteringInterceptor.convertToTagSet(resolveSite.hasProperty("j:filteredTags") ? resolveSite.getProperty("j:filteredTags").getString() : null)) != null && !tags.isEmpty()) {
                doFiltering = true;
            }
        } else if (this.filteredTags != null && !this.filteredTags.isEmpty()) {
            doFiltering = true;
        }
        if (!doFiltering) {
            return originalValue;
        }
        Value modifiedValue = originalValue;
        if (logger.isDebugEnabled()) {
            logger.debug("Performing HTML tag filtering for " + node.getPath() + "/" + name);
            if (logger.isTraceEnabled()) {
                logger.trace("Original value: " + content);
            }
        }
        if ((result = HtmlFilteringInterceptor.filterTags(content, tags, this.removeContentBetweenTags)) != content && !result.equals(content)) {
            modifiedValue = node.getSession().getValueFactory().createValue(result);
            if (logger.isDebugEnabled()) {
                logger.debug("Done filtering of \"unwanted\" HTML tags.");
                if (logger.isTraceEnabled()) {
                    logger.trace("Modified value: " + result);
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("The value does not contain HTML tags that needs to be removed. The content remains unchanged.");
        }
        return modifiedValue;
    }

    @Override
    public Value[] beforeSetValues(JCRNodeWrapper node, String name, ExtendedPropertyDefinition definition, Value[] originalValues) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value[] res = new Value[originalValues.length];
        for (int i = 0; i < originalValues.length; ++i) {
            Value originalValue = originalValues[i];
            res[i] = this.beforeSetValue(node, name, definition, originalValue);
        }
        return res;
    }

    public void setConsiderSiteSettingsForFiltering(boolean considerSiteSettingsForFiltering) {
        this.considerSiteSettingsForFiltering = considerSiteSettingsForFiltering;
    }

    public void setFilteredTags(String tagsToFilter) {
        this.filteredTags = HtmlFilteringInterceptor.convertToTagSet(tagsToFilter);
        if (this.filteredTags == null || this.filteredTags.isEmpty()) {
            logger.info("No HTML tag filtering configured. Interceptor will be disabled.");
        } else {
            logger.info("HTML tag filtering configured fo tags: " + tagsToFilter);
        }
    }

    public void setRemoveContentBetweenTags(boolean removeContentBetweenTags) {
        this.removeContentBetweenTags = removeContentBetweenTags;
    }
}

