/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.interceptor;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.interceptor.PropertyInterceptor;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.JahiaCndReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseInterceptor
implements PropertyInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(BaseInterceptor.class);
    private Set<String> nodeTypes = Collections.emptySet();
    private Set<String> propertyNames = Collections.emptySet();
    private Set<Integer> requiredTypes = Collections.emptySet();
    private Set<Integer> selectors = Collections.emptySet();

    @Override
    public Value afterGetValue(JCRPropertyWrapper property, Value storedValue) throws ValueFormatException, RepositoryException {
        return storedValue;
    }

    @Override
    public Value[] afterGetValues(JCRPropertyWrapper property, Value[] storedValues) throws ValueFormatException, RepositoryException {
        return storedValues;
    }

    @Override
    public void beforeRemove(JCRNodeWrapper node, String name, ExtendedPropertyDefinition definition) throws VersionException, LockException, ConstraintViolationException, RepositoryException {
    }

    @Override
    public Value beforeSetValue(JCRNodeWrapper node, String name, ExtendedPropertyDefinition definition, Value originalValue) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return originalValue;
    }

    @Override
    public Value[] beforeSetValues(JCRNodeWrapper node, String name, ExtendedPropertyDefinition definition, Value[] originalValues) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return originalValues;
    }

    @Override
    public boolean canApplyOnProperty(JCRNodeWrapper node, ExtendedPropertyDefinition definition) throws RepositoryException {
        return !(this.getPropertyNames().size() != 0 && !this.getPropertyNames().contains(definition.getName()) || this.getRequiredTypes().size() != 0 && !this.getRequiredTypes().contains(definition.getRequiredType()) || this.getSelectors().size() != 0 && !this.getSelectors().contains(definition.getSelector()) || this.getNodeTypes().size() != 0 && !JCRContentUtils.isNodeType(node, this.getNodeTypes()));
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BaseInterceptor rhs = (BaseInterceptor)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.getNodeTypes(), rhs.getNodeTypes()).append(this.getRequiredTypes(), rhs.getRequiredTypes()).append(this.getSelectors(), rhs.getSelectors()).append(this.getPropertyNames(), rhs.getPropertyNames()).isEquals();
    }

    protected Set<String> getNodeTypes() {
        return this.nodeTypes;
    }

    protected Set<String> getPropertyNames() {
        return this.propertyNames;
    }

    protected Set<Integer> getRequiredTypes() {
        return this.requiredTypes;
    }

    protected Set<Integer> getSelectors() {
        return this.selectors;
    }

    public int hashCode() {
        return new HashCodeBuilder(19, 37).append(this.getRequiredTypes()).append(this.getSelectors()).append(this.getNodeTypes()).append(this.getPropertyNames()).toHashCode();
    }

    public void setNodeTypes(Set<String> nodeTypes) {
        this.nodeTypes = nodeTypes != null ? nodeTypes : Collections.emptySet();
    }

    public void setPropertyNames(Set<String> propertyNames) {
        this.propertyNames = propertyNames != null ? propertyNames : Collections.emptySet();
    }

    public void setRequiredTypes(Set<String> requiredTypes) {
        if (requiredTypes != null && requiredTypes.size() > 0) {
            this.requiredTypes = new HashSet<Integer>(requiredTypes.size());
            for (String type : requiredTypes) {
                int parsedType = JahiaCndReader.getPropertyType(type);
                if (parsedType >= 0) {
                    this.requiredTypes.add(parsedType);
                    continue;
                }
                logger.error("Unknown property type {}. Skipping.", (Object)type);
            }
        } else {
            this.requiredTypes = Collections.emptySet();
        }
    }

    public void setSelectors(Set<String> selectors) {
        if (selectors != null && selectors.size() > 0) {
            this.selectors = new HashSet<Integer>(selectors.size());
            for (String selector : selectors) {
                int parsedSelector = JahiaCndReader.getSelectorType(selector);
                if (parsedSelector >= 0) {
                    this.selectors.add(parsedSelector);
                    continue;
                }
                logger.error("Unknown property selector {}. Skipping.", (Object)selector);
            }
        } else {
            this.selectors = Collections.emptySet();
        }
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }
}

