/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.files;

import org.apache.commons.lang.builder.ReflectionToStringBuilder;

class FileKey {
    private String cacheKey;
    private String path;
    private String thumbnail;
    private String versionDate;
    private String versionLabel;
    private String workspace;

    FileKey(String workspace, String path) {
        this(workspace, path, null, null, null);
    }

    FileKey(String workspace, String path, String versionDate, String versionLabel, String thumbnail) {
        this.workspace = workspace;
        this.path = path;
        this.versionDate = versionDate;
        this.versionLabel = versionLabel;
        this.thumbnail = thumbnail != null ? thumbnail.replaceAll("[^A-Za-z0-9]+", "") : null;
    }

    public String getCacheKey() {
        if (this.cacheKey == null) {
            StringBuilder key = new StringBuilder(64);
            key.append(this.workspace).append(":").append(this.path).append(":").append(this.versionDate == null ? "0" : this.versionDate).append(":");
            if (this.versionLabel != null) {
                key.append(this.versionLabel);
            }
            this.cacheKey = key.toString();
        }
        return this.cacheKey;
    }

    public String getPath() {
        return this.path;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public String getVersionDate() {
        return this.versionDate;
    }

    public String getVersionLabel() {
        return this.versionLabel;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }
}

