/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.decorator;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.LazyPropertyIterator;
import org.jahia.services.content.decorator.JCRNodeDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRPasswordHistoryEntryNode
extends JCRNodeDecorator {
    private static transient Logger logger = LoggerFactory.getLogger(JCRPasswordHistoryEntryNode.class);
    private static final String PROTECTED_PROPERTY = "j:password";

    public JCRPasswordHistoryEntryNode(JCRNodeWrapper node) {
        super(node);
    }

    private boolean canGetProperty(String propertyName) throws RepositoryException {
        return this.getSession().isSystem() || !PROTECTED_PROPERTY.equals(propertyName);
    }

    @Override
    public PropertyIterator getProperties() throws RepositoryException {
        return this.getSession().isSystem() ? super.getProperties() : new FilteredIterator();
    }

    @Override
    public PropertyIterator getProperties(String s) throws RepositoryException {
        return this.getSession().isSystem() ? super.getProperties(s) : new FilteredIterator(s);
    }

    @Override
    public PropertyIterator getProperties(String[] strings) throws RepositoryException {
        return this.getSession().isSystem() ? super.getProperties(strings) : new FilteredIterator(strings);
    }

    @Override
    public Map<String, String> getPropertiesAsString() throws RepositoryException {
        return this.getSession().isSystem() ? super.getPropertiesAsString() : Maps.filterKeys(super.getPropertiesAsString(), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                try {
                    return JCRPasswordHistoryEntryNode.this.canGetProperty(input);
                }
                catch (RepositoryException e) {
                    return false;
                }
            }
        });
    }

    @Override
    public JCRPropertyWrapper getProperty(String s) throws PathNotFoundException, RepositoryException {
        if (!this.canGetProperty(s)) {
            throw new PathNotFoundException(s);
        }
        return super.getProperty(s);
    }

    @Override
    public String getPropertyAsString(String name) {
        try {
            return this.canGetProperty(name) ? super.getPropertyAsString(name) : null;
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean hasProperty(String s) throws RepositoryException {
        return super.hasProperty(s) && this.canGetProperty(s);
    }

    private class FilteredIterator
    extends LazyPropertyIterator {
        public FilteredIterator() throws RepositoryException {
            super(JCRPasswordHistoryEntryNode.this, JCRPasswordHistoryEntryNode.this.getSession().getLocale());
        }

        public FilteredIterator(String singlePattern) throws RepositoryException {
            super((JCRNodeWrapper)JCRPasswordHistoryEntryNode.this, JCRPasswordHistoryEntryNode.this.getSession().getLocale(), singlePattern);
        }

        public FilteredIterator(String[] patternArray) throws RepositoryException {
            super((JCRNodeWrapper)JCRPasswordHistoryEntryNode.this, JCRPasswordHistoryEntryNode.this.getSession().getLocale(), patternArray);
        }

        @Override
        public boolean hasNext() {
            while (super.hasNext()) {
                try {
                    if (!JCRPasswordHistoryEntryNode.this.canGetProperty(this.tempNext.getName())) {
                        this.tempNext = null;
                        continue;
                    }
                    return true;
                }
                catch (RepositoryException e) {
                    this.tempNext = null;
                    logger.error("Cannot read property", (Throwable)e);
                }
            }
            return false;
        }
    }
}

