/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.DefaultEventListener;
import org.jahia.services.content.ExternalEventListener;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.JCRStoreProviderChecker;
import org.jahia.services.content.JCRStoreService;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.ProviderFactory;
import org.jahia.services.content.decorator.JCRMountPointNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MountPointListener
extends DefaultEventListener
implements ExternalEventListener {
    private static final Logger logger = LoggerFactory.getLogger(MountPointListener.class);
    private static final String[] NODETYPES = new String[]{"jnt:mountPoint"};
    private JCRStoreProviderChecker providerChecker;
    private static final ThreadLocal<Boolean> inListener = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    public void setProviderChecker(JCRStoreProviderChecker providerChecker) {
        this.providerChecker = providerChecker;
    }

    @Override
    public int getEventTypes() {
        return 31;
    }

    @Override
    public String[] getNodeTypes() {
        return NODETYPES;
    }

    @Override
    public String getPath() {
        return "/mounts";
    }

    private void mount(final String uuid, final JCRStoreProvider provider) {
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Boolean>(){

                @Override
                public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    JCRNodeWrapper node = session.getNodeByIdentifier(uuid);
                    if (!(node instanceof JCRMountPointNode)) {
                        return false;
                    }
                    ProviderFactory providerFactory = JCRStoreService.getInstance().getProviderFactories().get(node.getPrimaryNodeTypeName());
                    if (providerFactory == null) {
                        return false;
                    }
                    JCRMountPointNode mountPoint = (JCRMountPointNode)node;
                    if (mountPoint.getMountStatus() == JCRMountPointNode.MountStatus.waiting && provider != null) {
                        MountPointListener.this.providerChecker.checkPeriodically(provider);
                    } else if (mountPoint.getMountStatus() == JCRMountPointNode.MountStatus.mounted) {
                        JCRNodeWrapper mountPointTarget = mountPoint.getVirtualMountPointNode();
                        logger.info("Mounting the provider {} to {}", (Object)uuid, (Object)mountPointTarget.getPath());
                        JCRStoreProvider provider2 = providerFactory.mountProvider(mountPointTarget);
                        if (!provider2.isAvailable(true)) {
                            logger.warn("Issue while trying to mount an external provider ({}) upon startup, all references to file coming from this mount won't be available until it is fixed. If you are migrating from Jahia 6.6 this might be normal until the migration scripts have been completed.", (Object)mountPointTarget.getPath());
                            mountPoint.setMountStatus(JCRMountPointNode.MountStatus.waiting);
                            session.save();
                            MountPointListener.this.providerChecker.checkPeriodically(provider2);
                        }
                    }
                    return true;
                }
            });
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(EventIterator events) {
        if (inListener.get().booleanValue()) {
            return;
        }
        try {
            inListener.set(true);
            LinkedHashMap<String, Integer> changeLog = new LinkedHashMap<String, Integer>(1);
            while (events.hasNext()) {
                try {
                    String propertyName;
                    Event evt = events.nextEvent();
                    int evtType = evt.getType();
                    if ((evtType & 0x1C) != 0 && this.propertiesToIgnore.contains(propertyName = StringUtils.substringAfterLast((String)evt.getPath(), (String)"/"))) continue;
                    this.setStatus(changeLog, evt.getIdentifier(), evtType);
                }
                catch (RepositoryException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            for (Map.Entry change : changeLog.entrySet()) {
                String uuid = (String)change.getKey();
                Integer status = (Integer)change.getValue();
                JCRStoreProvider p = JCRStoreService.getInstance().getSessionFactory().getProviders().get(uuid);
                this.unmount(uuid, p);
                if (status == 2) continue;
                this.mount(uuid, p);
            }
        }
        finally {
            inListener.set(false);
        }
    }

    private void setStatus(Map<String, Integer> changeLog, String identifier, int evtType) {
        Integer status = changeLog.get(identifier);
        if (status == null) {
            changeLog.put(identifier, evtType);
        } else if ((evtType & 3) != 0) {
            changeLog.put(identifier, evtType);
        }
    }

    private void unmount(String uuid, JCRStoreProvider p) {
        this.providerChecker.remove(uuid);
        if (p != null) {
            logger.info("Unmounting the provider {} with key {}", (Object)p.getMountPoint(), (Object)p.getKey());
            p.stop();
        }
    }
}

