/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.ArrayList;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.apache.jackrabbit.core.observation.EventImpl;
import org.apache.jackrabbit.core.observation.SynchronousEventListener;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRObservationManager;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRObservationManagerDispatcher
implements SynchronousEventListener {
    private static final Logger logger = LoggerFactory.getLogger(JCRObservationManagerDispatcher.class);
    private String workspace;
    private String mountPoint;
    private String relativeRoot;

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public String getMountPoint() {
        return this.mountPoint;
    }

    public void setMountPoint(String mountPoint) {
        this.mountPoint = mountPoint;
    }

    public String getRelativeRoot() {
        return this.relativeRoot;
    }

    public void setRelativeRoot(String relativeRoot) {
        this.relativeRoot = relativeRoot;
    }

    public void onEvent(EventIterator events) {
        ArrayList<Event> external = null;
        while (events.hasNext()) {
            Event event = events.nextEvent();
            if (event instanceof EventImpl && !((EventImpl)event).isExternal()) {
                JCRObservationManager.addEvent(event, this.mountPoint, this.relativeRoot);
                continue;
            }
            if (external == null) {
                external = new ArrayList<Event>();
            }
            external.add(event);
        }
        if (external != null) {
            final ArrayList<Event> fexternal = external;
            try {
                JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, this.workspace, null, new JCRCallback<Object>(){

                    @Override
                    public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                        ArrayList<JCRObservationManager.EventWrapper> eventWrappers = new ArrayList<JCRObservationManager.EventWrapper>();
                        for (Event event : fexternal) {
                            if (!event.getPath().equals(JCRObservationManagerDispatcher.this.relativeRoot) && !event.getPath().startsWith(JCRObservationManagerDispatcher.this.relativeRoot + '/')) continue;
                            eventWrappers.add(JCRObservationManager.getEventWrapper(event, session, JCRObservationManagerDispatcher.this.mountPoint, JCRObservationManagerDispatcher.this.relativeRoot));
                        }
                        JCRObservationManager.consume(eventWrappers, session, 12, 12);
                        return null;
                    }
                });
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

