/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.categories.jcr;

import java.io.Serializable;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.jahia.services.categories.CategoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRCategory
implements CategoryBean,
Serializable {
    private static final long serialVersionUID = -7647957842076042700L;
    private static transient Logger logger = LoggerFactory.getLogger(JCRCategory.class);
    private String id;
    private String key;
    private String path;
    private Node categoryNode;

    public JCRCategory(Node categoryNode) {
        this.categoryNode = categoryNode;
        try {
            this.id = categoryNode.getUUID();
            this.key = categoryNode.getName();
            this.path = categoryNode.getPath();
        }
        catch (RepositoryException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public Node getCategoryNode() {
        return this.categoryNode;
    }
}

