/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.atmosphere;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.util.ServletContextFactory;
import org.jahia.settings.SettingsBean;

public class AtmosphereServlet
extends org.atmosphere.cpr.AtmosphereServlet {
    private static final String DEFAULT_ASYNC_SUPPORT = "org.atmosphere.container.Servlet30CometSupport";
    private static final long serialVersionUID = 7618272237237696835L;

    public static BroadcasterFactory getBroadcasterFactory() {
        return (BroadcasterFactory)ServletContextFactory.getDefault().getServletContext().getAttribute(BroadcasterFactory.class.getName());
    }

    public void init(final ServletConfig sc) throws ServletException {
        ServletConfig scFacade;
        String asyncSupport = SettingsBean.getInstance().getAtmosphereAsyncSupport();
        if (StringUtils.isNotEmpty((String)asyncSupport) || sc.getInitParameter("org.atmosphere.cpr.asyncSupport") == null) {
            final String implName = StringUtils.defaultIfBlank((String)asyncSupport, (String)DEFAULT_ASYNC_SUPPORT);
            scFacade = new ServletConfig(){

                public String getInitParameter(String name) {
                    return "org.atmosphere.cpr.asyncSupport".equals(name) ? implName : sc.getInitParameter(name);
                }

                public Enumeration<String> getInitParameterNames() {
                    ArrayList names = Lists.newArrayList((Object[])new String[]{"org.atmosphere.cpr.asyncSupport"});
                    CollectionUtils.addAll((Collection)names, (Enumeration)sc.getInitParameterNames());
                    return Collections.enumeration(names);
                }

                public ServletContext getServletContext() {
                    return sc.getServletContext();
                }

                public String getServletName() {
                    return sc.getServletName();
                }
            };
        } else {
            scFacade = sc;
        }
        super.init(scFacade);
    }
}

