/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.applications.pluto;

import java.util.Map;
import javax.portlet.WindowState;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.driver.config.AdminConfiguration;
import org.apache.pluto.driver.config.DriverConfiguration;
import org.apache.pluto.driver.core.PortalRequestContext;
import org.apache.pluto.driver.core.PortletWindowImpl;
import org.apache.pluto.driver.services.portal.PortletWindowConfig;
import org.apache.pluto.driver.url.PortalURL;
import org.jahia.data.applications.EntryPointInstance;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.services.applications.DispatchingProvider;
import org.jahia.services.applications.pluto.JahiaContextRequest;
import org.jahia.services.applications.pluto.JahiaPortalServletRequest;
import org.jahia.services.applications.pluto.JahiaPortalServletResponse;
import org.jahia.services.applications.pluto.JahiaPortletUtil;
import org.jahia.services.usermanager.JahiaUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlutoDispatchingProvider
implements DispatchingProvider {
    private static Logger logger = LoggerFactory.getLogger(PlutoDispatchingProvider.class);
    PortletContainer portletContainer;
    DriverConfiguration driverConfiguration;
    AdminConfiguration adminConfiguration;

    @Override
    public void start() throws JahiaInitializationException {
    }

    @Override
    public void stop() {
    }

    @Override
    public String render(EntryPointInstance entryPointInstance, String windowID, JahiaUser jahiaUser, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServletContext servletContext, String workspaceName) throws JahiaException {
        String cacheKey = null;
        if (entryPointInstance.getExpirationTime() != 0L) {
            cacheKey = "portlet_instance_" + windowID;
            if (entryPointInstance.getCacheScope().equals("portlet.private-scope")) {
                cacheKey = cacheKey + "_" + jahiaUser.getUserKey();
            }
        }
        JahiaContextRequest jahiaContextRequest = new JahiaContextRequest(jahiaUser, httpServletRequest, workspaceName);
        jahiaContextRequest.setEntryPointInstance(entryPointInstance);
        new PortalRequestContext(servletContext, (HttpServletRequest)jahiaContextRequest, httpServletResponse);
        String defName = entryPointInstance.getDefName();
        PortletWindowConfig windowConfig = PortletWindowConfig.fromId((String)((defName.startsWith(".") ? "/" : "") + defName + "!" + windowID));
        windowConfig.setContextPath(entryPointInstance.getContextName());
        if (logger.isDebugEnabled()) {
            logger.debug("Rendering Portlet Window: " + windowConfig);
        }
        PortalRequestContext portalEnv = PortalRequestContext.getContext((HttpServletRequest)jahiaContextRequest);
        PortalURL portalURL = portalEnv.getRequestedPortalURL();
        PortletContainer container = (PortletContainer)servletContext.getAttribute("portletContainer");
        PortletWindowImpl window = new PortletWindowImpl(container, windowConfig, portalURL);
        Map windowStates = portalURL.getWindowStates();
        for (String windowId : windowStates.keySet()) {
            WindowState windowState = (WindowState)windowStates.get(windowId);
            if (!WindowState.MAXIMIZED.equals((Object)windowState) || window.getId().getStringId().equals(windowId)) continue;
            return "";
        }
        JahiaPortalServletRequest portalRequest = new JahiaPortalServletRequest(entryPointInstance, jahiaUser, httpServletRequest, (PortletWindow)window, workspaceName);
        JahiaPortletUtil.copyJahiaAttributes(entryPointInstance, httpServletRequest, (PortletWindow)window, (HttpServletRequest)portalRequest, false, workspaceName);
        JahiaPortalServletResponse portalResponse = new JahiaPortalServletResponse(httpServletResponse);
        try {
            Map<String, Object> map = JahiaPortletUtil.filterJahiaAttributes((HttpServletRequest)portalRequest);
            container.doRender((PortletWindow)window, (HttpServletRequest)portalRequest, (HttpServletResponse)portalResponse);
            JahiaPortletUtil.setJahiaAttributes((HttpServletRequest)portalRequest, map);
        }
        catch (Exception th) {
            logger.error("Error while rendering portlet", (Throwable)th);
        }
        String portletRendering = portalResponse.getInternalBuffer().getBuffer().toString();
        if (cacheKey != null) {
            // empty if block
        }
        return portletRendering;
    }
}

