/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.applications.pluto;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.portlet.PortletRequest;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.PortletPreference;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.impl.PortletPreferenceImpl;
import org.apache.pluto.driver.container.DefaultPortletPreferencesService;
import org.jahia.services.applications.pluto.JahiaPortletPreference;
import org.jahia.services.preferences.JahiaPreference;
import org.jahia.services.preferences.JahiaPreferencesProvider;
import org.jahia.services.preferences.JahiaPreferencesQueryHelper;
import org.jahia.services.preferences.JahiaPreferencesService;
import org.jahia.services.preferences.exception.JahiaPreferenceProviderException;
import org.jahia.services.usermanager.JahiaUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaPortletPreferencesServiceImpl
extends DefaultPortletPreferencesService {
    private static final Logger logger = LoggerFactory.getLogger(JahiaPortletPreferencesServiceImpl.class);
    private JahiaPreferencesService jahiaPreferencesService;

    public JahiaPreferencesService getJahiaPreferencesService() {
        return this.jahiaPreferencesService;
    }

    public void setJahiaPreferencesService(JahiaPreferencesService jahiaPreferencesService) {
        this.jahiaPreferencesService = jahiaPreferencesService;
    }

    public Map<String, PortletPreference> getStoredPreferences(PortletWindow portletWindow, PortletRequest request) throws PortletContainerException {
        try {
            JahiaPreferencesProvider portletPreferenceProvider = this.jahiaPreferencesService.getPreferencesProviderByType("portlet");
            JahiaUser jahiaUser = (JahiaUser)request.getUserPrincipal();
            String portletName = portletWindow.getPortletDefinition().getApplication().getContextPath() + "." + portletWindow.getPortletDefinition().getPortletName();
            List foundPreferences = portletPreferenceProvider.findJahiaPreferences(jahiaUser, JahiaPreferencesQueryHelper.getPortletSQL(portletName));
            if (foundPreferences == null) {
                return new HashMap<String, PortletPreference>();
            }
            HashMap<String, PortletPreference> portletPreferences = new HashMap<String, PortletPreference>();
            for (JahiaPreference currentPreference : foundPreferences) {
                JahiaPortletPreference curPortletPreference = (JahiaPortletPreference)currentPreference.getNode();
                PortletPreferenceImpl portletPreferenceImpl = new PortletPreferenceImpl(curPortletPreference.getPrefName(), curPortletPreference.getValues(), curPortletPreference.getReadOnly().booleanValue());
                portletPreferences.put(portletPreferenceImpl.getName(), (PortletPreference)portletPreferenceImpl);
            }
            return portletPreferences;
        }
        catch (JahiaPreferenceProviderException e) {
            logger.error("Error while retrieving portlet preferences", (Throwable)e);
        }
        catch (RepositoryException e) {
            logger.error("Error while retrieving portlet preferences", (Throwable)e);
        }
        return null;
    }

    public void store(PortletWindow portletWindow, PortletRequest request, Map<String, PortletPreference> stringPortletPreferenceMap) throws PortletContainerException {
        try {
            JahiaPreferencesProvider portletPreferenceProvider = this.jahiaPreferencesService.getPreferencesProviderByType("portlet");
            Collection<PortletPreference> preferences = stringPortletPreferenceMap.values();
            for (PortletPreference curPlutoPreference : preferences) {
                JahiaPortletPreference node;
                String portletName = portletWindow.getPortletDefinition().getApplication().getContextPath() + "." + portletWindow.getPortletDefinition().getPortletName();
                JahiaPreference portletPreference = portletPreferenceProvider.getJahiaPreference(request.getUserPrincipal(), JahiaPreferencesQueryHelper.getPortletSQL(portletName, curPlutoPreference.getName()));
                if (portletPreference == null) {
                    portletPreference = portletPreferenceProvider.createJahiaPreferenceNode(request.getUserPrincipal());
                    node = (JahiaPortletPreference)portletPreference.getNode();
                    node.setPortletName(portletName);
                    node.setPrefName(curPlutoPreference.getName());
                } else if (curPlutoPreference.getValues() == null) {
                    portletPreferenceProvider.deleteJahiaPreference(portletPreference);
                }
                if (curPlutoPreference.getValues() == null) continue;
                node = (JahiaPortletPreference)portletPreference.getNode();
                node.setReadOnly(curPlutoPreference.isReadOnly());
                node.setValues(curPlutoPreference.getValues());
                portletPreferenceProvider.setJahiaPreference(portletPreference);
            }
        }
        catch (JahiaPreferenceProviderException e) {
            logger.error("Error while storing portlet preferences", (Throwable)e);
        }
        catch (RepositoryException e) {
            logger.error("Error while retrieving portlet preferences", (Throwable)e);
        }
    }
}

