/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.portlets;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventPortlet;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceServingPortlet;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.UnavailableException;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.pluto.container.FilterManager;
import org.apache.pluto.container.PortletInvokerService;
import org.apache.pluto.container.PortletRequestContext;
import org.apache.pluto.container.PortletResponseContext;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.driver.AdministrativeRequestListener;
import org.apache.pluto.container.driver.DriverPortletConfig;
import org.apache.pluto.container.driver.DriverPortletContext;
import org.apache.pluto.container.driver.PlutoServices;
import org.apache.pluto.container.driver.PortalAdministrationService;
import org.apache.pluto.container.driver.PortletContextService;
import org.apache.pluto.container.driver.PortletInvocationEvent;
import org.apache.pluto.container.driver.PortletInvocationListener;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.jahia.bin.Jahia;
import org.jahia.services.applications.pluto.JahiaPortalServletRequest;
import org.jahia.services.content.JCRStoreService;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.content.nodetypes.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(PortletServlet.class);
    private static final long serialVersionUID = -5096339022539360365L;
    private String portletName;
    private Map<String, Portlet> portlets = new HashMap<String, Portlet>();
    private DriverPortletContext portletContext;
    private Map<String, DriverPortletConfig> portletConfigs = new HashMap<String, DriverPortletConfig>();
    private Map<String, EventPortlet> eventPortlets = new HashMap<String, EventPortlet>();
    private Map<String, ResourceServingPortlet> resourceServingPortlets = new HashMap<String, ResourceServingPortlet>();
    private PortletContextService contextService;
    private boolean started = false;
    private Timer startTimer;

    public String getServletInfo() {
        return "Pluto PortletServlet [" + this.portletName + "]";
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.portletName = this.getInitParameter("portlet-name");
        this.started = false;
        this.startTimer = new Timer(true);
        final ServletContext servletContext = this.getServletContext();
        final ClassLoader paClassLoader = Thread.currentThread().getContextClassLoader();
        this.startTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ServletContext servletContext2 = servletContext;
                synchronized (servletContext2) {
                    if (PortletServlet.this.startTimer != null && PortletServlet.this.attemptRegistration(servletContext, paClassLoader)) {
                        PortletServlet.this.startTimer.cancel();
                        PortletServlet.this.startTimer = null;
                    }
                }
            }
        }, 1L, 10000L);
    }

    protected boolean attemptRegistration(ServletContext context, ClassLoader paClassLoader) {
        if (PlutoServices.getServices() != null) {
            this.contextService = PlutoServices.getServices().getPortletContextService();
            File[] fragments = null;
            String fragmentsPath = this.getServletContext().getRealPath("/WEB-INF/fragments");
            if (StringUtils.isNotEmpty((String)fragmentsPath)) {
                try {
                    fragments = new File(fragmentsPath).listFiles();
                }
                catch (Exception e) {
                    logger.warn("Unable to list contentr of the /WEB-INF/fragments directory for internal portlets.", (Throwable)e);
                }
            }
            for (int i = 0; fragments != null && i < fragments.length; ++i) {
                try {
                    File fragment = fragments[i];
                    this.log("Processing fragment " + fragment);
                    ServletConfigWrapper config = new ServletConfigWrapper(this.getServletConfig(), fragment.getName());
                    String applicationName = this.contextService.register((ServletConfig)config);
                    this.portletContext = this.contextService.getPortletContext(applicationName);
                    List portlets = this.contextService.getPortletContext(applicationName).getPortletApplicationDefinition().getPortlets();
                    for (PortletDefinition portletDD : portlets) {
                        this.portletConfigs.put(Jahia.getContextPath() + "/" + fragment.getName() + "." + portletDD.getPortletName(), this.contextService.getPortletConfig(applicationName, portletDD.getPortletName()));
                    }
                    continue;
                }
                catch (Exception ex) {
                    this.log("Error while registering portlet", ex);
                }
            }
            this.started = true;
            for (Map.Entry<String, DriverPortletConfig> entry : this.portletConfigs.entrySet()) {
                DriverPortletConfig portletConfig = entry.getValue();
                PortletDefinition portletDD = portletConfig.getPortletDefinition();
                try {
                    Class<?> clazz = paClassLoader.loadClass(portletDD.getPortletClass());
                    Portlet portlet = (Portlet)clazz.newInstance();
                    String rootPath = portletConfig.getInitParameter("rootPath");
                    String realPath = portletConfig.getPortletContext().getRealPath(rootPath + "/definitions.cnd");
                    if (new File(realPath).exists()) {
                        try {
                            NodeTypeRegistry.getInstance().addDefinitionsFile(new File(realPath), portletConfig.getPortletName(), null);
                            JCRStoreService.getInstance().deployDefinitions(portletConfig.getPortletName());
                        }
                        catch (IOException | ParseException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    portlet.init((PortletConfig)portletConfig);
                    this.portlets.put(entry.getKey(), portlet);
                    this.initializeEventPortlet();
                    this.initializeResourceServingPortlet();
                }
                catch (Exception ex) {
                    context.log(ex.getMessage(), (Throwable)ex);
                }
            }
            return true;
        }
        return false;
    }

    public void destroy() {
        for (Portlet portlet : this.portlets.values()) {
            this.destroy(portlet);
        }
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy(Portlet portlet) {
        ServletContext servletContext = this.getServletContext();
        synchronized (servletContext) {
            if (this.startTimer != null) {
                this.startTimer.cancel();
                this.startTimer = null;
            } else if (this.started && this.portletContext != null) {
                this.started = false;
                this.contextService.unregister(this.portletContext);
                if (portlet != null) {
                    try {
                        portlet.destroy();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    portlet = null;
                }
            }
            super.destroy();
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.dispatch(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.dispatch(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.dispatch(request, response);
    }

    private void dispatch(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String id = ((JahiaPortalServletRequest)request).getId();
        String portletName = "/" + id.substring(0, id.indexOf("!"));
        Portlet portlet = this.portlets.get(portletName);
        if (portlet == null) {
            throw new UnavailableException("Portlet " + portletName + " unavailable");
        }
        EventPortlet eventPortlet = this.eventPortlets.get(portletName);
        ResourceServingPortlet resourceServingPortlet = this.resourceServingPortlets.get(portletName);
        Integer methodId = (Integer)request.getAttribute("org.apache.pluto.core.method");
        PortletRequest portletRequest = (PortletRequest)request.getAttribute("javax.portlet.request");
        PortletResponse portletResponse = (PortletResponse)request.getAttribute("javax.portlet.response");
        PortletRequestContext requestContext = (PortletRequestContext)portletRequest.getAttribute(PortletInvokerService.REQUEST_CONTEXT);
        PortletResponseContext responseContext = (PortletResponseContext)portletRequest.getAttribute(PortletInvokerService.RESPONSE_CONTEXT);
        FilterManager filterManager = (FilterManager)request.getAttribute("FilterManager");
        request.removeAttribute("org.apache.pluto.core.method");
        request.removeAttribute("javax.portlet.request");
        request.removeAttribute("javax.portlet.response");
        request.removeAttribute("FilterManager");
        DriverPortletConfig portletConfig = this.portletConfigs.get(portletName);
        requestContext.init((PortletConfig)portletConfig, this.getServletContext(), request, response);
        responseContext.init(request, response);
        PortletWindow window = requestContext.getPortletWindow();
        PortletInvocationEvent event = new PortletInvocationEvent(portletRequest, window, methodId.intValue());
        this.notify(event, true, null);
        try {
            if (methodId == PortletInvokerService.METHOD_RENDER) {
                RenderRequest renderRequest = (RenderRequest)portletRequest;
                RenderResponse renderResponse = (RenderResponse)portletResponse;
                filterManager.processFilter(renderRequest, renderResponse, portlet, (PortletContext)this.portletContext);
            } else if (methodId == PortletInvokerService.METHOD_RESOURCE) {
                ResourceRequest resourceRequest = (ResourceRequest)portletRequest;
                ResourceResponse resourceResponse = (ResourceResponse)portletResponse;
                filterManager.processFilter(resourceRequest, resourceResponse, resourceServingPortlet, (PortletContext)this.portletContext);
            } else if (methodId == PortletInvokerService.METHOD_ACTION) {
                ActionRequest actionRequest = (ActionRequest)portletRequest;
                ActionResponse actionResponse = (ActionResponse)portletResponse;
                filterManager.processFilter(actionRequest, actionResponse, portlet, (PortletContext)this.portletContext);
            } else if (methodId == PortletInvokerService.METHOD_EVENT) {
                EventRequest eventRequest = (EventRequest)portletRequest;
                EventResponse eventResponse = (EventResponse)portletResponse;
                filterManager.processFilter(eventRequest, eventResponse, eventPortlet, (PortletContext)this.portletContext);
            } else if (methodId == PortletInvokerService.METHOD_ADMIN) {
                PortalAdministrationService pas = PlutoServices.getServices().getPortalAdministrationService();
                for (AdministrativeRequestListener l : pas.getAdministrativeRequestListeners()) {
                    l.administer(portletRequest, portletResponse);
                }
            } else if (methodId == PortletInvokerService.METHOD_LOAD) {
                // empty if block
            }
            this.notify(event, false, null);
        }
        catch (PortletException ex) {
            this.notify(event, false, ex);
            throw new ServletException((Throwable)ex);
        }
    }

    protected void notify(PortletInvocationEvent event, boolean pre, Throwable e) {
        PortalAdministrationService pas = PlutoServices.getServices().getPortalAdministrationService();
        for (PortletInvocationListener listener : pas.getPortletInvocationListeners()) {
            if (pre) {
                listener.onBegin(event);
                continue;
            }
            if (e == null) {
                listener.onEnd(event);
                continue;
            }
            listener.onError(event, e);
        }
    }

    private void initializeEventPortlet() {
        for (Map.Entry<String, Portlet> entry : this.portlets.entrySet()) {
            if (entry.getValue() instanceof EventPortlet) {
                this.eventPortlets.put(entry.getKey(), (EventPortlet)entry.getValue());
                continue;
            }
            this.eventPortlets.put(entry.getKey(), new NullPortlet());
        }
    }

    private void initializeResourceServingPortlet() {
        for (Map.Entry<String, Portlet> entry : this.portlets.entrySet()) {
            if (entry.getValue() instanceof ResourceServingPortlet) {
                this.resourceServingPortlets.put(entry.getKey(), (ResourceServingPortlet)entry.getValue());
                continue;
            }
            this.resourceServingPortlets.put(entry.getKey(), new NullPortlet());
        }
    }

    class ServletContextWrapper
    implements ServletContext {
        private ServletContext deleguee;
        private String contextPath;

        ServletContextWrapper(ServletContext deleguee, String contextPath) {
            this.deleguee = deleguee;
            this.contextPath = contextPath;
        }

        public String getContextPath() {
            return Jahia.getContextPath() + "/" + this.contextPath;
        }

        public ServletContext getContext(String s) {
            return this.deleguee.getContext(s);
        }

        public int getMajorVersion() {
            return this.deleguee.getMajorVersion();
        }

        public int getMinorVersion() {
            return this.deleguee.getMinorVersion();
        }

        public int getEffectiveMajorVersion() {
            return 0;
        }

        public int getEffectiveMinorVersion() {
            return 0;
        }

        public String getMimeType(String s) {
            return this.deleguee.getMimeType(s);
        }

        public Set getResourcePaths(String s) {
            return this.deleguee.getResourcePaths(s);
        }

        public URL getResource(String s) throws MalformedURLException {
            return this.deleguee.getResource(s);
        }

        public InputStream getResourceAsStream(String s) {
            if (s.equals("/WEB-INF/portlet.xml")) {
                return this.deleguee.getResourceAsStream("/WEB-INF/fragments/" + this.contextPath + "/portlet.xml");
            }
            return this.deleguee.getResourceAsStream(s);
        }

        public RequestDispatcher getRequestDispatcher(String s) {
            return this.deleguee.getRequestDispatcher(s);
        }

        public RequestDispatcher getNamedDispatcher(String s) {
            return this.deleguee.getNamedDispatcher(s);
        }

        public Servlet getServlet(String s) throws ServletException {
            return this.deleguee.getServlet(s);
        }

        public Enumeration getServlets() {
            return this.deleguee.getServlets();
        }

        public Enumeration getServletNames() {
            return this.deleguee.getServletNames();
        }

        public void log(String s) {
            logger.info(s);
            this.deleguee.log(s);
        }

        public void log(Exception e, String s) {
            logger.error(s, (Throwable)e);
            this.deleguee.log(e, s);
        }

        public void log(String s, Throwable throwable) {
            logger.error(s, throwable);
            this.deleguee.log(s, throwable);
        }

        public String getRealPath(String s) {
            return this.deleguee.getRealPath(s);
        }

        public String getServerInfo() {
            return this.deleguee.getServerInfo();
        }

        public String getInitParameter(String s) {
            if ("org.apache.pluto.CONTEXT_PATH".equals(s)) {
                return new String(Jahia.getContextPath() + "/" + this.contextPath);
            }
            return this.deleguee.getInitParameter(s);
        }

        public Enumeration getInitParameterNames() {
            return this.deleguee.getInitParameterNames();
        }

        public boolean setInitParameter(String s, String s2) {
            return false;
        }

        public Object getAttribute(String s) {
            return this.deleguee.getAttribute(s);
        }

        public Enumeration getAttributeNames() {
            return this.deleguee.getAttributeNames();
        }

        public void setAttribute(String s, Object o) {
            this.deleguee.setAttribute(s, o);
        }

        public void removeAttribute(String s) {
            this.deleguee.removeAttribute(s);
        }

        public String getServletContextName() {
            return this.deleguee.getServletContextName();
        }

        public ServletRegistration.Dynamic addServlet(String s, String s2) {
            return null;
        }

        public ServletRegistration.Dynamic addServlet(String s, Servlet servlet) {
            return null;
        }

        public ServletRegistration.Dynamic addServlet(String s, Class<? extends Servlet> aClass) {
            return null;
        }

        public <T extends Servlet> T createServlet(Class<T> tClass) throws ServletException {
            return null;
        }

        public ServletRegistration getServletRegistration(String s) {
            return null;
        }

        public Map<String, ? extends ServletRegistration> getServletRegistrations() {
            return null;
        }

        public FilterRegistration.Dynamic addFilter(String s, String s2) {
            return null;
        }

        public FilterRegistration.Dynamic addFilter(String s, Filter filter) {
            return null;
        }

        public FilterRegistration.Dynamic addFilter(String s, Class<? extends Filter> aClass) {
            return null;
        }

        public <T extends Filter> T createFilter(Class<T> tClass) throws ServletException {
            return null;
        }

        public FilterRegistration getFilterRegistration(String s) {
            return null;
        }

        public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
            return null;
        }

        public SessionCookieConfig getSessionCookieConfig() {
            return null;
        }

        public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        }

        public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
            return null;
        }

        public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
            return null;
        }

        public void addListener(String s) {
        }

        public <T extends EventListener> void addListener(T t) {
        }

        public void addListener(Class<? extends EventListener> aClass) {
        }

        public <T extends EventListener> T createListener(Class<T> tClass) throws ServletException {
            return null;
        }

        public JspConfigDescriptor getJspConfigDescriptor() {
            return null;
        }

        public ClassLoader getClassLoader() {
            return null;
        }

        public void declareRoles(String ... strings) {
        }
    }

    class ServletConfigWrapper
    implements ServletConfig {
        private ServletConfig deleguee;
        private String contextPath;

        ServletConfigWrapper(ServletConfig deleguee, String contextPath) {
            this.deleguee = deleguee;
            this.contextPath = contextPath;
        }

        public String getServletName() {
            return this.deleguee.getServletName();
        }

        public ServletContext getServletContext() {
            return new ServletContextWrapper(this.deleguee.getServletContext(), this.contextPath);
        }

        public String getInitParameter(String s) {
            return this.deleguee.getInitParameter(s);
        }

        public Enumeration getInitParameterNames() {
            return this.deleguee.getInitParameterNames();
        }
    }

    static class NullPortlet
    implements EventPortlet,
    ResourceServingPortlet,
    Portlet {
        NullPortlet() {
        }

        public void processEvent(EventRequest arg0, EventResponse arg1) throws PortletException, IOException {
        }

        public void serveResource(ResourceRequest arg0, ResourceResponse arg1) throws PortletException, IOException {
        }

        public void destroy() {
        }

        public void init(PortletConfig arg0) throws PortletException {
        }

        public void processAction(ActionRequest arg0, ActionResponse arg1) throws PortletException, IOException {
        }

        public void render(RenderRequest arg0, RenderResponse arg1) throws PortletException, IOException {
        }
    }
}

