/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.params.valves;

import javax.servlet.http.HttpSession;
import org.jahia.params.valves.AuthValveContext;
import org.jahia.params.valves.BaseAuthValve;
import org.jahia.pipelines.PipelineException;
import org.jahia.pipelines.valves.ValveContext;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;

public class SessionAuthValveImpl
extends BaseAuthValve {
    private JahiaUserManagerService userManagerService;

    @Override
    public void invoke(Object context, ValveContext valveContext) throws PipelineException {
        if (!this.isEnabled()) {
            valveContext.invokeNext(context);
            return;
        }
        AuthValveContext authContext = (AuthValveContext)context;
        JahiaUser jahiaUser = null;
        HttpSession session = authContext.getRequest().getSession(false);
        if (session != null) {
            try {
                jahiaUser = (JahiaUser)session.getAttribute("org.jahia.usermanager.jahiauser");
            }
            catch (IllegalStateException ise) {
                // empty catch block
            }
        }
        if (jahiaUser != null) {
            JCRUserNode userNode = this.userManagerService.lookupUser(jahiaUser.getName(), jahiaUser.getRealm(), false);
            JahiaUser jahiaUser2 = jahiaUser = userNode != null ? userNode.getJahiaUser() : null;
        }
        if (jahiaUser == null || JahiaUserManagerService.isGuest(jahiaUser)) {
            valveContext.invokeNext(context);
        } else {
            if (session != null) {
                authContext.setAuthRetrievedFromSession(true);
            }
            authContext.getSessionFactory().setCurrentUser(jahiaUser);
        }
    }

    public void setUserManagerService(JahiaUserManagerService userManagerService) {
        this.userManagerService = userManagerService;
    }
}

