/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.params.valves;

import org.jahia.params.valves.BaseAuthValve;
import org.jahia.pipelines.PipelineException;
import org.jahia.pipelines.impl.GenericPipeline;
import org.jahia.pipelines.valves.ValveContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class AutoRegisteredBaseAuthValve
extends BaseAuthValve
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(AutoRegisteredBaseAuthValve.class);
    private GenericPipeline authPipeline;
    private int position = -1;
    private String positionAfter;
    private String positionBefore;

    public void afterPropertiesSet() {
        this.initialize();
        this.authPipeline.removeValve(new AuthValveStub(this.getId()));
        int index = -1;
        if (this.position >= 0) {
            index = this.position;
        } else if (this.positionBefore != null) {
            index = this.authPipeline.indexOf(new AuthValveStub(this.positionBefore));
        } else if (this.positionAfter != null) {
            index = this.authPipeline.indexOf(new AuthValveStub(this.positionAfter));
            if (index != -1) {
                ++index;
            }
            if (index >= this.authPipeline.getValves().length) {
                index = -1;
            }
        }
        if (index != -1) {
            this.authPipeline.addValve(index, this);
            logger.info("Registered authentication valve {} at position {}", (Object)this.getId(), (Object)index);
        } else {
            this.authPipeline.addValve(this);
            logger.info("Registered authentication valve {}", (Object)this.getId());
        }
    }

    public void setAuthPipeline(GenericPipeline authPipeline) {
        this.authPipeline = authPipeline;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setPositionAfter(String positionAfter) {
        this.positionAfter = positionAfter;
    }

    public void setPositionBefore(String positionBefore) {
        this.positionBefore = positionBefore;
    }

    private static final class AuthValveStub
    extends BaseAuthValve {
        public AuthValveStub(String id) {
            this.setId(id);
        }

        @Override
        public void invoke(Object context, ValveContext valveContext) throws PipelineException {
        }
    }
}

