/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.osgi;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProvisionActivator
implements BundleActivator {
    private final ServletContext servletContext;
    private BundleContext bundleContext;
    private static ProvisionActivator instance = null;
    private static final Logger logger = LoggerFactory.getLogger(ProvisionActivator.class);

    public ProvisionActivator(ServletContext servletContext) {
        this.servletContext = servletContext;
        instance = this;
    }

    public static ProvisionActivator getInstance() {
        return instance;
    }

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.servletContext.setAttribute(BundleContext.class.getName(), (Object)context);
        ArrayList<Bundle> installed = new ArrayList<Bundle>();
        for (URL url : this.findBundles()) {
            logger.info("Installing bundle [{}]", (Object)url);
            Bundle bundle = context.installBundle(url.toExternalForm());
            installed.add(bundle);
        }
        ServiceTracker st = new ServiceTracker(context, StartLevel.class.getName(), null);
        st.open();
        StartLevel sl = (StartLevel)st.getService();
        for (Bundle bundle : installed) {
            if (bundle.getSymbolicName().equals("org.apache.felix.fileinstall")) {
                sl.setBundleStartLevel(bundle, 2);
            }
            if (bundle.getHeaders().get("Fragment-Host") != null) continue;
            bundle.start();
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.bundleContext = null;
        this.servletContext.removeAttribute(BundleContext.class.getName());
        instance = null;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    private List<URL> findBundles() throws Exception {
        ArrayList<URL> list = new ArrayList<URL>();
        for (Object o : this.servletContext.getResourcePaths("/WEB-INF/bundles/")) {
            URL url;
            String name = (String)o;
            if (!name.endsWith(".jar") || (url = this.servletContext.getResource(name)) == null) continue;
            list.add(url);
        }
        return list;
    }
}

