/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.osgi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.felix.framework.Felix;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.osgi.ProvisionActivator;
import org.jahia.services.SpringContextSingleton;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.PropertyPlaceholderHelper;

public class FrameworkService {
    private static final Logger logger = LoggerFactory.getLogger(FrameworkService.class);
    private final ServletContext context;
    private Felix felix;
    private ProvisionActivator provisionActivator = null;
    private boolean started;

    public static FrameworkService getInstance() {
        return Holder.INSTANCE;
    }

    private FrameworkService(ServletContext context) {
        this.context = context;
    }

    public void start() throws BundleException {
        Felix tmp = new Felix(this.createConfig());
        tmp.start();
        this.felix = tmp;
    }

    public void stop() throws BundleException {
        this.provisionActivator = null;
        if (this.felix != null) {
            this.felix.stop();
            logger.info("Waiting for OSGi framework shutdown...");
            try {
                FrameworkEvent stopEvent = this.felix.waitForStop(30000L);
                logger.info("Framework stopped with event {}", (Object)stopEvent.getType());
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        logger.info("OSGi framework stopped");
    }

    public ProvisionActivator getProvisionActivator() {
        return this.provisionActivator;
    }

    private Map<String, Object> createConfig() {
        Map unreplaced = (Map)SpringContextSingleton.getBean("felixProperties");
        PropertyPlaceholderHelper placeholderHelper = new PropertyPlaceholderHelper("${", "}");
        Properties systemProps = System.getProperties();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry entry : unreplaced.entrySet()) {
            map.put((String)entry.getKey(), placeholderHelper.replacePlaceholders((String)entry.getValue(), systemProps));
        }
        String value = (String)map.get("gosh.args");
        if (value != null && value.contains("--port=-1")) {
            map.put("gosh.args", "--nointeractive");
        }
        StringBuilder extra = new StringBuilder((String)map.get("org.osgi.framework.system.packages.extra"));
        for (Map.Entry entry : map.entrySet()) {
            if (!((String)entry.getKey()).startsWith("org.osgi.framework.system.packages.extra.")) continue;
            extra.append(',').append(entry.getValue());
        }
        map.put("org.osgi.framework.system.packages.extra", extra.toString());
        map.put("org.jahia.servlet.context", this.context);
        this.provisionActivator = new ProvisionActivator(this.context);
        map.put("felix.systembundle.activators", Collections.singletonList(this.provisionActivator));
        return map;
    }

    public boolean isStarted() {
        return this.started;
    }

    public static BundleContext getBundleContext() {
        FrameworkService instance = FrameworkService.getInstance();
        if (instance != null && instance.felix != null) {
            return instance.felix.getBundleContext();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyStarted() {
        FrameworkService instance;
        logger.info("Got started event");
        FrameworkService frameworkService = instance = FrameworkService.getInstance();
        synchronized (frameworkService) {
            logger.info("Started event arrived");
            instance.started = true;
            instance.notifyAll();
            logger.info("Notified all about framework started event");
        }
    }

    private static class Holder {
        static final FrameworkService INSTANCE = new FrameworkService(JahiaContextLoaderListener.getServletContext());

        private Holder() {
        }
    }
}

