/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.osgi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.osgi.BundleDelegatingClassLoader;
import org.jahia.osgi.FrameworkService;
import org.jahia.osgi.JahiaBundleTemplatesPackageHandler;
import org.jahia.services.SpringContextSingleton;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.ConstantException;
import org.springframework.core.Constants;

public final class BundleUtils {
    private static final Constants BUNDLE_EVENTS = new Constants(BundleEvent.class);
    private static final Logger logger = LoggerFactory.getLogger(BundleUtils.class);
    private static Map<String, String[]> moduleForClass = new ConcurrentHashMap<String, String[]>();
    private static Map<Bundle, AbstractApplicationContext> contextToStart = new HashMap<Bundle, AbstractApplicationContext>();
    private static Map<Bundle, List<AbstractApplicationContext>> contextDependenciesToStart = new HashMap<Bundle, List<AbstractApplicationContext>>();
    private static Map<String, Throwable> contextException = new HashMap<String, Throwable>();
    private static Map<String, Map<String, JahiaTemplatesPackage>> modules = new ConcurrentHashMap<String, Map<String, JahiaTemplatesPackage>>(64);

    public static String bundleEventToString(int eventType) {
        try {
            return BUNDLE_EVENTS.toCode((Object)eventType, "");
        }
        catch (ConstantException cex) {
            return "Unknown";
        }
    }

    public static ClassLoader createBundleClassLoader(Bundle bundle) {
        return BundleDelegatingClassLoader.createBundleClassLoaderFor(bundle, SpringContextSingleton.getInstance().getContext().getClassLoader());
    }

    public static Bundle getBundleBySymbolicName(String symbolicName, String version) {
        for (Bundle bundle : FrameworkService.getBundleContext().getBundles()) {
            String n = bundle.getSymbolicName();
            if (!StringUtils.equals((String)n, (String)symbolicName) || version != null && !StringUtils.equals((String)bundle.getVersion().toString(), (String)version)) continue;
            return bundle;
        }
        return null;
    }

    public static Bundle getBundle(String moduleId, String version) {
        for (Bundle bundle : FrameworkService.getBundleContext().getBundles()) {
            String v;
            String n = BundleUtils.getModuleId(bundle);
            if (!StringUtils.equals((String)n, (String)moduleId) || !StringUtils.equals((String)(v = BundleUtils.getModuleVersion(bundle)), (String)version)) continue;
            return bundle;
        }
        return null;
    }

    public static String getDisplayName(Bundle bundle) {
        return BundleUtils.getModuleId(bundle) + " v" + BundleUtils.getModuleVersion(bundle);
    }

    public static JahiaTemplatesPackage getModule(Bundle bundle) {
        JahiaTemplatesPackage pkg = null;
        String moduleId = BundleUtils.getModuleId(bundle);
        String version = BundleUtils.getModuleVersion(bundle);
        String groupId = BundleUtils.getModuleGroupId(bundle);
        Map<String, JahiaTemplatesPackage> moduleVersions = modules.get(moduleId);
        if (moduleVersions == null) {
            moduleVersions = new ConcurrentHashMap<String, JahiaTemplatesPackage>(1);
            modules.put(moduleId, moduleVersions);
        } else {
            JahiaTemplatesPackage firstVersionTemplatePackage;
            if (!moduleVersions.isEmpty() && ((firstVersionTemplatePackage = moduleVersions.values().iterator().next()).getGroupId() != null && !firstVersionTemplatePackage.getGroupId().equals(groupId) || firstVersionTemplatePackage.getGroupId() == null && groupId != null)) {
                logger.error("A different Jahia Module with the Id " + bundle.getSymbolicName() + " already exists");
                return null;
            }
            pkg = moduleVersions.get(version);
        }
        if (pkg == null) {
            logger.info("Building module instance for bundle {} v{}", (Object)moduleId, (Object)version);
            pkg = JahiaBundleTemplatesPackageHandler.build(bundle);
            if (pkg != null) {
                moduleVersions.put(version, pkg);
            } else {
                logger.warn("Bundle {} seems to be not a valid Jahia module. Cannot build JahiaTemplatesPackage instance for it", (Object)bundle.getSymbolicName());
                logger.info("The following manifest headers were found in the bundle: \n{}", (Object)bundle.getHeaders());
                throw new IllegalArgumentException("Bundle " + bundle.getSymbolicName() + " is not a valid Jahia module");
            }
        }
        return pkg;
    }

    public static String getModuleId(Bundle bundle) {
        String symbolicName = bundle.getSymbolicName();
        if (symbolicName != null) {
            return symbolicName;
        }
        throw new NullPointerException("Check your bundle's MANIFEST: missing required Bundle-SymbolicName for bundle " + bundle);
    }

    public static String getModuleVersion(Bundle bundle) {
        String version = bundle.getVersion().toString();
        if (version == null) {
            throw new NullPointerException("Check your bundle's MANIFEST: missing required Bundle-Version for bundle " + bundle);
        }
        return StringUtils.defaultIfEmpty((String)((String)bundle.getHeaders().get("Implementation-Version")), (String)version);
    }

    public static String getModuleGroupId(Bundle bundle) {
        return (String)bundle.getHeaders().get("Jahia-GroupId");
    }

    public static boolean isJahiaBundle(Bundle bundle) {
        return BundleUtils.isJahiaModuleBundle(bundle) || StringUtils.defaultString((String)((String)bundle.getHeaders().get("Bundle-Category"))).toLowerCase().contains("jahia");
    }

    public static boolean isJahiaModuleBundle(Bundle bundle) {
        return bundle.getHeaders().get("Jahia-Module-Type") != null;
    }

    public static Class<?> loadModuleClass(String className) throws ClassNotFoundException {
        Class<?> clazz = null;
        String[] moduleKey = moduleForClass.get(className);
        if (moduleKey != null) {
            JahiaTemplatesPackage pkg;
            ClassLoader cl = null;
            Map<String, JahiaTemplatesPackage> versions = modules.get(moduleKey[0]);
            if (versions != null && (pkg = versions.get(moduleKey[1])) != null) {
                cl = pkg.getClassLoader();
            }
            if (cl == null) {
                moduleForClass.remove(className);
            } else {
                return cl.loadClass(className);
            }
        }
        for (Map<String, JahiaTemplatesPackage> moduleVersions : modules.values()) {
            for (JahiaTemplatesPackage pkg : moduleVersions.values()) {
                if (pkg.getClassLoader() == null) continue;
                try {
                    clazz = pkg.getClassLoader().loadClass(className);
                    moduleForClass.put(className, new String[]{pkg.getId(), pkg.getVersion().toString()});
                    return clazz;
                }
                catch (ClassNotFoundException e) {
                }
            }
        }
        throw new ClassNotFoundException("Unable to find class '" + className + "' in the class loaders of modules");
    }

    public static void unregisterModule(Bundle bundle) {
        String moduleId = BundleUtils.getModuleId(bundle);
        String version = BundleUtils.getModuleVersion(bundle);
        String groupId = BundleUtils.getModuleGroupId(bundle);
        Map<String, JahiaTemplatesPackage> moduleVersions = modules.get(moduleId);
        if (moduleVersions != null) {
            JahiaTemplatesPackage firstVersionTemplatePackage;
            if (!moduleVersions.isEmpty() && ((firstVersionTemplatePackage = moduleVersions.values().iterator().next()).getGroupId() != null && !firstVersionTemplatePackage.getGroupId().equals(groupId) || firstVersionTemplatePackage.getGroupId() == null && groupId != null)) {
                logger.warn("A different Jahia Module with the Id " + bundle.getSymbolicName() + " already exists");
                return;
            }
            JahiaTemplatesPackage pkg = moduleVersions.remove(version);
            if (moduleVersions.isEmpty()) {
                modules.remove(moduleId);
            }
            pkg.setClassLoader(null);
        }
    }

    public static AbstractApplicationContext getContextToStartForModule(Bundle bundle) {
        return contextToStart.get(bundle);
    }

    public static void setContextToStartForModule(Bundle bundle, AbstractApplicationContext context) {
        contextToStart.put(bundle, context);
    }

    public static void addContextToStartAfterDependency(Bundle dependency, AbstractApplicationContext contextToStart) {
        if (contextDependenciesToStart.get(dependency) == null) {
            contextDependenciesToStart.put(dependency, new ArrayList());
        }
        contextDependenciesToStart.get(dependency).add(contextToStart);
    }

    public static List<AbstractApplicationContext> getDependantContexts(Bundle dependency) {
        return contextDependenciesToStart.containsKey(dependency) ? contextDependenciesToStart.get(dependency) : Collections.emptyList();
    }

    public static Throwable getContextStartException(String key) {
        return contextException.get(key);
    }

    public static void setContextStartException(String key, Throwable exception) {
        contextException.put(key, exception);
    }
}

