/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.data.applications;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import org.apache.pluto.container.om.portlet.UserAttribute;
import org.jahia.data.applications.EntryPointDefinition;
import org.jahia.data.applications.EntryPointInstance;
import org.jahia.registries.ServicesRegistry;

public class ApplicationBean
implements Serializable,
Comparator<ApplicationBean>,
Cloneable {
    private static final long serialVersionUID = -5886294839254670413L;
    private String ID;
    private String name;
    private String context;
    private boolean visible = false;
    private String description = "";
    private String type;
    private List<EntryPointInstance> entryPointInstances;
    private List<UserAttribute> userAttributes;

    public ApplicationBean(String ID, String name, String context, boolean visible, String desc, String type) {
        this.setID(ID);
        this.name = name;
        this.context = context;
        this.visible = visible;
        this.description = desc;
        this.type = type;
    }

    public String getID() {
        return this.ID;
    }

    public String getName() {
        return this.name;
    }

    public String getContext() {
        return this.context;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public String getDescription() {
        return this.description;
    }

    public void setID(String ID) {
        this.ID = ID;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setDescription(String descr) {
        this.description = descr;
    }

    @Override
    public int compare(ApplicationBean c1, ApplicationBean c2) throws ClassCastException {
        return c1.getName().compareToIgnoreCase(c2.getName());
    }

    public String getType() {
        return this.type;
    }

    public List<EntryPointDefinition> getEntryPointDefinitions() {
        return ServicesRegistry.getInstance().getApplicationsManagerService().getAppEntryPointDefinitions(this);
    }

    public EntryPointDefinition getEntryPointDefinitionByName(String definitionName) {
        EntryPointDefinition entryPointDefinition = null;
        for (EntryPointDefinition curEntryPointDefinition : this.getEntryPointDefinitions()) {
            if (!curEntryPointDefinition.getName().equals(definitionName)) continue;
            entryPointDefinition = curEntryPointDefinition;
            break;
        }
        return entryPointDefinition;
    }

    public List<EntryPointInstance> getEntryPointInstances() {
        return this.entryPointInstances;
    }

    public void setEntryPointInstances(List<EntryPointInstance> entryPointInstances) {
        this.entryPointInstances = entryPointInstances;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationBean that = (ApplicationBean)o;
        return this.ID.equals(that.ID);
    }

    public int hashCode() {
        return this.ID.hashCode();
    }

    public List<UserAttribute> getUserAttributes() {
        return this.userAttributes;
    }

    public void setUserAttributes(List<UserAttribute> userAttributes) {
        this.userAttributes = userAttributes;
    }
}

