/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.JahiaController;
import org.jahia.bin.errors.DefaultErrorHandler;
import org.jahia.exceptions.JahiaBadRequestException;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.content.nodetypes.initializers.ChoiceListInitializer;
import org.jahia.services.content.nodetypes.initializers.ChoiceListInitializerService;
import org.jahia.services.content.nodetypes.initializers.ChoiceListValue;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.LanguageCodeConverters;
import org.jahia.utils.Patterns;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public class Initializers
extends JahiaController {
    private static final String CONTROLLER_MAPPING = "/initializers";
    private static transient Logger logger = LoggerFactory.getLogger(Initializers.class);
    private String defaultLocale = "en";
    private String defaultWorkspace = "live";

    public static String getInitializersServletPath() {
        return "/cms/initializers";
    }

    private void handle(HttpServletRequest request, HttpServletResponse response) throws RepositoryException, IllegalStateException, JSONException, IOException {
        String name = Initializers.getParameter(request, "name");
        String[] params = this.parseParameters(request);
        String workspace = params[0];
        Locale locale = LanguageCodeConverters.languageCodeToLocale(params[1]);
        if (StringUtils.isEmpty((String)request.getParameter("path")) && StringUtils.isEmpty((String)request.getParameter("nodeuuid")) && StringUtils.isEmpty((String)request.getParameter("type"))) {
            throw new JahiaBadRequestException("One of the required parameters is missing");
        }
        ExtendedNodeType type = null;
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession(workspace, locale);
        JCRNodeWrapper node = null;
        try {
            if (request.getParameter("path") != null) {
                node = session.getNode(request.getParameter("path"));
                type = node.getPrimaryNodeType();
            } else if (request.getParameter("nodeuuid") != null) {
                node = session.getNodeByUUID(request.getParameter("nodeuuid"));
                type = node.getPrimaryNodeType();
            } else {
                node = null;
                type = NodeTypeRegistry.getInstance().getNodeType(request.getParameter("type"));
            }
        }
        catch (PathNotFoundException e) {
            throw new JahiaBadRequestException(e);
        }
        catch (ItemNotFoundException e) {
            throw new JahiaBadRequestException(e);
        }
        catch (NoSuchNodeTypeException e) {
            throw new JahiaBadRequestException(e);
        }
        if (type == null) {
            throw new JahiaBadRequestException("Cannot determine node type");
        }
        ExtendedPropertyDefinition definition = type.getPropertyDefinition(name);
        JSONArray results = new JSONArray();
        Map<Object, Object> map = new LinkedHashMap();
        String initializersString = request.getParameter("initializers");
        if (initializersString != null) {
            String[] strings;
            for (String string : strings = Patterns.COMMA.split(initializersString)) {
                map.put(string, "");
            }
        } else {
            if (definition == null) {
                throw new JahiaBadRequestException("Unable to find property definition with the name '" + name + "'");
            }
            map = definition.getSelectorOptions();
        }
        if (map.size() > 0) {
            Map<String, ChoiceListInitializer> initializers = ChoiceListInitializerService.getInstance().getInitializers();
            List<ChoiceListValue> listValues = null;
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("contextNode", node);
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                if (!initializers.containsKey(entry.getKey())) continue;
                listValues = initializers.get(entry.getKey()).getChoiceListValues(definition, (String)entry.getValue(), listValues, locale, context);
            }
            if (listValues != null) {
                String s = request.getParameter("q");
                for (ChoiceListValue listValue : listValues) {
                    String displayName = listValue.getDisplayName();
                    if (s != null && !displayName.toLowerCase().startsWith(s.toLowerCase())) continue;
                    JSONObject value = new JSONObject();
                    if (request.getParameter("gxt") != null) {
                        value.put("value", (Object)listValue.getValue().getString());
                        value.put("name", (Object)displayName);
                    } else {
                        value.append("value", (Object)listValue.getValue().getString());
                        value.append("name", (Object)displayName);
                    }
                    results.put((Object)value);
                }
            }
        }
        response.setContentType("application/json; charset=" + SettingsBean.getInstance().getCharacterEncoding());
        if (request.getParameter("gxt") != null) {
            JSONObject object = new JSONObject();
            object.put("choicelist", (Object)results);
            if (logger.isDebugEnabled()) {
                StringWriter out = new StringWriter();
                object.write((Writer)out).flush();
                logger.debug(out.toString());
            }
            object.write((Writer)response.getWriter()).flush();
        } else {
            if (logger.isDebugEnabled()) {
                StringWriter out = new StringWriter();
                results.write((Writer)out).flush();
                logger.debug(out.toString());
            }
            results.write((Writer)response.getWriter()).flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        long startTime = System.currentTimeMillis();
        String sessionId = null;
        try {
            if (logger.isInfoEnabled()) {
                sessionId = request.getSession().getId();
            }
            if (request.getMethod().equals("GET") || request.getMethod().equals("POST")) {
                this.handle(request, response);
            } else if (request.getMethod().equals("OPTIONS")) {
                response.setHeader("Allow", "GET, OPTIONS, POST");
            } else {
                response.sendError(405);
            }
        }
        catch (Exception e) {
            DefaultErrorHandler.getInstance().handle(e, request, response);
        }
        finally {
            if (logger.isInfoEnabled()) {
                StringBuilder sb = new StringBuilder(100);
                sb.append("Rendered [").append(request.getRequestURI());
                JahiaUser user = JCRTemplate.getInstance().getSessionFactory().getCurrentUser();
                if (user != null) {
                    sb.append("] user=[").append(user.getUsername());
                }
                sb.append("] ip=[").append(request.getRemoteAddr()).append("] sessionID=[").append(sessionId).append("] in [").append(System.currentTimeMillis() - startTime).append("ms]");
                logger.info(sb.toString());
            }
        }
        return null;
    }

    private String[] parseParameters(HttpServletRequest request) {
        String workspace = null;
        String lang = null;
        String path = request.getPathInfo();
        if (path != null && path.startsWith("/initializers/") && (path = path.substring(CONTROLLER_MAPPING.length() + 1)).contains("/")) {
            workspace = StringUtils.substringBefore((String)path, (String)"/");
            lang = StringUtils.substringAfter((String)path, (String)"/");
            if (lang.contains("/")) {
                lang = StringUtils.substringBefore((String)lang, (String)"/");
            }
        }
        if (!JCRContentUtils.isValidWorkspace(workspace, true)) {
            throw new JahiaBadRequestException("Unknown workspace '" + workspace + "'");
        }
        return new String[]{StringUtils.defaultIfEmpty(workspace, (String)this.defaultWorkspace), StringUtils.defaultIfEmpty(lang, (String)this.defaultLocale)};
    }

    public void setDefaultLocale(String defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public void setDefaultWorkspace(String defaultWorkspace) {
        this.defaultWorkspace = defaultWorkspace;
    }
}

