/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.Render;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.uicomponents.bean.editmode.EditConfiguration;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Edit
extends Render {
    private static final long serialVersionUID = -6197445426874881036L;
    private static Logger logger = LoggerFactory.getLogger(Edit.class);
    private EditConfiguration editConfiguration;
    private boolean availableInProductionMode = true;
    private boolean availableInDistantPublicationServerMode = true;
    private boolean forceUILocaleForJCRSession = false;

    @Override
    protected RenderContext createRenderContext(HttpServletRequest req, HttpServletResponse resp, JahiaUser user) {
        RenderContext context = super.createRenderContext(req, resp, user);
        context.setEditMode(true);
        if ("contributemode".equals(this.editConfiguration.getName())) {
            context.setContributionMode(true);
        }
        context.setEditModeConfig(this.editConfiguration);
        context.setForceUILocaleForJCRSession(this.forceUILocaleForJCRSession);
        return context;
    }

    @Override
    protected boolean hasAccess(JCRNodeWrapper node) {
        if (node == null) {
            logger.error("Site key is null.");
            return false;
        }
        try {
            if (node.getSession().getUser() == null) {
                return false;
            }
            if ("live".equals(node.getSession().getWorkspace().getName())) {
                logger.error("Someone have tried to access the live repository in edit mode");
                return false;
            }
            if (node.getResolveSite() == null) {
                return false;
            }
            String checkedPath = StringUtils.replace((String)StringUtils.replace((String)this.editConfiguration.getNodeCheckPermission(), (String)"$site", (String)node.getResolveSite().getPath()), (String)"$user", (String)node.getSession().getUser().getLocalPath());
            if (this.editConfiguration.getNodeCheckPermission() == null) {
                checkedPath = node.getResolveSite().getPath();
            }
            return node.getSession().getNode(checkedPath).hasPermission(this.editConfiguration.getRequiredPermission()) && super.hasAccess(node);
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    @Override
    protected boolean isDisabled() {
        SettingsBean settingsBean = this.getSettingsBean();
        return settingsBean.isReadOnlyMode() || settingsBean.isDistantPublicationServerMode() && !this.isAvailableInDistantPublicationServerMode() || settingsBean.isProductionMode() && !this.isAvailableInProductionMode();
    }

    public EditConfiguration getEditConfiguration() {
        return this.editConfiguration;
    }

    public void setEditConfiguration(EditConfiguration editConfiguration) {
        this.editConfiguration = editConfiguration;
    }

    public boolean isAvailableInProductionMode() {
        return this.availableInProductionMode;
    }

    public void setAvailableInProductionMode(boolean availableInProductionMode) {
        this.availableInProductionMode = availableInProductionMode;
    }

    public boolean isAvailableInDistantPublicationServerMode() {
        return this.availableInDistantPublicationServerMode;
    }

    public void setAvailableInDistantPublicationServerMode(boolean availableInDistantPublicationServerMode) {
        this.availableInDistantPublicationServerMode = availableInDistantPublicationServerMode;
    }

    public void setForceUILocaleForJCRSession(boolean forceUILocaleForJCRSession) {
        this.forceUILocaleForJCRSession = forceUILocaleForJCRSession;
    }

    public boolean isForceUILocaleForJCRSession() {
        return this.forceUILocaleForJCRSession;
    }
}

