/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.PathNotFoundException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.JahiaController;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.transform.DocumentConverterService;
import org.jahia.settings.SettingsBean;
import org.jahia.tools.files.FileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public class DocumentConverter
extends JahiaController {
    private static Logger logger = LoggerFactory.getLogger(DocumentConverter.class);
    private DocumentConverterService converterService;
    private SettingsBean settingsBean;
    private boolean requireAuthenticatedUser = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelAndView handleGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String workspace = null;
        String nodePath = null;
        String targetFileExtension = null;
        String pathInfo = request.getPathInfo();
        if (pathInfo != null && pathInfo.length() > 1) {
            nodePath = StringUtils.substringAfter((String)(pathInfo = StringUtils.substringAfter((String)pathInfo.substring(1), (String)"/")), (String)(workspace = StringUtils.substringBefore((String)pathInfo, (String)"/")));
            if (nodePath.contains(".")) {
                targetFileExtension = StringUtils.substringAfterLast((String)nodePath, (String)".");
                nodePath = StringUtils.substringBeforeLast((String)nodePath, (String)".");
            } else {
                nodePath = null;
            }
        }
        if (!JCRContentUtils.isValidWorkspace(workspace) || StringUtils.isEmpty(nodePath) || StringUtils.isEmpty(targetFileExtension)) {
            response.sendError(400, "Expected data not found in the request. Please check the documentation of the Jahia Document Converter Service for more details.");
            return null;
        }
        String targetFormat = this.converterService.getMimeType(targetFileExtension);
        if (targetFormat == null) {
            response.sendError(400, "Cannot lookup MIME type that corresponds to file extension '" + targetFileExtension + "'");
            return null;
        }
        InputStream is = null;
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession(workspace);
            JCRNodeWrapper node = session.getNode(nodePath);
            if (node.isNodeType("nt:file")) {
                response.setContentType(targetFormat);
                response.setHeader("Content-Disposition", "attachment; filename=\"" + StringUtils.substringBeforeLast((String)node.getName(), (String)".") + "." + targetFileExtension + "\"");
                is = node.getFileContent().downloadFile();
                this.converterService.convert(is, this.converterService.getMimeType(FilenameUtils.getExtension((String)node.getName())), (OutputStream)response.getOutputStream(), targetFormat);
            } else {
                response.sendError(400, "Path should correspond to a file node");
            }
        }
        catch (PathNotFoundException e) {
            response.sendError(404, e.getMessage());
        }
        catch (Exception e) {
            response.sendError(500, e.getMessage());
        }
        finally {
            IOUtils.closeQuietly(is);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelAndView handlePost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String returnedMimeType;
        FileUpload fu = new FileUpload(request, this.settingsBean.getTmpContentDiskPath(), Integer.MAX_VALUE);
        if (fu.getFileItems().size() == 0) {
            response.sendError(400, "No file was submitted");
            return null;
        }
        DiskFileItem inputFile = fu.getFileItems().values().iterator().next();
        InputStream stream = null;
        String string = returnedMimeType = fu.getParameterValues("mimeType") != null ? fu.getParameterValues("mimeType")[0] : null;
        if (returnedMimeType == null) {
            response.sendError(400, "Missing required parameter mimeType");
            return null;
        }
        try {
            ServletOutputStream outputStream = response.getOutputStream();
            stream = inputFile.getInputStream();
            response.setContentType(returnedMimeType);
            response.setHeader("Content-Disposition", "attachment; filename=\"" + FilenameUtils.getBaseName((String)inputFile.getName()) + "." + this.converterService.getExtension(returnedMimeType) + "\"");
            this.converterService.convert(stream, inputFile.getContentType(), (OutputStream)outputStream, returnedMimeType);
            try {
                outputStream.flush();
            }
            finally {
                outputStream.close();
            }
        }
        catch (Exception e) {
            try {
                logger.error("Error converting uploaded file " + inputFile.getFieldName() + ". Cause: " + e.getMessage(), (Throwable)e);
                response.sendError(500, "Exception occurred: " + e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                fu.disposeItems();
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)stream);
            fu.disposeItems();
        }
        IOUtils.closeQuietly((InputStream)stream);
        fu.disposeItems();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.requireAuthenticatedUser && this.isUserGuest()) {
            response.sendError(403, "The service is available only for authenticated users.");
            return null;
        }
        if (!this.converterService.isEnabled()) {
            response.sendError(400, "Conversion service is not enabled.");
            return null;
        }
        ModelAndView result = null;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request) || "get".equalsIgnoreCase(request.getMethod())) {
            long startTime = System.currentTimeMillis();
            try {
                result = ServletFileUpload.isMultipartContent((HttpServletRequest)request) ? this.handlePost(request, response) : this.handleGet(request, response);
            }
            finally {
                if (logger.isInfoEnabled()) {
                    StringBuilder sb = new StringBuilder(100);
                    sb.append("Converted [").append(request.getRequestURI());
                    JCRSessionFactory jcrSessionFactory = JCRSessionFactory.getInstance();
                    if (jcrSessionFactory.getCurrentUser() != null) {
                        sb.append("] user=[").append(jcrSessionFactory.getCurrentUser().getUsername());
                    }
                    sb.append("] ip=[").append(request.getRemoteAddr()).append("] sessionID=[").append(request.getSession().getId()).append("] in [").append(System.currentTimeMillis() - startTime).append("ms]");
                    logger.info(sb.toString());
                }
            }
        } else {
            response.sendError(400, "Multipart data is not found in the POST request");
            return null;
        }
        return result;
    }

    public void setConverterService(DocumentConverterService converterService) {
        this.converterService = converterService;
    }

    public void setSettingsBean(SettingsBean settingsBean) {
        this.settingsBean = settingsBean;
    }

    public static String getPath() {
        return "/cms/convert";
    }

    @Override
    public void setRequireAuthenticatedUser(boolean requireAuthenticatedUser) {
        this.requireAuthenticatedUser = requireAuthenticatedUser;
    }
}

