/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import com.google.code.kaptcha.impl.DefaultKaptcha;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jahia.bin.JahiaController;
import org.jahia.bin.errors.DefaultErrorHandler;
import org.jahia.exceptions.JahiaBadRequestException;
import org.jahia.utils.WebUtils;
import org.springframework.web.servlet.ModelAndView;

public class Captcha
extends JahiaController {
    private DefaultKaptcha captchaProducer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String token = Captcha.getParameter(request, "token");
            Map toks = (Map)request.getSession().getAttribute("form-tokens");
            if (toks == null || !toks.containsKey(token)) {
                throw new JahiaBadRequestException("Unknown form token.");
            }
            response.setContentType("image/jpeg");
            WebUtils.setNoCacheHeaders(response);
            String capText = this.captchaProducer.createText();
            ((Map)toks.get(token)).put("jcrCaptcha", Arrays.asList(capText));
            BufferedImage bi = this.captchaProducer.createImage(capText);
            ServletOutputStream out = response.getOutputStream();
            ImageIO.write((RenderedImage)bi, "jpg", (OutputStream)out);
            try {
                out.flush();
            }
            finally {
                out.close();
            }
            response.setStatus(200);
        }
        catch (Exception e) {
            DefaultErrorHandler.getInstance().handle(e, request, response);
        }
        return null;
    }

    public void setCaptchaProducer(DefaultKaptcha captchaProducer) {
        this.captchaProducer = captchaProducer;
    }

    public static String getCaptchaServletPath() {
        return "/cms/captcha";
    }
}

