/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.helper;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.ItemExistsException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.jahia.ajax.gwt.client.service.GWTJahiaServiceException;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRFileContent;
import org.jahia.services.importexport.NoCloseZipInputStream;
import org.jahia.utils.i18n.Messages;
import org.jahia.utils.zip.ZipEntryCharsetDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipHelper {
    private static volatile ZipHelper instance;
    private static final Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ZipHelper getInstance() {
        if (instance != null) return instance;
        Class<ZipHelper> clazz = ZipHelper.class;
        synchronized (ZipHelper.class) {
            if (instance != null) return instance;
            instance = new ZipHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> zipFiles(JCRNodeWrapper parentDirectory, String zipname, List<JCRNodeWrapper> files) {
        ArrayList<String> missedPaths = null;
        File tmp = null;
        try {
            tmp = File.createTempFile("jahiazip", ".zip");
            ZipOutputStream zout = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(tmp)));
            byte[] buffer = new byte[4096];
            String parentDir = parentDirectory.getPath();
            if (!parentDir.endsWith("/")) {
                parentDir = parentDir + "/";
            }
            for (JCRNodeWrapper file : files) {
                try {
                    this.zipFileEntry(file, zout, buffer, parentDir);
                }
                catch (IOException e) {
                    logger.error("Error zipping file " + file.getPath(), (Throwable)e);
                    if (missedPaths == null) {
                        missedPaths = new ArrayList();
                    }
                    missedPaths.add(file.getPath());
                }
            }
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(tmp));
            try {
                zout.close();
                JCRNodeWrapper result = parentDirectory.uploadFile(zipname, is, "application/zip");
                result.saveSession();
            }
            catch (IOException | RepositoryException e) {
                logger.error("Error writing resulting zipped file", e);
                missedPaths = new ArrayList();
                for (JCRNodeWrapper node : files) {
                    missedPaths.add(node.getName());
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        catch (IOException e) {
            logger.error("Error creating zipped file", (Throwable)e);
            missedPaths = new ArrayList<String>();
            for (JCRNodeWrapper node : files) {
                missedPaths.add(node.getName());
            }
        }
        finally {
            FileUtils.deleteQuietly((File)tmp);
        }
        return missedPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zipFileEntry(JCRNodeWrapper file, ZipOutputStream zout, byte[] buffer, String rootDir) throws IOException {
        String relativePath = file.getPath().replace(rootDir, "");
        if (!file.isFile()) {
            ZipEntry anEntry = new ZipEntry(relativePath + "/");
            zout.putNextEntry(anEntry);
            try {
                JCRNodeIteratorWrapper iterator = file.getNodes();
                while (iterator.hasNext()) {
                    JCRNodeWrapper fileNode = (JCRNodeWrapper)iterator.next();
                    this.zipFileEntry(fileNode, zout, buffer, rootDir);
                }
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            InputStream is = file.getFileContent().downloadFile();
            if (is != null) {
                try {
                    int bytesIn;
                    ZipEntry anEntry = new ZipEntry(relativePath);
                    zout.putNextEntry(anEntry);
                    while ((bytesIn = is.read(buffer)) != -1) {
                        zout.write(buffer, 0, bytesIn);
                    }
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unzipFile(JCRNodeWrapper zipfile, JCRNodeWrapper destination, JCRSessionWrapper currentUserSession) throws RepositoryException {
        NoCloseZipInputStream zis = null;
        try {
            JCRFileContent fileContent = zipfile.getFileContent();
            Charset charset = ZipEntryCharsetDetector.detect(fileContent);
            if (logger.isDebugEnabled()) {
                logger.debug("Unzipping content of the node {} using charset {}", (Object)zipfile.getPath(), (Object)charset);
            }
            zis = new NoCloseZipInputStream(fileContent.downloadFile(), charset);
            boolean bl = this.doUnzipContent(zis, destination.getPath(), currentUserSession);
            return bl;
        }
        finally {
            if (zis != null) {
                try {
                    zis.reallyClose();
                }
                catch (IOException e) {
                    if (logger.isDebugEnabled()) {
                        logger.warn("Unable to close the ZIP file for node " + zipfile.getPath(), (Throwable)e);
                    }
                    logger.warn("Unable to close the ZIP file for node {}", (Object)zipfile.getPath());
                }
            }
        }
    }

    private boolean doUnzipContent(NoCloseZipInputStream zis, String dest, JCRSessionWrapper currentUserSession) throws RepositoryException {
        ArrayList<String> errorFiles = new ArrayList<String>();
        boolean result = false;
        block7: while (true) {
            try {
                ZipEntry zipentry;
                while ((zipentry = zis.getNextEntry()) != null) {
                    String filename = null;
                    try {
                        filename = zipentry.getName().replace('\\', '/');
                        if (logger.isDebugEnabled()) {
                            logger.debug("Unzip file (" + zipentry.getMethod() + ")" + filename);
                        }
                        if (filename.endsWith("/")) {
                            filename = filename.substring(0, filename.length() - 1);
                        }
                        int endIndex = filename.lastIndexOf(47);
                        String parentName = dest;
                        if (endIndex > -1) {
                            parentName = parentName + "/" + filename.substring(0, endIndex);
                            filename = filename.substring(endIndex + 1);
                        }
                        JCRNodeWrapper target = this.ensureDir(parentName, currentUserSession);
                        if (zipentry.isDirectory()) {
                            String folderName = JCRContentUtils.escapeLocalNodeName(filename);
                            if (!target.hasNode(folderName)) {
                                try {
                                    target.createCollection(folderName);
                                }
                                catch (ItemExistsException e) {}
                            }
                        } else {
                            target.uploadFile(filename, zis, JCRContentUtils.getMimeType(filename));
                        }
                        result = true;
                        continue block7;
                    }
                    catch (InternalError err) {
                        logger.error("Error when unzipping file", (Throwable)err);
                        if (filename == null) continue;
                        errorFiles.add(filename);
                    }
                }
                break;
            }
            catch (IOException e) {
                logger.error("Error when unzipping file", (Throwable)e);
                result = false;
                break;
            }
            catch (InternalError err) {
                logger.error("Error when unzipping file, " + err.getMessage(), (Throwable)err);
                result = false;
                break;
            }
        }
        return result;
    }

    private JCRNodeWrapper ensureDir(String path, JCRSessionWrapper currentUserSession) throws RepositoryException {
        try {
            return currentUserSession.getNode(JCRContentUtils.escapeNodePath(path));
        }
        catch (RepositoryException e) {
            if (e instanceof PathNotFoundException || e.getCause() != null && e.getCause() instanceof MalformedPathException) {
                int endIndex = path.lastIndexOf(47);
                if (endIndex == -1) {
                    return null;
                }
                JCRNodeWrapper parentDir = this.ensureDir(path.substring(0, endIndex), currentUserSession);
                if (parentDir == null) {
                    return null;
                }
                return parentDir.createCollection(JCRContentUtils.escapeLocalNodeName(path.substring(path.lastIndexOf(47) + 1)));
            }
            throw e;
        }
    }

    public void zip(List<String> paths, String archiveName, JCRSessionWrapper currentUserSession, Locale uiLocale) throws GWTJahiaServiceException {
        if (!archiveName.endsWith(".zip") && !archiveName.endsWith(".ZIP")) {
            archiveName = archiveName + ".zip";
        }
        ArrayList<String> missedPaths = new ArrayList<String>();
        ArrayList<JCRNodeWrapper> nodesToZip = new ArrayList<JCRNodeWrapper>();
        for (String path : paths) {
            JCRNodeWrapper nodeToZip;
            try {
                nodeToZip = currentUserSession.getNode(path);
            }
            catch (RepositoryException e) {
                logger.error(e.toString(), (Throwable)e);
                missedPaths.add(path + Messages.getInternal("label.gwt.error.could.not.be.accessed", uiLocale) + e.toString());
                continue;
            }
            nodesToZip.add(nodeToZip);
        }
        if (nodesToZip.size() > 0) {
            JCRNodeWrapper parent;
            String firstPath = ((JCRNodeWrapper)nodesToZip.get(0)).getPath();
            int index = firstPath.lastIndexOf("/");
            String parentPath = index > 0 ? firstPath.substring(0, index) : "/";
            try {
                parent = currentUserSession.getNode(parentPath);
            }
            catch (RepositoryException e) {
                logger.error(e.toString(), (Throwable)e);
                throw new GWTJahiaServiceException(parentPath + Messages.getInternal("label.gwt.error.could.not.be.accessed", uiLocale) + e.toString());
            }
            if (parent.hasPermission("jcr:addChildNodes") && !parent.isLocked()) {
                List<String> errorPaths = this.zipFiles(parent, archiveName, nodesToZip);
                if (errorPaths != null) {
                    errorPaths.addAll(missedPaths);
                    StringBuilder errors = new StringBuilder(Messages.getInternal("label.gwt.error.the.following.files.could.not.be.zipped", uiLocale));
                    for (String err : errorPaths) {
                        errors.append("\n").append(err);
                    }
                    throw new GWTJahiaServiceException(errors.toString());
                }
            } else {
                throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.directory.is.not.writable", uiLocale, parent.getPath()));
            }
        }
        if (missedPaths.size() > 0) {
            StringBuilder errors = new StringBuilder(Messages.getInternal("label.gwt.error.the.following.files.could.not.be.zipped", uiLocale));
            for (String err : missedPaths) {
                errors.append("\n").append(err);
            }
            throw new GWTJahiaServiceException(errors.toString());
        }
    }

    public void unzip(List<String> paths, boolean removeArchive, JCRSessionWrapper currentUserSession, Locale uiLocale) throws GWTJahiaServiceException {
        ArrayList<String> missedPaths = new ArrayList<String>();
        ArrayList<JCRNodeWrapper> nodesToUnzip = new ArrayList<JCRNodeWrapper>();
        for (String path : paths) {
            JCRNodeWrapper nodeToUnzip;
            try {
                nodeToUnzip = currentUserSession.getNode(JCRContentUtils.escapeNodePath(path));
            }
            catch (RepositoryException e) {
                logger.error(e.toString(), (Throwable)e);
                missedPaths.add(path + Messages.getInternal("label.gwt.error.could.not.be.accessed", uiLocale) + e.toString());
                continue;
            }
            nodesToUnzip.add(nodeToUnzip);
        }
        if (nodesToUnzip.size() > 0) {
            JCRNodeWrapper parent;
            String firstPath = ((JCRNodeWrapper)nodesToUnzip.get(0)).getPath();
            int index = firstPath.lastIndexOf("/");
            String parentPath = index > 0 ? firstPath.substring(0, index) : "/";
            try {
                parent = currentUserSession.getNode(parentPath);
            }
            catch (RepositoryException e) {
                logger.error(e.toString(), (Throwable)e);
                throw new GWTJahiaServiceException(parentPath + Messages.getInternal("label.gwt.error.could.not.be.accessed", uiLocale) + e.toString());
            }
            if (parent.hasPermission("jcr:addChildNodes") && !parent.isLocked()) {
                for (JCRNodeWrapper nodeToUnzip : nodesToUnzip) {
                    try {
                        if (!this.unzipFile(nodeToUnzip, parent, currentUserSession)) {
                            missedPaths.add(nodeToUnzip.getName());
                            continue;
                        }
                        if (!removeArchive) continue;
                        try {
                            nodeToUnzip.remove();
                        }
                        catch (RepositoryException e) {
                            logger.error("Issue when trying to delete original archive " + nodeToUnzip.getPath(), (Throwable)e);
                        }
                    }
                    catch (RepositoryException e) {
                        missedPaths.add(nodeToUnzip.getName());
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            } else {
                throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.directory.is.not.writable", uiLocale, parent.getPath()));
            }
            try {
                parent.saveSession();
            }
            catch (RepositoryException e) {
                logger.error("Could not save changes in " + parent.getPath(), (Throwable)e);
            }
        }
        if (missedPaths.size() > 0) {
            StringBuilder errors = new StringBuilder("The following files could not be unzipped:");
            for (String err : missedPaths) {
                errors.append("\n").append(err);
            }
            throw new GWTJahiaServiceException(errors.toString());
        }
    }

    static {
        logger = LoggerFactory.getLogger(ZipHelper.class);
    }
}

