/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.job.GWTJahiaJobDetail;
import org.jahia.ajax.gwt.client.service.GWTJahiaServiceException;
import org.jahia.ajax.gwt.client.widget.poller.ProcessPollingEvent;
import org.jahia.ajax.gwt.commons.server.ChannelHolder;
import org.jahia.ajax.gwt.commons.server.JGroupsChannel;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.atmosphere.AtmosphereServlet;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.PublicationJob;
import org.jahia.services.content.rules.ActionJob;
import org.jahia.services.content.rules.RuleJob;
import org.jahia.services.content.textextraction.TextExtractorJob;
import org.jahia.services.importexport.ImportJob;
import org.jahia.services.scheduler.BackgroundJob;
import org.jahia.services.scheduler.SchedulerService;
import org.jahia.services.usermanager.JahiaUser;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.quartz.SchedulerException;
import org.quartz.listeners.JobListenerSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerHelper {
    private Logger logger = LoggerFactory.getLogger(SchedulerHelper.class);
    private static final Comparator<GWTJahiaJobDetail> JOB_COMPARATOR = new Comparator<GWTJahiaJobDetail>(){

        @Override
        public int compare(GWTJahiaJobDetail o1, GWTJahiaJobDetail o2) {
            return o2.compareTo(o1);
        }
    };
    private SchedulerService scheduler;

    public void setScheduler(SchedulerService scheduler) {
        this.scheduler = scheduler;
    }

    public void start() {
        try {
            this.scheduler.getScheduler().addGlobalJobListener((JobListener)new PollingSchedulerListener());
        }
        catch (SchedulerException e) {
            this.logger.error("Cannot register job listener", (Throwable)e);
        }
    }

    private Long getLong(JobDataMap jobDataMap, String key) {
        if (jobDataMap.get((Object)key) == null) {
            return null;
        }
        return Long.parseLong(jobDataMap.getString(key));
    }

    private List<GWTJahiaJobDetail> convertToGWTJobs(List<JobDetail> jobDetails) {
        ArrayList<GWTJahiaJobDetail> jobs = new ArrayList<GWTJahiaJobDetail>();
        for (JobDetail jobDetail : jobDetails) {
            String nodeUUID;
            Long duration;
            JobDataMap jobDataMap = jobDetail.getJobDataMap();
            Date created = (Date)jobDataMap.get((Object)"created");
            String status = jobDataMap.getString("status");
            String user = StringUtils.substringAfterLast((String)jobDataMap.getString("userkey"), (String)"/");
            String message = jobDataMap.getString("message");
            Long beginTime = this.getLong(jobDataMap, "begin");
            Long endTime = this.getLong(jobDataMap, "end");
            String site = jobDataMap.getString("sitekey");
            if (created == null && beginTime != null) {
                created = new Date(beginTime);
            }
            if ((duration = this.getLong(jobDataMap, "duration")) == null && beginTime != null && endTime == null && "executing".equals(status)) {
                duration = System.currentTimeMillis() - beginTime;
            }
            String jobLocale = jobDataMap.getString("currentLocale");
            String targetNodeIdentifier = null;
            String targetAction = null;
            String targetWorkspace = null;
            String description = jobDetail.getDescription();
            final ArrayList<String> targetPaths = new ArrayList<String>();
            String fileName = jobDataMap.getString("filename");
            if (BackgroundJob.getGroupName(PublicationJob.class).equals(jobDetail.getGroup())) {
                List publicationInfos = (List)jobDataMap.get((Object)"publicationProperties");
                if (publicationInfos != null && publicationInfos.size() > 0) {
                    description = description + " " + ((GWTJahiaNodeProperty)publicationInfos.get(0)).getValues();
                }
                final List uuids = (List)jobDataMap.get((Object)"publicationInfos");
                try {
                    JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Object>(){

                        @Override
                        public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                            for (String uuid : uuids) {
                                try {
                                    targetPaths.add(session.getNodeByIdentifier(uuid).getPath());
                                }
                                catch (ItemNotFoundException e) {
                                    SchedulerHelper.this.logger.debug("Cannot get item " + uuid, (Throwable)e);
                                }
                            }
                            return null;
                        }
                    });
                }
                catch (RepositoryException e) {
                    this.logger.error("Cannot get publication details", (Throwable)e);
                }
            } else if (BackgroundJob.getGroupName(ImportJob.class).equals(jobDetail.getGroup())) {
                String uri = (String)jobDataMap.get((Object)"uri");
                if (uri != null) {
                    targetPaths.add(uri);
                    description = description + " " + uri;
                } else {
                    String destinationParentPath = jobDataMap.getString("destParentPath");
                    targetPaths.add(destinationParentPath);
                }
            } else if (BackgroundJob.getGroupName(ActionJob.class).equals(jobDetail.getGroup())) {
                String actionToExecute;
                targetAction = actionToExecute = jobDataMap.getString("actionToExecute");
                targetNodeIdentifier = nodeUUID = jobDataMap.getString("node");
            } else if (BackgroundJob.getGroupName(RuleJob.class).equals(jobDetail.getGroup())) {
                String workspace;
                String ruleToExecute;
                targetAction = ruleToExecute = jobDataMap.getString("ruleToExecute");
                targetNodeIdentifier = nodeUUID = jobDataMap.getString("node");
                targetWorkspace = workspace = jobDataMap.getString("workspace");
            } else if (BackgroundJob.getGroupName(TextExtractorJob.class).equals(jobDetail.getGroup())) {
                String path = jobDataMap.getString("path");
                String extractNodePath = jobDataMap.getString("extractnode-path");
                targetPaths.add(path);
                targetPaths.add(extractNodePath);
            }
            GWTJahiaJobDetail job = new GWTJahiaJobDetail(jobDetail.getName(), created, user, site, description, status, message, targetPaths, jobDetail.getGroup(), jobDetail.getJobClass().getName(), beginTime, endTime, duration, jobLocale, fileName, targetNodeIdentifier, targetAction, targetWorkspace);
            job.setLabelKey("label." + jobDetail.getGroup() + ".task");
            jobs.add(job);
        }
        return jobs;
    }

    public List<GWTJahiaJobDetail> getActiveJobs(Locale locale) throws GWTJahiaServiceException {
        try {
            List<JobDetail> l = this.scheduler.getAllActiveJobs();
            return this.convertToGWTJobs(l);
        }
        catch (Exception e) {
            throw new GWTJahiaServiceException("Error retrieving active jobs", (Throwable)e);
        }
    }

    public List<GWTJahiaJobDetail> getAllJobs(Locale locale, JahiaUser jahiaUser, Set<String> groupNames) throws GWTJahiaServiceException {
        try {
            List<JobDetail> jobDetails = null;
            if (groupNames == null) {
                jobDetails = this.scheduler.getAllJobs();
            } else {
                jobDetails = new ArrayList<JobDetail>();
                for (String groupName : groupNames) {
                    jobDetails.addAll(this.scheduler.getAllJobs(groupName));
                }
            }
            List<GWTJahiaJobDetail> gwtJobList = this.convertToGWTJobs(jobDetails);
            Collections.sort(gwtJobList, JOB_COMPARATOR);
            return gwtJobList;
        }
        catch (Exception e) {
            throw new GWTJahiaServiceException("Cannot retrieve jobs. Cause: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public Boolean deleteJob(String jobName, String groupName) throws GWTJahiaServiceException {
        try {
            return this.scheduler.getScheduler().deleteJob(jobName, groupName);
        }
        catch (SchedulerException e) {
            throw new GWTJahiaServiceException("Cannot delete job " + jobName + ". Cause: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public List<String> getAllJobGroupNames() throws GWTJahiaServiceException {
        try {
            return Arrays.asList(this.scheduler.getScheduler().getJobGroupNames());
        }
        catch (SchedulerException e) {
            throw new GWTJahiaServiceException("Cannot get all job group names. Cause: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public Integer deleteAllCompletedJobs() throws GWTJahiaServiceException {
        try {
            return this.scheduler.deleteAllCompletedJobs();
        }
        catch (SchedulerException e) {
            throw new GWTJahiaServiceException("Cannot delete completed jobs. Cause: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    class PollingSchedulerListener
    extends JobListenerSupport {
        int totalCount = -1;

        PollingSchedulerListener() {
        }

        public String getName() {
            return "PollingSchedulerListener";
        }

        public void jobToBeExecuted(JobExecutionContext context) {
            this.updateJobs(Arrays.asList(context.getJobDetail()), Collections.emptyList());
        }

        public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
            this.updateJobs(Collections.emptyList(), Arrays.asList(context.getJobDetail()));
        }

        private void updateJobs(List<JobDetail> startedJob, List<JobDetail> endedJob) {
            block9: {
                try {
                    BroadcasterFactory broadcasterFactory;
                    this.totalCount = this.totalCount == -1 ? SchedulerHelper.this.getActiveJobs(Locale.ENGLISH).size() : (this.totalCount += startedJob.size());
                    this.totalCount -= endedJob.size();
                    if (this.totalCount < 0) {
                        this.totalCount = 0;
                    }
                    if ((broadcasterFactory = AtmosphereServlet.getBroadcasterFactory()) == null) break block9;
                    ProcessPollingEvent pollingEvent = new ProcessPollingEvent();
                    if (startedJob != null) {
                        pollingEvent.setStartedJob(SchedulerHelper.this.convertToGWTJobs(startedJob));
                    }
                    if (endedJob != null) {
                        pollingEvent.setEndedJob(SchedulerHelper.this.convertToGWTJobs(endedJob));
                    }
                    pollingEvent.setTotalCount(this.totalCount);
                    Broadcaster broadcaster = broadcasterFactory.lookup((Object)"org.jahia.broadcaster");
                    if (broadcaster != null) {
                        broadcaster.broadcast((Object)pollingEvent);
                        break block9;
                    }
                    try {
                        ChannelHolder bean = (ChannelHolder)SpringContextSingleton.getBean("org.jahia.ajax.gwt.commons.server.ChannelHolderImpl");
                        JGroupsChannel jc = bean.getChannel();
                        if (jc != null) {
                            jc.send("org.jahia.broadcaster", pollingEvent);
                        }
                    }
                    catch (Exception e) {
                        SchedulerHelper.this.logger.debug(e.getMessage(), (Throwable)e);
                    }
                }
                catch (GWTJahiaServiceException e) {
                    SchedulerHelper.this.logger.error("Cannot parse jobs", (Throwable)e);
                }
            }
        }
    }
}

