/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.helper;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Model;
import org.apache.tika.io.IOUtils;
import org.apache.xerces.impl.dv.util.Base64;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jahia.ajax.gwt.client.data.GWTModuleReleaseInfo;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.service.GWTJahiaServiceException;
import org.jahia.ajax.gwt.helper.NavigationHelper;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.data.templates.ModuleReleaseInfo;
import org.jahia.data.templates.ModuleState;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.notification.HttpClientService;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.services.templates.SourceControlManagement;
import org.jahia.utils.PomUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleHelper {
    private static Logger logger = LoggerFactory.getLogger(ModuleHelper.class);
    private HttpClientService httpClient;
    private NavigationHelper navigation;
    private JahiaTemplateManagerService templateManagerService;

    private static ModuleReleaseInfo toModuleReleaseInfo(GWTModuleReleaseInfo gwtInfo) {
        ModuleReleaseInfo info = new ModuleReleaseInfo();
        info.setNextVersion(gwtInfo.getNextVersion());
        info.setPublishToMaven(gwtInfo.isPublishToMaven());
        info.setRepositoryId(gwtInfo.getRepositoryId());
        info.setRepositoryUrl(gwtInfo.getRepositoryUrl());
        info.setPublishToForge(gwtInfo.isPublishToForge());
        info.setForgeUrl(gwtInfo.getForgeUrl());
        info.setUsername(gwtInfo.getUsername());
        info.setPassword(gwtInfo.getPassword());
        return info;
    }

    public void addToSourceControl(String moduleId, GWTJahiaNode node, JCRSessionWrapper session) throws IOException, RepositoryException, BundleException {
        JahiaTemplatesPackage templatePackage = this.templateManagerService.getTemplatePackageById(moduleId);
        SourceControlManagement sourceControl = templatePackage.getSourceControl();
        if (sourceControl != null) {
            String path = node.getPath();
            path = path.substring(path.indexOf("/sources/") + 8);
            String sourcesFolderPath = templatePackage.getSourcesFolder().getAbsolutePath();
            sourceControl.add(new File(sourcesFolderPath + path));
        }
    }

    public GWTJahiaNode checkoutModule(String moduleId, String scmURI, String scmType, String branchOrTag, String sources, JCRSessionWrapper session) throws IOException, RepositoryException, BundleException {
        String fullUri;
        GWTJahiaNode node = null;
        JCRNodeWrapper nodeWrapper = this.templateManagerService.checkoutModule(sources != null ? new File(sources) : null, fullUri = "scm:" + scmType + ":" + scmURI, branchOrTag, moduleId, null, session);
        if (nodeWrapper != null) {
            node = this.navigation.getGWTJahiaNode(nodeWrapper.getParent(), GWTJahiaNode.DEFAULT_SITE_FIELDS);
        }
        return node;
    }

    public void compileAndDeploy(String moduleId, JCRSessionWrapper session) throws IOException, RepositoryException, BundleException {
        File sources = this.getSources(moduleId, session);
        this.templateManagerService.regenerateImportFile(moduleId, sources, session);
        JahiaTemplatesPackage jahiaTemplatesPackage = this.templateManagerService.compileAndDeploy(moduleId, sources, session);
        ModuleState state = jahiaTemplatesPackage.getState();
        if (state.getState() == ModuleState.State.SPRING_NOT_STARTED) {
            Throwable details = (Throwable)state.getDetails();
            throw new IOException(details.getMessage(), details);
        }
    }

    public GWTJahiaNode createModule(String moduleName, String artifactId, String groupId, String siteType, String sources, JCRSessionWrapper session) throws GWTJahiaServiceException {
        try {
            JCRNodeWrapper node = this.templateManagerService.createModule(moduleName, artifactId, groupId, siteType, sources != null ? new File(sources) : null, session);
            return node != null ? this.navigation.getGWTJahiaNode(node.getParent(), GWTJahiaNode.DEFAULT_SITE_FIELDS) : null;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException("Cannot create module " + moduleName + ". Cause: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void deployModule(String moduleName, String sitePath, JCRSessionWrapper currentUserSession) throws GWTJahiaServiceException {
        try {
            this.templateManagerService.installModule(moduleName, sitePath, currentUserSession.getUser().getName());
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException("Cannot deploy module " + moduleName + ". Cause: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private String updateRepositoryUrlFromForge(File pomFile, String forgeUrl, String username, String password) throws XmlPullParserException, IOException {
        String forgeFileUrl = forgeUrl + ".json";
        logger.info("Trying to retrieve Jahia repository information from resource at {}", (Object)forgeFileUrl);
        long timer = System.currentTimeMillis();
        String info = null;
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            if (username != null && password != null) {
                headers.put("Authorization", "Basic " + Base64.encode((byte[])(username + ":" + password).getBytes()));
            }
            info = this.httpClient.executeGet(forgeFileUrl, headers);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        if (info != null) {
            info = info.trim();
            try {
                JSONObject obj = new JSONObject(info);
                logger.info("Retrieved Jahia Private App Store information in {} ms. The URL to the Private App Store is: {}", (Object)(System.currentTimeMillis() - timer), (Object)info);
                PomUtils.updateDistributionManagement(pomFile, obj.getString("forgeSettingsId"), obj.getString("forgeSettingsUrl"));
            }
            catch (JSONException e) {
                throw new IOException("Cannot get info from Private App Store", e);
            }
        } else {
            throw new IOException("Cannot connect to Private App Store server");
        }
        return null;
    }

    public GWTModuleReleaseInfo getModuleDistributionInfo(String moduleId, JCRSessionWrapper session) throws RepositoryException, IOException, XmlPullParserException {
        JahiaTemplatesPackage pack = this.templateManagerService.getTemplatePackageById(moduleId);
        if (pack == null || !pack.getVersion().isSnapshot()) {
            return null;
        }
        File sources = this.templateManagerService.getSources(pack, session);
        if (sources == null) {
            return null;
        }
        Model pom = PomUtils.read(new File(sources, "pom.xml"));
        DistributionManagement distributionManagement = pom.getDistributionManagement();
        GWTModuleReleaseInfo info = new GWTModuleReleaseInfo();
        if (distributionManagement != null && distributionManagement.getRepository() != null) {
            String repositoryUrl = distributionManagement.getRepository().getUrl();
            info.setRepositoryId(distributionManagement.getRepository().getId());
            info.setRepositoryUrl(repositoryUrl);
        }
        if (pom.getProperties().containsKey("jahia-private-app-store")) {
            String property = pom.getProperties().getProperty("jahia-private-app-store");
            info.setForgeUrl(property);
            String pageUrl = property + "/contents/modules-repository/";
            if (StringUtils.isNotEmpty((String)pack.getGroupId())) {
                pageUrl = pageUrl + pack.getGroupId().replace(".", "/") + "/";
            }
            pageUrl = pageUrl + moduleId + ".html";
            info.setForgeModulePageUrl(pageUrl);
        }
        return info;
    }

    private File getSources(String moduleId, JCRSessionWrapper session) throws RepositoryException {
        return this.templateManagerService.getSources(this.templateManagerService.getTemplatePackageById(moduleId), session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GWTJahiaNode releaseModule(String moduleId, GWTModuleReleaseInfo gwtReleaseInfo, JCRSessionWrapper session) throws RepositoryException, IOException, BundleException {
        File f;
        String nextVersion;
        String string = nextVersion = gwtReleaseInfo != null ? gwtReleaseInfo.getNextVersion() : null;
        if (nextVersion != null) {
            ModuleReleaseInfo releaseInfo = ModuleHelper.toModuleReleaseInfo(gwtReleaseInfo);
            f = this.templateManagerService.releaseModule(moduleId, releaseInfo, session);
            gwtReleaseInfo.setForgeModulePageUrl(releaseInfo.getForgeModulePageUrl());
            gwtReleaseInfo.setArtifactUrl(releaseInfo.getArtifactUrl());
        } else {
            JahiaTemplatesPackage previous = this.templateManagerService.getTemplatePackageById(moduleId);
            f = this.templateManagerService.compileModule(previous.getSourcesFolder());
        }
        if (f == null) {
            return null;
        }
        JCRNodeWrapper privateFolder = JCRContentUtils.getInstance().getUserPrivateFilesFolder(session);
        if (!privateFolder.hasNode("modules")) {
            session.checkout(privateFolder);
            privateFolder.addNode("modules", "jnt:folder");
        }
        JCRNodeWrapper parent = privateFolder.getNode("modules");
        session.checkout(parent);
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));
        try {
            JCRNodeWrapper res = parent.uploadFile(f.getName(), is, "application/x-zip");
            session.save();
            GWTJahiaNode gWTJahiaNode = this.navigation.getGWTJahiaNode(res);
            return gWTJahiaNode;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
            FileUtils.deleteQuietly((File)f);
        }
    }

    public boolean saveAndCommitModule(String moduleId, String message, JCRSessionWrapper session) throws RepositoryException, IOException {
        SourceControlManagement scm = null;
        File sources = this.getSources(moduleId, session);
        try {
            scm = this.templateManagerService.getTemplatePackageById(moduleId).getSourceControl();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (scm != null) {
            this.templateManagerService.regenerateImportFile(moduleId, sources, session);
            return scm.commit(message);
        }
        throw new IOException("No SCM configured");
    }

    public GWTJahiaNode sendToSourceControl(String moduleName, String scmURI, String scmType, JCRSessionWrapper session) throws IOException, RepositoryException {
        this.templateManagerService.sendToSourceControl(moduleName, scmURI, scmType, session);
        return this.navigation.getGWTJahiaNode(session.getNode("/modules/" + moduleName), GWTJahiaNode.DEFAULT_SITE_FIELDS);
    }

    public void setHttpClient(HttpClientService httpClient) {
        this.httpClient = httpClient;
    }

    public void setNavigation(NavigationHelper navigation) {
        this.navigation = navigation;
    }

    public void setTemplateManagerService(JahiaTemplateManagerService templateManagerService) {
        this.templateManagerService = templateManagerService;
    }

    public void updateForgeUrlForModule(String module, String forgeUrl, JCRSessionWrapper session, String username, String password) throws IOException, XmlPullParserException, RepositoryException {
        JahiaTemplatesPackage pack;
        File sources = this.getSources(module, session);
        if (sources != null && (pack = this.templateManagerService.getTemplatePackageById(module)) != null && this.templateManagerService.checkValidSources(pack, sources)) {
            File pomFile = new File(sources, "pom.xml");
            this.updateRepositoryUrlFromForge(pomFile, forgeUrl, username, password);
            PomUtils.updateForgeUrl(pomFile, forgeUrl);
            SourceControlManagement scm = pack.getSourceControl();
            if (scm != null) {
                scm.add(pomFile);
                scm.commit("Updated distribution server information");
            }
        }
    }

    public void updateDistributionServerForModule(String module, String repositoryId, String repositoryUrl, JCRSessionWrapper session) throws IOException, XmlPullParserException, RepositoryException {
        JahiaTemplatesPackage pack;
        File sources = this.getSources(module, session);
        if (sources != null && (pack = this.templateManagerService.getTemplatePackageById(module)) != null && this.templateManagerService.checkValidSources(pack, sources)) {
            File pomFile = new File(sources, "pom.xml");
            PomUtils.updateDistributionManagement(pomFile, repositoryId, repositoryUrl);
            SourceControlManagement scm = pack.getSourceControl();
            if (scm != null) {
                scm.add(pomFile);
                scm.commit("Updated distribution server information");
            }
        }
    }

    public String updateModule(String moduleId, JCRSessionWrapper session) throws IOException, RepositoryException, BundleException {
        String output = null;
        File sources = this.getSources(moduleId, session);
        SourceControlManagement scm = this.templateManagerService.getTemplatePackageById(moduleId).getSourceControl();
        if (scm == null) {
            throw new IOException("No SCM configured");
        }
        this.templateManagerService.regenerateImportFile(moduleId, sources, session);
        output = scm.update();
        this.templateManagerService.compileAndDeploy(moduleId, sources, session);
        return output;
    }
}

