/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.content.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.LimitedInputStream;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jahia.ajax.gwt.client.service.GWTJahiaServiceException;
import org.jahia.ajax.gwt.helper.VersioningHelper;
import org.jahia.ajax.gwt.helper.ZipHelper;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRVersionService;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GWTFileManagerUploadServlet
extends HttpServlet
implements HttpSessionListener {
    private static final long serialVersionUID = 1048509772346464862L;
    public static final int OK = 0;
    public static final int EXISTS = 1;
    public static final int READONLY = 2;
    public static final int BAD_LOCATION = 3;
    public static final int UNKNOWN_ERROR = 9;
    private static Logger logger = LoggerFactory.getLogger(GWTFileManagerUploadServlet.class);
    private static Map<String, Item> asyncItems = new ConcurrentHashMap<String, Item>();

    private static long getContentLength(FileItemHeaders pHeaders) {
        try {
            return Long.parseLong(pHeaders.getHeader("Content-length"));
        }
        catch (Exception e) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block46: {
            block45: {
                factory = new DiskFileItemFactory();
                upload = new ServletFileUpload((FileItemFactory)factory);
                settingsBean = SettingsBean.getInstance();
                fileSizeLimit = settingsBean.getJahiaFileUploadMaxSize();
                upload.setHeaderEncoding("UTF-8");
                uploads = new HashMap<String, FileItem>();
                location = null;
                type = null;
                unzip = false;
                response.setContentType("text/plain; charset=" + settingsBean.getCharacterEncoding());
                printWriter = response.getWriter();
                try {
                    itemIterator = upload.getItemIterator(request);
                    sizeLimitExceededException = null;
                    while (itemIterator.hasNext()) {
                        item = itemIterator.next();
                        if (sizeLimitExceededException != null) continue;
                        fileItem = factory.createItem(item.getFieldName(), item.getContentType(), item.isFormField(), item.getName());
                        contentLength = GWTFileManagerUploadServlet.getContentLength(item.getHeaders());
                        if (fileSizeLimit > 0L && contentLength != -1L && contentLength > fileSizeLimit) {
                            throw new FileUploadBase.FileSizeLimitExceededException("The field " + item.getFieldName() + " exceeds its maximum permitted size of " + fileSizeLimit + " bytes.", contentLength, fileSizeLimit);
                        }
                        itemStream = item.openStream();
                        limitedInputStream /* !! */  = null;
                        try {
                            limitedInputStream /* !! */  = fileSizeLimit > 0L ? new LimitedInputStream(itemStream, fileSizeLimit){

                                protected void raiseError(long pSizeMax, long pCount) throws IOException {
                                    throw new FileUploadBase.FileUploadIOException((FileUploadException)new FileUploadBase.FileSizeLimitExceededException("The field " + item.getFieldName() + " exceeds its maximum permitted size of " + fileSizeLimit + " bytes.", pCount, pSizeMax));
                                }
                            } : itemStream;
                            Streams.copy((InputStream)limitedInputStream /* !! */ , (OutputStream)fileItem.getOutputStream(), (boolean)true);
                        }
                        catch (FileUploadBase.FileUploadIOException e) {
                            block42: {
                                try {
                                    if (e.getCause() instanceof FileUploadBase.FileSizeLimitExceededException) {
                                        if (sizeLimitExceededException == null) {
                                            sizeLimitExceededException = (FileUploadBase.FileSizeLimitExceededException)e.getCause();
                                        }
                                        break block42;
                                    }
                                    throw e;
                                }
                                catch (Throwable var22_29) {
                                    IOUtils.closeQuietly(limitedInputStream /* !! */ );
                                    throw var22_29;
                                }
                            }
                            IOUtils.closeQuietly((InputStream)limitedInputStream /* !! */ );
                        }
                        IOUtils.closeQuietly((InputStream)limitedInputStream /* !! */ );
                        if ("unzip".equals(fileItem.getFieldName())) {
                            unzip = true;
                            continue;
                        }
                        if ("uploadLocation".equals(fileItem.getFieldName())) {
                            location = fileItem.getString("UTF-8");
                            continue;
                        }
                        if ("asyncupload".equals(fileItem.getFieldName())) {
                            name = fileItem.getName();
                            if (name.trim().length() > 0) {
                                uploads.put(this.extractFileName(name, uploads), fileItem);
                            }
                            type = "async";
                            continue;
                        }
                        if (fileItem.isFormField() || !fileItem.getFieldName().startsWith("uploadedFile")) continue;
                        name = fileItem.getName();
                        if (name.trim().length() > 0) {
                            uploads.put(this.extractFileName(name, uploads), fileItem);
                        }
                        type = "sync";
                    }
                    if (sizeLimitExceededException != null) {
                        throw sizeLimitExceededException;
                    }
                }
                catch (FileUploadBase.FileSizeLimitExceededException e) {
                    printWriter.write("UPLOAD-SIZE-ISSUE: " + this.getSizeLimitErrorMessage(fileSizeLimit, e, request) + "\n");
                    return;
                }
                catch (FileUploadBase.FileUploadIOException e) {
                    if (e.getCause() != null && e.getCause() instanceof FileUploadBase.FileSizeLimitExceededException) {
                        printWriter.write("UPLOAD-SIZE-ISSUE: " + this.getSizeLimitErrorMessage(fileSizeLimit, (FileUploadBase.FileSizeLimitExceededException)e.getCause(), request) + "\n");
                    } else {
                        GWTFileManagerUploadServlet.logger.error("UPLOAD-ISSUE", (Throwable)e);
                        printWriter.write("UPLOAD-ISSUE: " + e.getLocalizedMessage() + "\n");
                    }
                    return;
                }
                catch (FileUploadException e) {
                    GWTFileManagerUploadServlet.logger.error("UPLOAD-ISSUE", (Throwable)e);
                    printWriter.write("UPLOAD-ISSUE: " + e.getLocalizedMessage() + "\n");
                    return;
                }
                if (type != null && !type.equals("sync")) break block45;
                response.setContentType("text/plain");
                user = (JahiaUser)request.getSession().getAttribute("org.jahia.usermanager.jahiauser");
                pathsToUnzip = new ArrayList<String>();
lbl85:
                // 7 sources

                block28: for (String filename : uploads.keySet()) {
                    item = (FileItem)uploads.get(filename);
                    try {
                        name = new StringBuilder(filename);
                        i = this.writeToDisk(user, item, location, name);
                        switch (i) {
                            case 0: {
                                if (unzip && filename.toLowerCase().endsWith(".zip")) {
                                    pathsToUnzip.add(location + "/" + name.toString());
                                }
                                printWriter.write("OK: " + name.toString() + "\n");
                                ** break;
                            }
                            case 1: {
                                f = File.createTempFile("upload", null);
                                is = item.getInputStream();
                                os = new BufferedOutputStream(new FileOutputStream(f));
                                try {
                                    IOUtils.copy((InputStream)is, (OutputStream)os);
                                }
                                finally {
                                    IOUtils.closeQuietly((OutputStream)os);
                                    IOUtils.closeQuietly((InputStream)is);
                                }
                                GWTFileManagerUploadServlet.asyncItems.put(f.getName(), new Item(item.getName(), item.getContentType(), item.getSize(), f, request.getSession().getId()));
                                printWriter.write("EXISTS: " + item.getFieldName() + " " + f.getName() + " " + filename + "\n");
                                ** break;
                            }
                            case 2: {
                                printWriter.write("READONLY: " + item.getFieldName() + "\n");
                                ** break;
                            }
                            default: {
                                printWriter.write("UPLOAD-FAILED: " + item.getFieldName() + "\n");
                                continue block28;
                            }
                        }
                    }
                    catch (IOException e) {
                        GWTFileManagerUploadServlet.logger.error("Upload failed for file \n", (Throwable)e);
                    }
                    finally {
                        item.delete();
                    }
                }
                if (!unzip || pathsToUnzip.size() <= 0) break block46;
                try {
                    zip = ZipHelper.getInstance();
                    zip.unzip(pathsToUnzip, true, JCRSessionFactory.getInstance().getCurrentUserSession(), (Locale)request.getSession().getAttribute("org.jahia.services.multilang.uilocale"));
                }
                catch (RepositoryException e) {
                    GWTFileManagerUploadServlet.logger.error("Auto-unzipping failed", (Throwable)e);
                }
                catch (GWTJahiaServiceException e) {
                    GWTFileManagerUploadServlet.logger.error("Auto-unzipping failed", (Throwable)e);
                }
                break block46;
            }
            response.setContentType("text/html");
            for (FileItem fileItem : uploads.values()) {
                printWriter.write("<html><body>");
                f = File.createTempFile("upload", ".tmp");
                is = fileItem.getInputStream();
                os = new BufferedOutputStream(new FileOutputStream(f));
                try {
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)os);
                    IOUtils.closeQuietly((InputStream)is);
                }
                printWriter.write("<div id=\"uploaded\" key=\"" + f.getName() + "\" name=\"" + fileItem.getName() + "\"></div>\n");
                printWriter.write("</body></html>");
                GWTFileManagerUploadServlet.asyncItems.put(f.getName(), new Item(fileItem.getName(), fileItem.getContentType(), fileItem.getSize(), f, request.getSession().getId()));
            }
        }
    }

    private String getSizeLimitErrorMessage(long fileSizeLimit, FileUploadBase.FileSizeLimitExceededException e, HttpServletRequest request) {
        Locale locale = (Locale)request.getSession().getAttribute("org.jahia.services.multilang.uilocale");
        if (locale == null) {
            locale = (Locale)request.getSession().getAttribute("org.jahia.services.multilang.currentlocale");
        }
        if (logger.isDebugEnabled()) {
            logger.warn("File upload exceeding limit of " + fileSizeLimit + " bytes", (Throwable)e);
        } else {
            logger.warn("File upload exceeding limit of {} bytes", (Object)fileSizeLimit);
        }
        return Messages.getInternalWithArguments("fileSizeError.label", "File upload exceeding limit of {0} bytes", locale, fileSizeLimit);
    }

    private String extractFileName(String rawFileName, Map<String, FileItem> uploads) {
        int und;
        String basename = rawFileName.indexOf("\\") >= 0 ? rawFileName.substring(rawFileName.lastIndexOf("\\") + 1) : (rawFileName.indexOf("/") >= 0 ? rawFileName.substring(rawFileName.lastIndexOf("/") + 1) : rawFileName);
        int i = 1;
        String name = basename;
        int dot = basename.lastIndexOf(46);
        String ext = "";
        if (dot > 0) {
            ext = basename.substring(dot);
            basename = basename.substring(0, dot);
        }
        if ((und = basename.lastIndexOf(45)) > -1 && basename.substring(und + 1).matches("[0-9]+")) {
            basename = basename.substring(0, und);
        }
        while (uploads.containsKey(name)) {
            name = basename + "-" + i++ + ext;
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeToDisk(JahiaUser user, FileItem item, String location, StringBuilder name) throws IOException {
        JCRNodeWrapper locationFolder;
        String filename = name.toString();
        if (logger.isDebugEnabled()) {
            logger.debug("item : " + item);
            logger.debug("destination : " + location);
            logger.debug("filename : " + filename);
            logger.debug("size : " + item.getSize());
        }
        if (item == null || location == null || filename == null) {
            return 9;
        }
        try {
            locationFolder = JCRSessionFactory.getInstance().getCurrentUserSession().getNode(location);
        }
        catch (RepositoryException e) {
            logger.error(e.toString(), (Throwable)e);
            return 3;
        }
        if (!locationFolder.hasPermission("jcr:addChildNodes") || locationFolder.isLocked()) {
            logger.debug("destination is not writable for user " + user.getName());
            return 2;
        }
        try {
            if (locationFolder.hasNode(JCRContentUtils.escapeLocalNodeName(filename))) {
                return 1;
            }
            InputStream is = item.getInputStream();
            try {
                boolean versioningAvailable = false;
                if (locationFolder.getProvider().isVersioningAvailable()) {
                    versioningAvailable = true;
                }
                if (versioningAvailable) {
                    locationFolder.getSession().checkout(locationFolder);
                }
                JCRNodeWrapper node = locationFolder.uploadFile(filename, is, JCRContentUtils.getMimeType(filename, item.getContentType()));
                node.getSession().save();
                if (!node.getName().equals(filename)) {
                    name.delete(0, name.length());
                    name.append(node.getName());
                }
                if ((node = node.getSession().getNodeByIdentifier(node.getIdentifier())).getProvider().isVersioningAvailable()) {
                    node.checkpoint();
                    JCRVersionService.getInstance().addVersionLabel(node, VersioningHelper.getVersionLabel(node.getProperty("jcr:created").getDate().getTime().getTime()));
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
            locationFolder.saveSession();
        }
        catch (RepositoryException e) {
            logger.error("exception ", (Throwable)e);
            return 9;
        }
        return 0;
    }

    public static Item getItem(String key) {
        return asyncItems.get(key);
    }

    public void sessionCreated(HttpSessionEvent se) {
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        String id = null;
        try {
            id = se.getSession().getId();
        }
        catch (Exception e) {
            logger.warn("Unable to get ID of the session. Skip cleaning up temporary uploaded files.", (Throwable)e);
        }
        if (id != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Checking temporary uploaded files for session with ID " + id);
            }
            Iterator<Map.Entry<String, Item>> iterator = asyncItems.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Item> entry = iterator.next();
                Item item = entry.getValue();
                if (item.sessionId == null || !id.equals(item.sessionId)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Removing item " + item.file);
                }
                iterator.remove();
                item.file.delete();
            }
        }
    }

    public static class Item {
        private String contentType;
        private long length;
        private File file;
        private String sessionId;
        private String originalFileName;

        Item(String originalFileName, String contentType, long length, File file, String sessionId) throws FileNotFoundException {
            this.originalFileName = originalFileName;
            this.contentType = contentType;
            this.length = length;
            this.file = file;
            this.sessionId = sessionId;
        }

        public String getOriginalFileName() {
            return this.originalFileName;
        }

        public InputStream getStream() throws FileNotFoundException {
            return new BufferedInputStream(new FileInputStream(this.file));
        }

        public String getContentType() {
            return this.contentType;
        }

        public long getLength() {
            return this.length;
        }

        public File getFile() {
            return this.file;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public void dispose() {
            if (this.file != null) {
                asyncItems.remove(this.file.getName());
                FileUtils.deleteQuietly((File)this.file);
            }
        }
    }
}

