/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.jcr;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.jcr.Repository;
import javax.jcr.Session;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.jackrabbit.webdav.jcr.AbstractResource;
import org.apache.jackrabbit.webdav.jcr.JahiaRootCollection;
import org.apache.jackrabbit.webdav.jcr.JcrDavSession;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.LockInfo;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaServerRootCollection
extends AbstractResource {
    public static final String MAP_POINT = "repository";
    private static Logger log = LoggerFactory.getLogger(JahiaServerRootCollection.class);
    private static final ActiveLock[] activeLocks = new ActiveLock[0];

    public JahiaServerRootCollection(DavResourceLocator locator, JcrDavSession session, DavResourceFactory factory) {
        super(locator, session, factory);
        this.initLockSupport();
        this.initSupportedReports();
    }

    public String getSupportedMethods() {
        StringBuilder sb = new StringBuilder("OPTIONS, GET, HEAD, POST, TRACE, PROPFIND, PROPPATCH, MKCOL, COPY, PUT, DELETE, MOVE, LOCK, UNLOCK");
        sb.append(", ");
        return sb.toString();
    }

    public boolean exists() {
        return true;
    }

    public boolean isCollection() {
        return true;
    }

    public String getDisplayName() {
        return "";
    }

    public long getModificationTime() {
        return new Date().getTime();
    }

    public void spool(OutputContext outputContext) throws IOException {
        if (outputContext.hasStream()) {
            Session session = this.getRepositorySession();
            Repository rep = session.getRepository();
            String repName = rep.getDescriptor("jcr.repository.name");
            String repURL = rep.getDescriptor("jcr.repository.vendor.url");
            String repVersion = rep.getDescriptor("jcr.repository.version");
            String repostr = repName + " " + repVersion;
            StringBuilder sb = new StringBuilder();
            sb.append("<html><head><title>");
            sb.append(repostr);
            sb.append("</title></head>");
            sb.append("<body><h2>").append(repostr).append("</h2>");
            sb.append("<h3>Available WebDav Mount Points:</h3><ul>");
            DavResourceIterator it = this.getMembers();
            while (it.hasNext()) {
                DavResource res = it.nextResource();
                sb.append("<li><a href=\"");
                sb.append(res.getHref());
                sb.append("\">");
                sb.append(res.getDisplayName());
                sb.append("</a></li>");
            }
            sb.append("</ul><hr size=\"1\"><em>Powered by <a href=\"");
            sb.append(repURL).append("\">").append(repName);
            sb.append("</a> ").append(repVersion);
            sb.append("</em></body></html>");
            outputContext.setContentLength((long)sb.length());
            outputContext.setModificationTime(this.getModificationTime());
            PrintWriter writer = new PrintWriter(new OutputStreamWriter(outputContext.getOutputStream(), "utf8"));
            writer.print(sb.toString());
            writer.close();
        } else {
            outputContext.setContentLength(0L);
            outputContext.setModificationTime(this.getModificationTime());
        }
    }

    public DavResource getCollection() {
        return null;
    }

    public void addMember(DavResource resource, InputContext inputContext) throws DavException {
        throw new DavException(403);
    }

    public DavResourceIterator getMembers() {
        List<JahiaRootCollection> list = Collections.singletonList(new JahiaRootCollection(this.getLocator().getFactory().createResourceLocator(this.getLocator().getPrefix(), null, null, true), (JcrDavSession)this.getSession(), this.getFactory()));
        return new DavResourceIteratorImpl(list);
    }

    public void removeMember(DavResource member) throws DavException {
        throw new DavException(403);
    }

    public void addWorkspace(DavResource workspace) throws DavException {
        throw new DavException(403);
    }

    protected void initLockSupport() {
    }

    protected String getWorkspaceHref() {
        return null;
    }

    public String getHref() {
        return "/";
    }

    public void move(DavResource destination) throws DavException {
        throw new DavException(403);
    }

    public void copy(DavResource destination, boolean shallow) throws DavException {
        throw new DavException(403);
    }

    public boolean isLockable(Type type, Scope scope) {
        return false;
    }

    public boolean hasLock(Type type, Scope scope) {
        return false;
    }

    public ActiveLock getLock(Type type, Scope scope) {
        return null;
    }

    public ActiveLock[] getLocks() {
        return activeLocks;
    }

    public ActiveLock lock(LockInfo reqLockInfo) throws DavException {
        throw new DavException(403);
    }

    public ActiveLock refreshLock(LockInfo reqLockInfo, String lockToken) throws DavException {
        throw new DavException(403);
    }

    public void unlock(String lockToken) throws DavException {
    }
}

