/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security;

import java.security.Principal;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import javax.security.auth.Subject;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.security.DefaultAccessManager;
import org.apache.jackrabbit.core.security.SystemPrincipal;
import org.apache.jackrabbit.core.security.authorization.AccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.WorkspaceAccessManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;

public class JahiaSystemSession
extends SessionImpl {
    private static final AccessControlPolicy[] ACCESS_CONTROL_POLICIES = new AccessControlPolicy[0];
    private static final String SYSTEM_PRINCIPAL_NAME = new SystemPrincipal().getName();
    private static SystemAccessManager systemAccessManager;

    public JahiaSystemSession(RepositoryContext repositoryContext, Subject subject, WorkspaceConfig wspConfig) throws RepositoryException {
        super(repositoryContext, subject, wspConfig);
    }

    protected final String retrieveUserId(Subject subject, String workspaceName) throws RepositoryException {
        return SYSTEM_PRINCIPAL_NAME;
    }

    protected AccessManager createAccessManager(Subject subject) throws AccessDeniedException, RepositoryException {
        if (systemAccessManager == null) {
            systemAccessManager = new SystemAccessManager();
        }
        return systemAccessManager;
    }

    private class SystemAccessManager
    extends DefaultAccessManager
    implements AccessManager {
        SystemAccessManager() {
        }

        public void init(AMContext context) throws AccessDeniedException, Exception {
        }

        public void init(AMContext context, AccessControlProvider acProvider, WorkspaceAccessManager wspAccessMgr) throws AccessDeniedException, Exception {
        }

        public void close() throws Exception {
        }

        public void checkPermission(ItemId id, int permissions) throws AccessDeniedException, RepositoryException {
        }

        public void checkPermission(Path absPath, int permissions) throws AccessDeniedException, RepositoryException {
        }

        public boolean isGranted(ItemId id, int permissions) throws RepositoryException {
            return true;
        }

        public boolean isGranted(Path absPath, int permissions) throws RepositoryException {
            return true;
        }

        public boolean isGranted(Path parentPath, Name childName, int permissions) throws RepositoryException {
            return true;
        }

        public boolean canRead(Path path, ItemId itemId) throws RepositoryException {
            return true;
        }

        public boolean canAccess(String workspaceName) throws RepositoryException {
            return true;
        }

        protected void checkInitialized() throws IllegalStateException {
        }

        protected void checkPermission(String absPath, int permission) throws AccessDeniedException, PathNotFoundException, RepositoryException {
        }

        public void checkRepositoryPermission(int permissions) throws AccessDeniedException, RepositoryException {
        }

        public boolean hasPrivileges(String absPath, Privilege[] privileges) throws PathNotFoundException, RepositoryException {
            this.checkValidNodePath(absPath);
            return true;
        }

        public Privilege[] getPrivileges(String absPath) throws PathNotFoundException, RepositoryException {
            this.checkValidNodePath(absPath);
            return new Privilege[]{this.privilegeFromName("{http://www.jcp.org/jcr/1.0}all")};
        }

        public AccessControlPolicy[] getEffectivePolicies(String absPath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
            return ACCESS_CONTROL_POLICIES;
        }

        public AccessControlPolicy[] getEffectivePolicies(Set<Principal> principals) throws AccessDeniedException, AccessControlException, UnsupportedRepositoryOperationException, RepositoryException {
            return ACCESS_CONTROL_POLICIES;
        }

        public boolean hasPrivileges(String absPath, Set<Principal> principals, Privilege[] privileges) throws PathNotFoundException, RepositoryException {
            throw new UnsupportedOperationException("not implemented");
        }

        public Privilege[] getPrivileges(String absPath, Set<Principal> principals) throws PathNotFoundException, RepositoryException {
            throw new UnsupportedOperationException("not implemented");
        }
    }
}

