/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security;

import java.io.IOException;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.apache.jackrabbit.core.security.authentication.CredentialsCallback;

public class JahiaCallbackHandler
implements CallbackHandler {
    private SimpleCredentials credentials;

    public JahiaCallbackHandler(SimpleCredentials credentials) {
        this.credentials = credentials;
    }

    public SimpleCredentials getCredentials() {
        return this.credentials;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof CredentialsCallback) {
                ((CredentialsCallback)callback).setCredentials((Credentials)this.credentials);
                continue;
            }
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.credentials.getUserID());
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.credentials.getPassword());
                continue;
            }
            if (callback instanceof RealmCallback) {
                ((RealmCallback)callback).setText((String)this.credentials.getAttribute("org.jahia.realm"));
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }
}

