/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security;

import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.apache.jackrabbit.core.config.LoginModuleConfig;
import org.apache.jackrabbit.core.security.authentication.AuthContext;
import org.apache.jackrabbit.core.security.authentication.AuthContextProvider;
import org.apache.jackrabbit.core.security.authentication.CallbackHandlerImpl;
import org.apache.jackrabbit.core.security.authentication.JAASAuthContext;
import org.apache.jackrabbit.core.security.authentication.LocalAuthContext;
import org.apache.jackrabbit.core.security.principal.PrincipalProviderRegistry;

public class JahiaAuthContextProvider
extends AuthContextProvider {
    private String applicationName;
    private LoginModuleConfig configuration;

    public JahiaAuthContextProvider(String appName, LoginModuleConfig config) {
        super(appName, config);
        this.applicationName = appName;
        this.configuration = config;
    }

    public AuthContext getAuthContext(Credentials credentials, Subject subject, Session session, PrincipalProviderRegistry principalProviderRegistry, String adminId, String anonymousId) throws RepositoryException {
        CallbackHandlerImpl cbHandler = new CallbackHandlerImpl(credentials, session, principalProviderRegistry, adminId, anonymousId);
        if (this.isLocal()) {
            return new JahiaLocalAuthContext(this.configuration, (CallbackHandler)cbHandler, subject);
        }
        if (this.isJAAS()) {
            return new JahiaJAASAuthContext(this.applicationName, (CallbackHandler)cbHandler, subject);
        }
        throw new RepositoryException("No Login-Configuration");
    }

    public boolean isJAAS() {
        return !this.isLocal() && super.isJAAS();
    }

    public boolean isLocal() {
        return this.configuration != null;
    }

    public static class JahiaLocalAuthContext
    extends LocalAuthContext {
        protected JahiaLocalAuthContext(LoginModuleConfig config, CallbackHandler cbHandler, Subject subject) {
            super(config, cbHandler, subject);
        }
    }

    public static class JahiaJAASAuthContext
    extends JAASAuthContext {
        protected JahiaJAASAuthContext(String appName, CallbackHandler cbHandler, Subject subject) {
            super(appName, cbHandler, subject);
        }
    }
}

