/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.Calendar;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.VersionManagerImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.UpdatableItemStateManager;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.InternalActivity;
import org.apache.jackrabbit.core.version.InternalBaseline;
import org.apache.jackrabbit.core.version.InternalFrozenNode;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.NodeStateEx;
import org.apache.jackrabbit.core.version.VersionImpl;
import org.apache.jackrabbit.core.version.VersionManagerImplBase;
import org.apache.jackrabbit.core.version.VersionSelector;
import org.apache.jackrabbit.core.version.VersionSet;
import org.apache.jackrabbit.core.version.VersioningLock;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;

public class JahiaVersionManagerImpl
extends VersionManagerImpl {
    public JahiaVersionManagerImpl(SessionContext context, UpdatableItemStateManager stateMgr, HierarchyManager hierMgr) {
        super(context, stateMgr, hierMgr);
    }

    public VersionManagerImplBase.WriteOperation startWriteOperation() throws RepositoryException {
        return super.startWriteOperation();
    }

    public Version checkin(String absPath) throws RepositoryException {
        return super.checkin(absPath);
    }

    public Version checkin(String absPath, Calendar created) throws RepositoryException {
        return super.checkin(absPath, created);
    }

    public void checkout(String absPath) throws RepositoryException {
        super.checkout(absPath);
    }

    public Version checkpoint(String absPath) throws RepositoryException {
        return super.checkpoint(absPath);
    }

    public boolean isCheckedOut(String absPath) throws RepositoryException {
        return super.isCheckedOut(absPath);
    }

    public VersionHistory getVersionHistory(String absPath) throws RepositoryException {
        return super.getVersionHistory(absPath);
    }

    public Version getBaseVersion(String absPath) throws RepositoryException {
        return super.getBaseVersion(absPath);
    }

    public void restore(Version version, boolean removeExisting) throws RepositoryException {
        super.restore(version, removeExisting);
    }

    public void restore(Version[] versions, boolean removeExisting) throws RepositoryException {
        super.restore(versions, removeExisting);
    }

    public void restore(String absPath, String versionName, boolean removeExisting) throws RepositoryException {
        super.restore(absPath, versionName, removeExisting);
    }

    public void restore(String absPath, Version version, boolean removeExisting) throws RepositoryException {
        super.restore(absPath, version, removeExisting);
    }

    protected void restore(NodeImpl node, Version version, boolean removeExisting) throws RepositoryException {
        super.restore(node, version, removeExisting);
    }

    public void restoreByLabel(String absPath, String versionLabel, boolean removeExisting) throws RepositoryException {
        super.restoreByLabel(absPath, versionLabel, removeExisting);
    }

    public void update(NodeImpl node, String srcWorkspaceName) throws RepositoryException {
        super.update(node, srcWorkspaceName);
    }

    public NodeIterator merge(String absPath, String srcWorkspace, boolean bestEffort) throws RepositoryException {
        return super.merge(absPath, srcWorkspace, bestEffort);
    }

    public NodeIterator merge(String absPath, String srcWorkspaceName, boolean bestEffort, boolean isShallow) throws RepositoryException {
        return super.merge(absPath, srcWorkspaceName, bestEffort, isShallow);
    }

    public void doneMerge(String absPath, Version version) throws RepositoryException {
        super.doneMerge(absPath, version);
    }

    public void cancelMerge(String absPath, Version version) throws RepositoryException {
        super.cancelMerge(absPath, version);
    }

    public Node createConfiguration(String absPath) throws RepositoryException {
        return super.createConfiguration(absPath);
    }

    public Node setActivity(Node activity) throws RepositoryException {
        return super.setActivity(activity);
    }

    public Node getActivity() throws RepositoryException {
        return super.getActivity();
    }

    public Node createActivity(String title) throws RepositoryException {
        return super.createActivity(title);
    }

    public void removeActivity(Node node) throws RepositoryException {
        super.removeActivity(node);
    }

    public NodeIterator merge(Node activityNode) throws RepositoryException {
        return super.merge(activityNode);
    }

    protected NodeId restore(NodeStateEx parent, Name name, InternalBaseline baseline) throws RepositoryException {
        return super.restore(parent, name, baseline);
    }

    protected NodeId createConfiguration(NodeStateEx state) throws RepositoryException {
        return super.createConfiguration(state);
    }

    protected void merge(NodeStateEx state, NodeStateEx srcRoot, List<ItemId> failedIds, boolean bestEffort, boolean shallow) throws RepositoryException, ItemStateException {
        super.merge(state, srcRoot, failedIds, bestEffort, shallow);
    }

    protected void finishMerge(NodeStateEx state, Version version, boolean cancel) throws RepositoryException {
        super.finishMerge(state, version, cancel);
    }

    protected void merge(InternalActivity activity, List<ItemId> failedIds) throws RepositoryException {
        super.merge(activity, failedIds);
    }

    protected void restore(NodeStateEx state, InternalVersion v, boolean removeExisting) throws RepositoryException {
        super.restore(state, v, removeExisting);
    }

    protected void restore(NodeStateEx state, Name versionName, boolean removeExisting) throws RepositoryException {
        super.restore(state, versionName, removeExisting);
    }

    protected void restoreByLabel(NodeStateEx state, Name versionLabel, boolean removeExisting) throws RepositoryException {
        super.restoreByLabel(state, versionLabel, removeExisting);
    }

    protected void restore(NodeStateEx parent, Name name, InternalVersion v, boolean removeExisting) throws RepositoryException {
        super.restore(parent, name, v, removeExisting);
    }

    protected void internalRestore(VersionSet versions, boolean removeExisting) throws RepositoryException, ItemStateException {
        super.internalRestore(versions, removeExisting);
    }

    protected Set<InternalVersion> internalRestore(NodeStateEx state, InternalVersion version, VersionSelector vsel, boolean removeExisting) throws RepositoryException, ItemStateException {
        return super.internalRestore(state, version, vsel, removeExisting);
    }

    protected void internalRestoreFrozen(NodeStateEx state, InternalFrozenNode freeze, VersionSelector vsel, Set<InternalVersion> restored, boolean removeExisting, boolean copy) throws RepositoryException, ItemStateException {
        super.internalRestoreFrozen(state, freeze, vsel, restored, removeExisting, copy);
    }

    protected NodeId checkoutCheckin(NodeStateEx state, boolean checkin, boolean checkout, Calendar created) throws RepositoryException {
        return super.checkoutCheckin(state, checkin, checkout, created);
    }

    protected boolean checkVersionable(NodeStateEx state) throws UnsupportedRepositoryOperationException, RepositoryException {
        return super.checkVersionable(state);
    }

    protected String safeGetJCRPath(NodeStateEx state) {
        return super.safeGetJCRPath(state);
    }

    protected boolean isCheckedOut(NodeStateEx state) throws RepositoryException {
        return super.isCheckedOut(state);
    }

    protected NodeId getBaseVersionId(NodeStateEx state) {
        return super.getBaseVersionId(state);
    }

    protected InternalVersionHistory getVersionHistory(NodeStateEx state) throws RepositoryException {
        return super.getVersionHistory(state);
    }

    protected InternalVersion getVersion(Version v) throws RepositoryException {
        return super.getVersion(v);
    }

    protected InternalVersion getBaseVersion(NodeStateEx state) throws RepositoryException {
        return super.getBaseVersion(state);
    }

    protected NodeStateEx getNodeStateEx(NodeId nodeId) throws RepositoryException {
        return super.getNodeStateEx(nodeId);
    }

    protected void checkModify(NodeStateEx state, int options, int permissions) throws RepositoryException {
        super.checkModify(state, options, permissions);
    }

    protected void checkModify(NodeImpl node, int options, int permissions) throws RepositoryException {
        super.checkModify(node, options, permissions);
    }

    protected VersioningLock.WriteLock acquireWriteLock() {
        return super.acquireWriteLock();
    }

    protected VersioningLock.ReadLock acquireReadLock() {
        return super.acquireReadLock();
    }

    public void addPredecessor(String absPath, Version version) throws RepositoryException {
        NodeStateEx state = this.getNodeState((NodeImpl)this.session.getNode(absPath), 194, 256);
        if (!this.checkVersionable(state)) {
            throw new UnsupportedRepositoryOperationException("Node not full versionable: " + this.safeGetJCRPath(state));
        }
        NodeId versionId = ((VersionImpl)version).getNodeId();
        try (VersionManagerImplBase.WriteOperation ops = this.startWriteOperation();){
            InternalValue[] vals = state.getPropertyValues(NameConstants.JCR_PREDECESSORS);
            InternalValue[] v = new InternalValue[vals.length + 1];
            for (int i = 0; i < vals.length; ++i) {
                v[i] = InternalValue.create((NodeId)vals[i].getNodeId());
            }
            v[vals.length] = InternalValue.create((NodeId)versionId);
            state.setPropertyValues(NameConstants.JCR_PREDECESSORS, 9, v, true);
            state.store(false);
            ops.save();
        }
    }

    private NodeStateEx getNodeState(NodeImpl node, int options, int permissions) throws RepositoryException {
        try {
            if (options > 0 || permissions > 0) {
                this.context.getItemValidator().checkModify((ItemImpl)node, options, permissions);
            }
            return new NodeStateEx(this.stateMgr, this.ntReg, (NodeState)this.stateMgr.getItemState((ItemId)node.getNodeId()), node.getQName());
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

