/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.NodeTypeInstanceHandler;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaNodeTypeInstanceHandler
extends NodeTypeInstanceHandler {
    private static final Logger logger = LoggerFactory.getLogger(JahiaNodeTypeInstanceHandler.class);
    private Calendar created = null;
    private Calendar lastModified = null;
    private String createdBy = null;
    private String lastModifiedBy = null;
    private final String userId;

    public JahiaNodeTypeInstanceHandler(String userId) {
        super(userId);
        if (userId.startsWith(" system ")) {
            userId = userId.substring(" system ".length());
        }
        this.userId = StringUtils.isEmpty((String)userId) ? "system" : userId;
    }

    public void setCreated(Calendar created) {
        this.created = created;
    }

    public void setLastModified(Calendar lastModified) {
        this.lastModified = lastModified;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public InternalValue[] computeSystemGeneratedPropertyValues(NodeState parent, QPropertyDefinition def) {
        InternalValue[] genValues = null;
        Name name = def.getName();
        Name declaringNT = def.getDeclaringNodeType();
        if (NameConstants.JCR_CREATED.equals(name)) {
            if (NameConstants.MIX_CREATED.equals(declaringNT) || NameConstants.NT_VERSION.equals(declaringNT)) {
                genValues = new InternalValue[]{InternalValue.create((Calendar)(this.created != null ? this.created : GregorianCalendar.getInstance()))};
            }
        } else if (NameConstants.JCR_CREATEDBY.equals(name)) {
            if (NameConstants.MIX_CREATED.equals(declaringNT)) {
                genValues = new InternalValue[]{InternalValue.create((String)(this.createdBy != null ? this.createdBy : this.userId))};
            }
        } else if (NameConstants.JCR_LASTMODIFIED.equals(name)) {
            if (NameConstants.MIX_LASTMODIFIED.equals(declaringNT)) {
                genValues = new InternalValue[]{InternalValue.create((Calendar)(this.lastModified != null ? this.lastModified : GregorianCalendar.getInstance()))};
            }
        } else if (NameConstants.JCR_LASTMODIFIEDBY.equals(name)) {
            if (NameConstants.MIX_LASTMODIFIED.equals(declaringNT)) {
                genValues = new InternalValue[]{InternalValue.create((String)(this.lastModifiedBy != null ? this.lastModifiedBy : this.userId))};
            }
        } else {
            genValues = super.computeSystemGeneratedPropertyValues(parent, def);
        }
        return genValues;
    }

    public void setDefaultValues(PropertyState property, NodeState parent, QPropertyDefinition def) throws RepositoryException {
        InternalValue[] values = this.computeSystemGeneratedPropertyValues(parent, def);
        QValue[] defaultValues = null;
        if (values == null && (defaultValues = def.getDefaultValues()) != null && defaultValues.length > 0) {
            Name name = def.getName();
            NodeTypeRegistry ntRegistry = NodeTypeRegistry.getInstance();
            String propName = name.getNamespaceURI().length() > 0 ? new org.jahia.services.content.nodetypes.Name(name.toString(), ntRegistry.getNamespaces()).toString() : name.getLocalName();
            Name declaringNT = def.getDeclaringNodeType();
            String nodeTypeName = declaringNT.getNamespaceURI().length() > 0 ? new org.jahia.services.content.nodetypes.Name(declaringNT.toString(), ntRegistry.getNamespaces()).toString() : declaringNT.getLocalName();
            ExtendedNodeType nodeType = ntRegistry.getNodeType(nodeTypeName);
            ExtendedPropertyDefinition propertyDefinition = nodeType.getPropertyDefinition(propName);
            if (propertyDefinition != null && propertyDefinition.hasDynamicDefaultValues()) {
                Value[] expandedDefValues = propertyDefinition.getDefaultValues();
                values = new InternalValue[expandedDefValues.length];
                int i = 0;
                for (Value v : expandedDefValues) {
                    values[i] = InternalValue.create((Value)v, null);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Dynamic values for property {}: {}", (Object)name, (Object)values[0].getString());
                }
            } else {
                values = InternalValue.create((QValue[])def.getDefaultValues());
            }
        }
        if (values != null) {
            property.setValues(values);
        }
    }
}

