/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.jcr.query.qom.And;
import javax.jcr.query.qom.ChildNode;
import javax.jcr.query.qom.Column;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DescendantNode;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.Join;
import javax.jcr.query.qom.Not;
import javax.jcr.query.qom.Or;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.Selector;
import javax.jcr.query.qom.Source;
import javax.jcr.query.qom.StaticOperand;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.commons.iterator.NodeIteratorAdapter;
import org.apache.jackrabbit.commons.query.sql2.Parser;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.query.qom.QueryObjectModelFactoryImpl;
import org.apache.jackrabbit.spi.commons.query.qom.QueryObjectModelTree;
import org.jahia.modules.external.ExternalContentStoreProvider;
import org.jahia.modules.external.ExternalDataSource;
import org.jahia.modules.external.ExternalQuery;
import org.jahia.modules.external.ExternalSessionImpl;
import org.jahia.modules.external.ExternalWorkspaceImpl;
import org.jahia.modules.external.query.ExternalQueryResult;
import org.jahia.modules.external.query.QueryHelper;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalQueryManager
implements QueryManager {
    private static final String[] SUPPORTED_LANGUAGES = new String[]{"JCR-SQL2"};
    private static Logger logger = LoggerFactory.getLogger(ExternalQueryManager.class);
    private ExternalWorkspaceImpl workspace;

    public ExternalQueryManager(ExternalWorkspaceImpl workspace) {
        this.workspace = workspace;
    }

    public Query createQuery(String statement, String language) throws InvalidQueryException, RepositoryException {
        if (!language.equals("JCR-SQL2")) {
            throw new InvalidQueryException("Unsupported query language");
        }
        Parser p = new Parser(this.getQOMFactory(), (ValueFactory)this.workspace.getSession().getValueFactory());
        return p.createQueryObjectModel(statement);
    }

    public QueryObjectModelFactory getQOMFactory() {
        return new ExternalQOMFactory((NamePathResolver)this.workspace.getSession().getRepository().getNamePathResolver());
    }

    public Query getQuery(Node node) throws InvalidQueryException, RepositoryException {
        return null;
    }

    public String[] getSupportedQueryLanguages() throws RepositoryException {
        return Arrays.copyOf(SUPPORTED_LANGUAGES, SUPPORTED_LANGUAGES.length);
    }

    class ExecutableExternalQuery
    extends ExternalQuery {
        private boolean nodeTypeSupported;
        private boolean hasExtension;

        ExecutableExternalQuery(Source source, Constraint constraints, Ordering[] orderings, Column[] columns, boolean nodeTypeSupported, boolean hasExtension) {
            super(source, constraints, orderings, columns);
            this.nodeTypeSupported = nodeTypeSupported;
            this.hasExtension = hasExtension;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public QueryResult execute() throws InvalidQueryException, RepositoryException {
            void var2_13;
            void var2_11;
            block36: {
                void var2_9;
                ArrayList<String> allExtendedResults = new ArrayList<String>();
                Object var2_2 = null;
                ExternalSessionImpl session = ExternalQueryManager.this.workspace.getSession();
                boolean noConstraints = false;
                try {
                    if (QueryHelper.getSimpleAndConstraints(this.getConstraint()).size() == 0) {
                        noConstraints = true;
                    }
                }
                catch (UnsupportedRepositoryOperationException e) {
                    // empty catch block
                }
                if (this.hasExtension) {
                    Node node;
                    NodeIterator nodes;
                    Session extSession = session.getExtensionSession();
                    QueryManager queryManager = extSession.getWorkspace().getQueryManager();
                    QueryObjectModelFactory qomFactory = queryManager.getQOMFactory();
                    Source source = this.getSource();
                    boolean isMixinOrFacet = false;
                    boolean isCount = false;
                    String selectorType = null;
                    String selectorName = null;
                    if (source instanceof Selector) {
                        selectorType = ((Selector)source).getNodeTypeName();
                        selectorName = ((Selector)source).getSelectorName();
                        isMixinOrFacet = NodeTypeRegistry.getInstance().getNodeType(selectorType).isMixin();
                        for (Column c : this.getColumns()) {
                            String columnName = c.getColumnName();
                            if (StringUtils.startsWith((String)columnName, (String)"rep:facet(")) {
                                isMixinOrFacet = true;
                                break;
                            }
                            if (!StringUtils.startsWith((String)columnName, (String)"rep:count(")) continue;
                            isCount = true;
                            break;
                        }
                        String selector = isMixinOrFacet ? selectorType : "jmix:externalProviderExtension";
                        source = qomFactory.selector(selector, selectorName);
                    }
                    ExternalContentStoreProvider storeProvider = session.getRepository().getStoreProvider();
                    String mountPoint = storeProvider.getMountPoint();
                    Constraint convertedConstraint = this.convertExistingPathConstraints(this.getConstraint(), mountPoint, qomFactory);
                    if (!this.hasDescendantNode(convertedConstraint)) {
                        convertedConstraint = this.addPathConstraints(convertedConstraint, source, mountPoint, qomFactory);
                    }
                    if (!isMixinOrFacet && selectorName != null && selectorType != null) {
                        Column c;
                        c = qomFactory.comparison((DynamicOperand)qomFactory.propertyValue(selectorName, "j:extendedType"), "jcr.operator.equal.to", (StaticOperand)qomFactory.literal(extSession.getValueFactory().createValue(selectorType)));
                        convertedConstraint = qomFactory.and((Constraint)c, convertedConstraint);
                    }
                    QueryObjectModel q = qomFactory.createQuery(source, convertedConstraint, this.getOrderings(), this.getColumns());
                    if (!this.nodeTypeSupported) {
                        if (this.getLimit() > -1L) {
                            q.setLimit(this.getLimit());
                        }
                        q.setOffset(this.getOffset());
                        QueryResult result = q.execute();
                        if (isCount) return result;
                        nodes = new QueryResultAdapter(result).getNodes();
                        while (nodes.hasNext()) {
                            node = (Node)nodes.next();
                            allExtendedResults.add(node.getPath().substring(mountPoint.length()));
                        }
                        ArrayList<String> arrayList = allExtendedResults;
                    } else {
                        QueryResult queryResult = q.execute();
                        if (isCount) return queryResult;
                        nodes = new QueryResultAdapter(queryResult).getNodes();
                        while (nodes.hasNext()) {
                            node = (Node)nodes.next();
                            String path = node.getPath().substring(mountPoint.length());
                            if (node.isNodeType("jnt:externalProviderExtension") && (noConstraints || !session.itemExists(path))) continue;
                            allExtendedResults.add(path);
                            if (this.getLimit() <= -1L || (long)allExtendedResults.size() <= this.getOffset() + this.getLimit()) continue;
                            break;
                        }
                        if (allExtendedResults.size() == 0) {
                            Object var2_4 = null;
                        } else if (this.getOffset() >= (long)allExtendedResults.size()) {
                            ArrayList arrayList = new ArrayList();
                        } else if (this.getLimit() > -1L) {
                            List list = allExtendedResults.subList((int)this.getOffset(), Math.min((int)this.getLimit(), allExtendedResults.size()));
                        } else if (this.getOffset() > 0L) {
                            List list = allExtendedResults.subList((int)this.getOffset(), allExtendedResults.size());
                        } else {
                            ArrayList<String> arrayList = allExtendedResults;
                        }
                    }
                }
                if (this.nodeTypeSupported && (this.getLimit() == -1L || var2_9 == null || (long)var2_9.size() < this.getLimit())) {
                    ExternalContentStoreProvider.setCurrentSession(session);
                    try {
                        ExternalDataSource dataSource = session.getRepository().getDataSource();
                        long originalLimit = this.getLimit();
                        if (var2_9 == null) {
                            List<String> list = ((ExternalDataSource.Searchable)((Object)dataSource)).search(this);
                            break block36;
                        }
                        if (noConstraints) {
                            if (this.getOffset() >= (long)allExtendedResults.size()) {
                                this.setOffset(this.getOffset() - (long)allExtendedResults.size());
                            } else {
                                this.setOffset(0L);
                                if (this.getLimit() != -1L) {
                                    this.setLimit(this.getLimit() - (long)var2_9.size());
                                }
                            }
                            var2_9.addAll(((ExternalDataSource.Searchable)((Object)dataSource)).search(this));
                            break block36;
                        }
                        if (originalLimit > -1L) {
                            this.setLimit(this.getOffset() + this.getLimit());
                        }
                        int skips = Math.max(0, (int)this.getOffset() - allExtendedResults.size());
                        this.setOffset(0L);
                        List<String> providerResult = ((ExternalDataSource.Searchable)((Object)dataSource)).search(this);
                        for (String s : providerResult) {
                            if (allExtendedResults.contains(s)) continue;
                            if (skips > 0) {
                                --skips;
                                continue;
                            }
                            var2_9.add(s);
                            if (originalLimit <= -1L || (long)var2_9.size() < originalLimit) continue;
                            break;
                        }
                    }
                    catch (UnsupportedRepositoryOperationException e) {
                        logger.debug("Unsupported query ", (Throwable)e);
                    }
                    finally {
                        ExternalContentStoreProvider.removeCurrentSession();
                    }
                }
            }
            if (var2_11 != null) return new ExternalQueryResult(this, (List<String>)var2_13, ExternalQueryManager.this.workspace);
            ArrayList arrayList = new ArrayList();
            return new ExternalQueryResult(this, (List<String>)var2_13, ExternalQueryManager.this.workspace);
        }

        private boolean hasDescendantNode(Constraint convertedConstraint) {
            if (convertedConstraint instanceof DescendantNode) {
                return true;
            }
            if (convertedConstraint instanceof And) {
                return this.hasDescendantNode(((And)convertedConstraint).getConstraint1()) || this.hasDescendantNode(((And)convertedConstraint).getConstraint2());
            }
            return false;
        }

        private Constraint addPathConstraints(Constraint constraint, Source source, String mountPoint, QueryObjectModelFactory f) throws RepositoryException {
            Object result = constraint;
            if (source instanceof Selector) {
                DescendantNode descendantNode = f.descendantNode(((Selector)source).getSelectorName(), mountPoint);
                result = result == null ? descendantNode : f.and(result, (Constraint)descendantNode);
            } else if (source instanceof Join) {
                result = this.addPathConstraints((Constraint)result, ((Join)source).getLeft(), mountPoint, f);
                result = this.addPathConstraints((Constraint)result, ((Join)source).getRight(), mountPoint, f);
            }
            return result;
        }

        private Constraint convertExistingPathConstraints(Constraint constraint, String mountPoint, QueryObjectModelFactory f) throws RepositoryException {
            if (constraint instanceof ChildNode) {
                String root = ((ChildNode)constraint).getParentPath();
                return f.childNode(((ChildNode)constraint).getSelectorName(), mountPoint + root);
            }
            if (constraint instanceof DescendantNode) {
                String root = ((DescendantNode)constraint).getAncestorPath();
                return f.descendantNode(((DescendantNode)constraint).getSelectorName(), mountPoint + root);
            }
            if (constraint instanceof And) {
                Constraint c1 = this.convertExistingPathConstraints(((And)constraint).getConstraint1(), mountPoint, f);
                Constraint c2 = this.convertExistingPathConstraints(((And)constraint).getConstraint2(), mountPoint, f);
                return f.and(c1, c2);
            }
            if (constraint instanceof Or) {
                Constraint c1 = this.convertExistingPathConstraints(((Or)constraint).getConstraint1(), mountPoint, f);
                Constraint c2 = this.convertExistingPathConstraints(((Or)constraint).getConstraint2(), mountPoint, f);
                return f.or(c1, c2);
            }
            if (constraint instanceof Not) {
                return f.not(this.convertExistingPathConstraints(((Not)constraint).getConstraint(), mountPoint, f));
            }
            return constraint;
        }

        private class QueryResultAdapter
        implements QueryResult {
            private final QueryResult result;

            public QueryResultAdapter(QueryResult result) {
                this.result = result;
            }

            public String[] getColumnNames() throws RepositoryException {
                return this.result.getColumnNames();
            }

            public RowIterator getRows() throws RepositoryException {
                return this.result.getRows();
            }

            public NodeIterator getNodes() throws RepositoryException {
                if (this.result.getSelectorNames().length <= 1) {
                    return this.result.getNodes();
                }
                return new NodeIteratorAdapter((RangeIterator)this.result.getRows()){

                    public Object next() {
                        Row row = (Row)super.next();
                        try {
                            return row.getNode(QueryResultAdapter.this.result.getSelectorNames()[0]);
                        }
                        catch (RepositoryException e) {
                            throw new UnsupportedOperationException("Unable to access the node in " + row, e);
                        }
                    }
                };
            }

            public String[] getSelectorNames() throws RepositoryException {
                return this.result.getSelectorNames();
            }
        }
    }

    class ExternalQOMFactory
    extends QueryObjectModelFactoryImpl
    implements QueryObjectModelFactory {
        ExternalQOMFactory(NamePathResolver resolver) {
            super(resolver);
        }

        protected QueryObjectModel createQuery(QueryObjectModelTree qomTree) throws InvalidQueryException, RepositoryException {
            boolean hasExtension;
            boolean nodeTypeSupported = this.isNodeTypeSupported(qomTree);
            boolean bl = hasExtension = ExternalQueryManager.this.workspace.getSession().getExtensionSession() != null;
            if (!nodeTypeSupported && !hasExtension) {
                return null;
            }
            return new ExecutableExternalQuery((Source)qomTree.getSource(), (Constraint)qomTree.getConstraint(), (Ordering[])qomTree.getOrderings(), (Column[])qomTree.getColumns(), nodeTypeSupported, hasExtension);
        }

        private boolean isNodeTypeSupported(QueryObjectModelTree qomTree) throws NoSuchNodeTypeException {
            if (!(qomTree.getSource() instanceof Selector)) {
                return false;
            }
            NodeTypeRegistry ntRegistry = NodeTypeRegistry.getInstance();
            ExtendedNodeType type = null;
            try {
                type = ntRegistry.getNodeType(((Selector)qomTree.getSource()).getNodeTypeName());
            }
            catch (NoSuchNodeTypeException e) {
                return false;
            }
            String nodeType = type.getName();
            Set<String> supportedNodeTypes = ExternalQueryManager.this.workspace.getSession().getRepository().getDataSource().getSupportedNodeTypes();
            if (supportedNodeTypes.contains(nodeType)) {
                return true;
            }
            for (String supportedNodeType : supportedNodeTypes) {
                try {
                    if (!ntRegistry.getNodeType(supportedNodeType).isNodeType(nodeType)) continue;
                    return true;
                }
                catch (NoSuchNodeTypeException e) {
                    logger.error("no such node type", (Throwable)e);
                }
            }
            return false;
        }
    }
}

