/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.Calendar;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.util.ISO8601;
import org.jahia.modules.external.ExternalBinaryImpl;

public class ExternalValueImpl
implements Value {
    private Object value;
    private int type;

    public ExternalValueImpl(String value) {
        this(value, 1);
    }

    public ExternalValueImpl(Binary value) {
        this(value, 2);
    }

    public ExternalValueImpl(long value) {
        this(value, 3);
    }

    public ExternalValueImpl(double value) {
        this(value, 4);
    }

    public ExternalValueImpl(BigDecimal value) {
        this(value, 12);
    }

    public ExternalValueImpl(Calendar value) {
        this(value, 5);
    }

    public ExternalValueImpl(boolean value) {
        this(value, 6);
    }

    public ExternalValueImpl(Node value, boolean weakReference) throws RepositoryException {
        if (weakReference) {
            this.value = value.getIdentifier();
            this.type = 10;
        } else {
            this.value = value.getIdentifier();
            this.type = 9;
        }
    }

    public ExternalValueImpl(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    public String getString() throws ValueFormatException, IllegalStateException, RepositoryException {
        if (this.value instanceof Calendar) {
            return ISO8601.format((Calendar)((Calendar)this.value));
        }
        return this.value.toString();
    }

    public InputStream getStream() throws RepositoryException {
        if (this.value instanceof Binary) {
            return ((Binary)this.value).getStream();
        }
        throw new ValueFormatException();
    }

    public Binary getBinary() throws RepositoryException {
        if (this.value instanceof Binary) {
            return (Binary)this.value;
        }
        return new ExternalBinaryImpl(new ByteArrayInputStream(this.getString().getBytes(Charset.forName("UTF-8"))));
    }

    public long getLong() throws ValueFormatException, RepositoryException {
        if (this.value instanceof Long) {
            return (Long)this.value;
        }
        try {
            return Long.parseLong(this.getString());
        }
        catch (NumberFormatException e) {
            throw new ValueFormatException((Throwable)e);
        }
    }

    public double getDouble() throws ValueFormatException, RepositoryException {
        if (this.value instanceof Double) {
            return (Double)this.value;
        }
        try {
            return Double.parseDouble(this.getString());
        }
        catch (NumberFormatException e) {
            throw new ValueFormatException((Throwable)e);
        }
    }

    public BigDecimal getDecimal() throws ValueFormatException, RepositoryException {
        if (this.value instanceof BigDecimal) {
            return (BigDecimal)this.value;
        }
        return BigDecimal.valueOf(this.getDouble());
    }

    public Calendar getDate() throws ValueFormatException, RepositoryException {
        if (this.value instanceof Calendar) {
            return (Calendar)this.value;
        }
        try {
            return ISO8601.parse((String)this.getString());
        }
        catch (RuntimeException e) {
            throw new ValueFormatException((Throwable)e);
        }
    }

    public boolean getBoolean() throws ValueFormatException, RepositoryException {
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        return Boolean.valueOf(this.getString());
    }

    public int getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (obj != null && this.getClass() == obj.getClass()) {
            return this.value.equals(((ExternalValueImpl)obj).value);
        }
        return obj != null && obj instanceof Value && obj.equals(this.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

