/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Binary;
import javax.jcr.Credentials;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Workspace;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.retention.RetentionManager;
import javax.jcr.security.AccessControlManager;
import javax.jcr.version.VersionException;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.security.JahiaLoginModule;
import org.jahia.modules.external.ExtensionNode;
import org.jahia.modules.external.ExtensionProperty;
import org.jahia.modules.external.ExternalAccessControlManager;
import org.jahia.modules.external.ExternalContentStoreProvider;
import org.jahia.modules.external.ExternalData;
import org.jahia.modules.external.ExternalDataSource;
import org.jahia.modules.external.ExternalItemImpl;
import org.jahia.modules.external.ExternalNodeImpl;
import org.jahia.modules.external.ExternalRepositoryImpl;
import org.jahia.modules.external.ExternalValueFactoryImpl;
import org.jahia.modules.external.ExternalWorkspaceImpl;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRStoreProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ExternalSessionImpl
implements Session {
    static final String TRANSLATION_PREFIX = "translation:";
    static final String TRANSLATION_NODE_NAME_BASE = "j:translation_";
    private static final Logger logger = LoggerFactory.getLogger(ExternalSessionImpl.class);
    private ExternalRepositoryImpl repository;
    private ExternalWorkspaceImpl workspace;
    private Credentials credentials;
    private Map<String, ExternalNodeImpl> nodesByPath = new HashMap<String, ExternalNodeImpl>();
    private Map<String, ExternalNodeImpl> nodesByIdentifier = new HashMap<String, ExternalNodeImpl>();
    private Set<ExternalItemImpl> newItems = new HashSet<ExternalItemImpl>();
    private Map<String, ExternalData> changedData = new LinkedHashMap<String, ExternalData>();
    private Map<String, ExternalData> deletedData = new LinkedHashMap<String, ExternalData>();
    private Map<String, List<String>> orderedData = new LinkedHashMap<String, List<String>>();
    private Set<Binary> tempBinaries = new HashSet<Binary>();
    private Session extensionSession;
    private List<String> extensionAllowedTypes;
    private List<String> extensionForbiddenMixins;
    private Map<String, List<String>> overridableProperties;
    private Map<String, List<String>> nonOverridableProperties;
    private Map<String, Object> sessionVariables = new HashMap<String, Object>();
    private ExternalAccessControlManager accessControlManager;
    private static volatile int fromCacheCount = 0;
    private static volatile int totalCacheChecks = 0;
    private static volatile int totalSavedCalls = 0;
    private static final boolean DEBUG = false;

    public ExternalSessionImpl(ExternalRepositoryImpl repository, Credentials credentials, String workspaceName) {
        this.repository = repository;
        this.workspace = new ExternalWorkspaceImpl(this, workspaceName);
        this.credentials = credentials;
    }

    public ExternalRepositoryImpl getRepository() {
        return this.repository;
    }

    public String getUserID() {
        return ((SimpleCredentials)this.credentials).getUserID();
    }

    public String getRealm() {
        return (String)((SimpleCredentials)this.credentials).getAttribute("org.jahia.realm");
    }

    public Object getAttribute(String s) {
        return null;
    }

    public String[] getAttributeNames() {
        return new String[0];
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public Session impersonate(Credentials credentials) throws LoginException, RepositoryException {
        return this;
    }

    private ExternalNodeImpl getFromCacheByPath(String path) {
        return ExternalSessionImpl.getFromCache(path, this.nodesByPath);
    }

    private ExternalNodeImpl getFromCacheById(String id) {
        return ExternalSessionImpl.getFromCache(id, this.nodesByIdentifier);
    }

    private static ExternalNodeImpl getFromCache(String key, Map<String, ExternalNodeImpl> cache) {
        ++totalCacheChecks;
        if (cache.isEmpty()) {
            totalSavedCalls += fromCacheCount;
            fromCacheCount = 0;
            totalCacheChecks = 0;
            return null;
        }
        ExternalNodeImpl node = cache.get(key);
        if (node != null) {
            ++fromCacheCount;
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getRootNode() throws RepositoryException {
        ExternalNodeImpl fromCache = this.getFromCacheByPath("/");
        if (fromCache != null) {
            return fromCache;
        }
        ExternalContentStoreProvider.setCurrentSession(this);
        try {
            boolean available;
            if (this.repository.getDataSource() instanceof ExternalDataSource.CanCheckAvailability && !(available = ((ExternalDataSource.CanCheckAvailability)((Object)this.repository.getDataSource())).isAvailable())) {
                throw new RepositoryException("Provider '" + this.repository.getProviderKey() + "' is currently unavailable");
            }
            ExternalData rootFileObject = this.repository.getDataSource().getItemByPath("/");
            ExternalNodeImpl externalNode = new ExternalNodeImpl(rootFileObject, this);
            this.registerNode(externalNode);
            ExternalNodeImpl externalNodeImpl = externalNode;
            return externalNodeImpl;
        }
        finally {
            ExternalContentStoreProvider.removeCurrentSession();
        }
    }

    public Node getNodeByUUID(String uuid) throws ItemNotFoundException, RepositoryException {
        ExternalNodeImpl fromCacheById = this.getFromCacheById(uuid);
        if (fromCacheById != null) {
            return fromCacheById;
        }
        if (!this.repository.getDataSource().isSupportsUuid() || uuid.startsWith(TRANSLATION_PREFIX)) {
            if (!uuid.startsWith(this.getRepository().getStoreProvider().getId())) {
                throw new ItemNotFoundException("Item " + uuid + " could not be found in this repository");
            }
            String externalId = this.repository.getStoreProvider().getExternalProviderInitializerService().getExternalIdentifier(uuid);
            if (externalId == null) {
                throw new ItemNotFoundException("Item " + uuid + " could not be found in this repository");
            }
            uuid = externalId;
        }
        return this.getNodeByLocalIdentifier(uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node getNodeByLocalIdentifier(String uuid) throws RepositoryException {
        Node n;
        for (ExternalItemImpl i : this.newItems) {
            ExternalNodeImpl n2;
            if (!(i instanceof ExternalNodeImpl) || !uuid.equals((n2 = (ExternalNodeImpl)i).getIdentifier())) continue;
            return n2;
        }
        for (ExternalData d : this.changedData.values()) {
            if (!uuid.equals(d.getId())) continue;
            return new ExternalNodeImpl(d, this);
        }
        if (uuid.startsWith(TRANSLATION_PREFIX)) {
            String u = StringUtils.substringAfter((String)uuid, (String)TRANSLATION_PREFIX);
            String lang = StringUtils.substringBefore((String)u, (String)":");
            u = StringUtils.substringAfter((String)u, (String)":");
            return this.getNodeByLocalIdentifier(u).getNode(TRANSLATION_NODE_NAME_BASE + lang);
        }
        try {
            if (this.getExtensionSession() != null) {
                n = this.getExtensionSession().getNodeByIdentifier(uuid);
                return new ExtensionNode(n, StringUtils.substringAfter((String)n.getPath(), (String)this.repository.getStoreProvider().getMountPoint()), this);
            }
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        ExternalContentStoreProvider.setCurrentSession(this);
        try {
            n = new ExternalNodeImpl(this.repository.getDataSource().getItemByIdentifier(uuid), this);
            if (this.deletedData.containsKey(n.getPath())) {
                throw new ItemNotFoundException("This node has been deleted");
            }
            Node node = n;
            return node;
        }
        finally {
            ExternalContentStoreProvider.removeCurrentSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item getItem(String path) throws RepositoryException {
        ExternalNodeImpl i18nProps2;
        String string = path = path.length() > 1 && path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
        if (this.deletedData.containsKey(path)) {
            throw new PathNotFoundException("This node has been deleted");
        }
        ExternalNodeImpl fromCache = this.getFromCacheByPath(path);
        if (fromCache != null) {
            return fromCache;
        }
        String parentPath = StringUtils.substringBeforeLast((String)path, (String)"/");
        if (parentPath.equals("")) {
            parentPath = "/";
        }
        if (StringUtils.substringAfterLast((String)parentPath, (String)"/").startsWith(TRANSLATION_NODE_NAME_BASE)) {
            return this.getNode(parentPath).getProperty(StringUtils.substringAfterLast((String)path, (String)"/"));
        }
        if (StringUtils.substringAfterLast((String)path, (String)"/").startsWith(TRANSLATION_NODE_NAME_BASE)) {
            ExternalData parentObject;
            String lang = StringUtils.substringAfterLast((String)path, (String)TRANSLATION_NODE_NAME_BASE);
            ExternalNodeImpl parentFromCache = this.getFromCacheByPath(parentPath);
            if (parentFromCache != null) {
                parentObject = parentFromCache.getData();
            } else {
                ExternalContentStoreProvider.setCurrentSession(this);
                try {
                    parentObject = this.repository.getDataSource().getItemByPath(parentPath);
                    ExternalNodeImpl node = new ExternalNodeImpl(parentObject, this);
                    this.registerNode(node);
                }
                finally {
                    ExternalContentStoreProvider.removeCurrentSession();
                }
            }
            if (!(parentObject.getI18nProperties() != null && parentObject.getI18nProperties().containsKey(lang) || parentObject.getLazyI18nProperties() != null && parentObject.getLazyI18nProperties().containsKey(lang))) {
                throw new PathNotFoundException(path);
            }
            HashMap<String, String[]> i18nProps2 = new HashMap<String, String[]>();
            if (parentObject.getI18nProperties() != null && parentObject.getI18nProperties().containsKey(lang)) {
                i18nProps2.putAll(parentObject.getI18nProperties().get(lang));
            }
            i18nProps2.put("jcr:language", new String[]{lang});
            ExternalData i18n = new ExternalData(TRANSLATION_PREFIX + lang + ":" + parentObject.getId(), path, "jnt:translation", i18nProps2);
            if (parentObject.getLazyI18nProperties() != null && parentObject.getLazyI18nProperties().containsKey(lang)) {
                i18n.setLazyProperties(parentObject.getLazyI18nProperties().get(lang));
            }
            ExternalNodeImpl node = new ExternalNodeImpl(i18n, this);
            this.registerNode(node);
            return node;
        }
        String itemName = StringUtils.substringAfterLast((String)path, (String)"/");
        if (this.getRepository().getStoreProvider().getReservedNodes().contains(itemName)) {
            throw new PathNotFoundException(path);
        }
        ExternalContentStoreProvider.setCurrentSession(this);
        try {
            ExternalData data = this.repository.getDataSource().getItemByPath(path);
            ExternalNodeImpl node = new ExternalNodeImpl(data, this);
            this.registerNode(node);
            i18nProps2 = node;
        }
        catch (PathNotFoundException e) {
            Property property;
            try {
                ExternalNodeImpl parentFromPath = this.getFromCacheByPath(parentPath);
                if (parentFromPath == null) {
                    ExternalData data = this.repository.getDataSource().getItemByPath(parentPath);
                    ExternalNodeImpl node = new ExternalNodeImpl(data, this);
                    this.registerNode(node);
                    parentFromPath = node;
                }
                property = parentFromPath.getProperty(itemName);
            }
            catch (Throwable throwable) {
                try {
                    ExternalContentStoreProvider.removeCurrentSession();
                    throw throwable;
                }
                catch (PathNotFoundException e2) {
                    if (this.getExtensionSession() != null && !StringUtils.equals((String)"/", (String)path)) {
                        Item item = this.getExtensionSession().getItem(this.repository.getStoreProvider().getMountPoint() + path);
                        if ((item.isNode() ? (Node)item : item.getParent()).isNodeType("jnt:externalProviderExtension")) {
                            throw e2;
                        }
                        return item.isNode() ? new ExtensionNode((Node)item, path, this) : new ExtensionProperty((Property)item, path, this, new ExtensionNode(item.getParent(), parentPath, this));
                    }
                    throw e2;
                }
            }
            ExternalContentStoreProvider.removeCurrentSession();
            return property;
        }
        ExternalContentStoreProvider.removeCurrentSession();
        return i18nProps2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getPropertyValues(ExternalData data, String propertyName) throws PathNotFoundException {
        ExternalDataSource dataSource = this.repository.getDataSource();
        if (dataSource instanceof ExternalDataSource.LazyProperty) {
            ExternalContentStoreProvider.setCurrentSession(this);
            try {
                String[] stringArray = ((ExternalDataSource.LazyProperty)((Object)dataSource)).getPropertyValues(data.getPath(), propertyName);
                return stringArray;
            }
            finally {
                ExternalContentStoreProvider.removeCurrentSession();
            }
        }
        throw new PathNotFoundException(this.repository.getProviderKey() + " doesn't support lazy properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getI18nPropertyValues(ExternalData data, String lang, String propertyName) throws PathNotFoundException {
        ExternalDataSource dataSource = this.repository.getDataSource();
        if (dataSource instanceof ExternalDataSource.LazyProperty) {
            ExternalContentStoreProvider.setCurrentSession(this);
            try {
                String[] stringArray = ((ExternalDataSource.LazyProperty)((Object)dataSource)).getI18nPropertyValues(StringUtils.substringBeforeLast((String)data.getPath(), (String)"/"), lang, propertyName);
                return stringArray;
            }
            finally {
                ExternalContentStoreProvider.removeCurrentSession();
            }
        }
        throw new PathNotFoundException(this.repository.getProviderKey() + " doesn't support lazy properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Binary[] getBinaryPropertyValues(ExternalData data, String propertyName) throws PathNotFoundException {
        ExternalDataSource dataSource = this.repository.getDataSource();
        if (dataSource instanceof ExternalDataSource.LazyProperty) {
            ExternalContentStoreProvider.setCurrentSession(this);
            try {
                Binary[] binaryArray = ((ExternalDataSource.LazyProperty)((Object)dataSource)).getBinaryPropertyValues(data.getPath(), propertyName);
                return binaryArray;
            }
            finally {
                ExternalContentStoreProvider.removeCurrentSession();
            }
        }
        throw new PathNotFoundException(this.repository.getProviderKey() + " doesn't support lazy properties");
    }

    public boolean itemExists(String path) throws RepositoryException {
        try {
            this.getItem(path);
        }
        catch (PathNotFoundException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(String source, String dest) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        Item sourceNode = this.getItem(source);
        if (!sourceNode.isNode()) {
            throw new PathNotFoundException(source);
        }
        if (sourceNode instanceof ExtensionNode) {
            ExternalNodeImpl externalNode;
            Node extendedNode;
            String targetName = StringUtils.substringAfterLast((String)dest, (String)"/");
            String parentPath = StringUtils.substringBeforeLast((String)dest, (String)"/");
            Node targetNode = (Node)this.getItem(parentPath);
            String srcAbsPath = ((ExtensionNode)sourceNode).getJcrNode().getPath();
            Node jcrNode = null;
            if (targetNode instanceof ExtensionNode) {
                jcrNode = ((ExtensionNode)targetNode).getJcrNode();
            } else if (targetNode instanceof ExternalNodeImpl && (extendedNode = (externalNode = (ExternalNodeImpl)targetNode).getExtensionNode(true)) != null && externalNode.canItemBeExtended(targetName, ((ExtensionNode)sourceNode).getPrimaryNodeType().getName())) {
                jcrNode = extendedNode;
            }
            if (jcrNode != null) {
                this.getExtensionSession().move(srcAbsPath, jcrNode.getPath() + "/" + targetName);
                return;
            }
        } else if (sourceNode instanceof ExternalNodeImpl) {
            if (!(this.repository.getDataSource() instanceof ExternalDataSource.Writable)) {
                throw new UnsupportedRepositoryOperationException();
            }
            if (source.equals(dest)) {
                return;
            }
            ExternalNodeImpl externalNode = (ExternalNodeImpl)sourceNode;
            ExternalNodeImpl previousParent = (ExternalNodeImpl)externalNode.getParent();
            List<String> previousParentChildren = previousParent.getExternalChildren();
            try {
                String newDest = JCRContentUtils.findAvailableNodeName((Node)externalNode, (String)dest);
                ExternalContentStoreProvider.setCurrentSession(this);
                ((ExternalDataSource.Writable)((Object)this.repository.getDataSource())).move(source, newDest);
                int oldIndex = previousParentChildren.indexOf(externalNode.getName());
                previousParentChildren.remove(externalNode.getName());
                this.unregisterNode(externalNode);
                ExternalData newData = this.repository.getDataSource().getItemByPath(dest);
                ExternalNodeImpl newExternalNode = new ExternalNodeImpl(newData, this);
                this.registerNode(newExternalNode);
                ExternalNodeImpl newParent = (ExternalNodeImpl)newExternalNode.getParent();
                if (newParent.equals(previousParent)) {
                    previousParentChildren.add(oldIndex, newExternalNode.getName());
                } else if (!newParent.getExternalChildren().contains(newExternalNode.getName())) {
                    newParent.getExternalChildren().add(newExternalNode.getName());
                }
                ExternalData oldData = externalNode.getData();
                if (oldData.getId().equals(newData.getId())) {
                    return;
                }
                this.getRepository().getStoreProvider().getExternalProviderInitializerService().updateExternalIdentifier(oldData.getId(), newData.getId(), this.getRepository().getProviderKey(), this.getRepository().getDataSource().isSupportsHierarchicalIdentifiers());
                return;
            }
            finally {
                ExternalContentStoreProvider.removeCurrentSession();
            }
        }
        throw new UnsupportedRepositoryOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        if (this.extensionSession != null && this.extensionSession.hasPendingChanges()) {
            this.extensionSession.save();
        }
        if (!(this.repository.getDataSource() instanceof ExternalDataSource.Writable)) {
            this.deletedData.clear();
            this.changedData.clear();
            this.orderedData.clear();
            return;
        }
        ExternalContentStoreProvider.setCurrentSession(this);
        try {
            LinkedHashMap<String, ExternalData> changedDataWithI18n = new LinkedHashMap<String, ExternalData>();
            for (Map.Entry<String, ExternalData> entry : this.changedData.entrySet()) {
                String path = entry.getKey();
                ExternalData externalData = entry.getValue();
                if (path.startsWith(TRANSLATION_NODE_NAME_BASE, path.lastIndexOf("/") + 1)) {
                    String lang = StringUtils.substringAfterLast((String)path, (String)TRANSLATION_NODE_NAME_BASE);
                    String parentPath = StringUtils.substringBeforeLast((String)path, (String)"/");
                    ExternalData parentData = changedDataWithI18n.containsKey(parentPath) ? (ExternalData)changedDataWithI18n.get(parentPath) : this.repository.getDataSource().getItemByPath(parentPath);
                    Map<String, Map<String, String[]>> i18nProperties = parentData.getI18nProperties();
                    if (i18nProperties == null) {
                        i18nProperties = new HashMap<String, Map<String, String[]>>();
                        parentData.setI18nProperties(i18nProperties);
                    }
                    i18nProperties.put(lang, externalData.getProperties());
                    if (externalData.getLazyProperties() != null) {
                        Map<String, Set<String>> lazyI18nProperties = parentData.getLazyI18nProperties();
                        if (lazyI18nProperties == null) {
                            lazyI18nProperties = new HashMap<String, Set<String>>();
                            parentData.setLazyI18nProperties(lazyI18nProperties);
                        }
                        lazyI18nProperties.put(lang, externalData.getLazyProperties());
                    }
                    changedDataWithI18n.put(parentPath, parentData);
                    continue;
                }
                changedDataWithI18n.put(path, externalData);
            }
            ExternalDataSource.Writable writableDataSource = (ExternalDataSource.Writable)((Object)this.repository.getDataSource());
            for (String path : this.orderedData.keySet()) {
                writableDataSource.order(path, this.orderedData.get(path));
            }
            this.orderedData.clear();
            for (ExternalData data : changedDataWithI18n.values()) {
                ExternalNodeImpl cachedNode;
                writableDataSource.saveItem(data);
                if (data.getBinaryProperties() == null || data.getBinaryProperties().size() <= 0 || (cachedNode = this.nodesByPath.get(data.getPath())) == null) continue;
                this.nodesByPath.remove(data.getPath());
                this.nodesByIdentifier.remove(cachedNode.getIdentifier());
            }
            this.changedData.clear();
            if (!this.deletedData.isEmpty()) {
                LinkedList<String> toBeDeleted = new LinkedList<String>();
                for (String path : this.deletedData.keySet()) {
                    writableDataSource.removeItemByPath(path);
                    toBeDeleted.add(this.deletedData.get(path).getId());
                }
                this.getRepository().getStoreProvider().getExternalProviderInitializerService().delete(toBeDeleted, this.getRepository().getStoreProvider().getKey(), this.getRepository().getDataSource().isSupportsHierarchicalIdentifiers());
                this.deletedData.clear();
            }
            for (ExternalItemImpl newItem : this.newItems) {
                newItem.setNew(false);
            }
            this.newItems.clear();
        }
        finally {
            ExternalContentStoreProvider.removeCurrentSession();
        }
    }

    public void refresh(boolean keepChanges) throws RepositoryException {
        if (!keepChanges) {
            this.deletedData.clear();
            this.changedData.clear();
            this.orderedData.clear();
            this.newItems.clear();
            this.nodesByPath.clear();
            this.nodesByIdentifier.clear();
        } else {
            ArrayList<String> pathsToKeep = new ArrayList<String>();
            pathsToKeep.addAll(this.changedData.keySet());
            pathsToKeep.addAll(this.deletedData.keySet());
            pathsToKeep.addAll(this.orderedData.keySet());
            ArrayList<String> idsToKeep = new ArrayList<String>();
            for (String s : pathsToKeep) {
                ExternalNodeImpl node = this.getFromCacheByPath(s);
                if (node == null) continue;
                idsToKeep.add(node.getIdentifier());
            }
            this.nodesByPath.keySet().retainAll(pathsToKeep);
            this.nodesByIdentifier.keySet().retainAll(idsToKeep);
        }
    }

    public boolean hasPendingChanges() throws RepositoryException {
        return this.extensionSession != null && this.extensionSession.hasPendingChanges() || this.repository.getDataSource() instanceof ExternalDataSource.Writable && (!this.deletedData.isEmpty() || !this.changedData.isEmpty() || !this.orderedData.isEmpty());
    }

    public ExternalValueFactoryImpl getValueFactory() throws UnsupportedRepositoryOperationException, RepositoryException {
        return new ExternalValueFactoryImpl(this);
    }

    public void checkPermission(String s, String s1) throws AccessControlException, RepositoryException {
    }

    public ContentHandler getImportContentHandler(String s, int i) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, RepositoryException {
        return null;
    }

    public void importXML(String s, InputStream inputStream, int i) throws IOException, PathNotFoundException, ItemExistsException, ConstraintViolationException, VersionException, InvalidSerializedDataException, LockException, RepositoryException {
    }

    public void exportSystemView(String s, ContentHandler contentHandler, boolean b, boolean b1) throws PathNotFoundException, SAXException, RepositoryException {
    }

    public void exportSystemView(String s, OutputStream outputStream, boolean b, boolean b1) throws IOException, PathNotFoundException, RepositoryException {
    }

    public void exportDocumentView(String s, ContentHandler contentHandler, boolean b, boolean b1) throws PathNotFoundException, SAXException, RepositoryException {
    }

    public void exportDocumentView(String s, OutputStream outputStream, boolean b, boolean b1) throws IOException, PathNotFoundException, RepositoryException {
    }

    public void setNamespacePrefix(String s, String s1) throws NamespaceException, RepositoryException {
    }

    public String[] getNamespacePrefixes() throws RepositoryException {
        return this.workspace.getNamespaceRegistry().getPrefixes();
    }

    public String getNamespaceURI(String s) throws NamespaceException, RepositoryException {
        return this.workspace.getNamespaceRegistry().getURI(s);
    }

    public String getNamespacePrefix(String s) throws NamespaceException, RepositoryException {
        return this.workspace.getNamespaceRegistry().getPrefix(s);
    }

    public void logout() {
        if (this.extensionSession != null && this.extensionSession.isLive()) {
            this.extensionSession.logout();
            this.extensionSession = null;
        }
        for (Binary binary : this.tempBinaries) {
            binary.dispose();
        }
        this.accessControlManager = null;
    }

    public boolean isLive() {
        return true;
    }

    public void addLockToken(String s) {
        try {
            LockManager extensionLockManager = this.getExtensionSession().getWorkspace().getLockManager();
            if (extensionLockManager != null) {
                extensionLockManager.addLockToken(s);
            }
        }
        catch (RepositoryException e) {
            logger.error("Unable to add lock token " + s, (Object)e.getMessage());
        }
    }

    public String[] getLockTokens() {
        try {
            if (this.getExtensionSession() == null) {
                return new String[0];
            }
            return this.getExtensionSession().getWorkspace().getLockManager().getLockTokens();
        }
        catch (RepositoryException e) {
            return new String[0];
        }
    }

    public void removeLockToken(String s) {
        try {
            LockManager extensionLockManager = this.getExtensionSession().getWorkspace().getLockManager();
            if (extensionLockManager != null) {
                extensionLockManager.removeLockToken(s);
            }
        }
        catch (RepositoryException e) {
            logger.error("Unable to remove lock token " + s, (Object)e.getMessage());
        }
    }

    public Map<String, ExternalData> getChangedData() {
        return this.changedData;
    }

    public Map<String, ExternalData> getDeletedData() {
        return this.deletedData;
    }

    public Map<String, List<String>> getOrderedData() {
        return this.orderedData;
    }

    public void registerNode(ExternalNodeImpl node) throws RepositoryException {
        this.nodesByPath.put(node.getPath(), node);
        this.nodesByIdentifier.put(node.getIdentifier(), node);
    }

    public void unregisterNode(ExternalNodeImpl node) throws RepositoryException {
        this.nodesByPath.remove(node.getPath());
        this.nodesByIdentifier.remove(node.getIdentifier());
        this.changedData.remove(node.getPath());
        this.orderedData.remove(node.getPath());
        this.newItems.remove(node);
    }

    public void registerTemporaryBinary(Binary binary) throws RepositoryException {
        this.tempBinaries.add(binary);
    }

    public Set<ExternalItemImpl> getNewItems() {
        return this.newItems;
    }

    public void setNewItem(ExternalItemImpl newItem) throws RepositoryException {
        newItem.setNew(true);
        this.newItems.add(newItem);
    }

    public Node getNodeByIdentifier(String id) throws ItemNotFoundException, RepositoryException {
        return this.getNodeByUUID(id);
    }

    public Node getNode(String absPath) throws PathNotFoundException, RepositoryException {
        return (Node)this.getItem(absPath);
    }

    public Property getProperty(String absPath) throws PathNotFoundException, RepositoryException {
        return (Property)this.getItem(absPath);
    }

    public boolean nodeExists(String absPath) throws RepositoryException {
        return this.itemExists(absPath);
    }

    public boolean propertyExists(String absPath) throws RepositoryException {
        return this.itemExists(absPath);
    }

    public void removeItem(String absPath) throws VersionException, LockException, ConstraintViolationException, AccessDeniedException, RepositoryException {
        this.getItem(absPath).remove();
    }

    public boolean hasPermission(String absPath, String actions) throws RepositoryException {
        return false;
    }

    public boolean hasCapability(String s, Object o, Object[] objects) throws RepositoryException {
        return false;
    }

    public AccessControlManager getAccessControlManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        if (this.accessControlManager == null) {
            this.accessControlManager = new ExternalAccessControlManager(this.repository.getNamespaceRegistry(), this.getRepository().getStoreProvider().isReadOnly(), this.repository.getDataSource(), this);
        }
        return this.accessControlManager;
    }

    public RetentionManager getRetentionManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        return null;
    }

    public Session getExtensionSession() throws RepositoryException {
        JCRStoreProvider extensionProvider;
        if (this.extensionSession == null && (extensionProvider = this.getRepository().getStoreProvider().getExtensionProvider()) != null) {
            this.extensionSession = extensionProvider.getSession(JahiaLoginModule.getSystemCredentials((String)StringUtils.removeStart((String)this.getUserID(), (String)" system "), (String)this.getRealm()), "default");
        }
        return this.extensionSession;
    }

    public List<String> getExtensionAllowedTypes() throws RepositoryException {
        if (this.extensionAllowedTypes == null) {
            this.extensionAllowedTypes = this.getRepository().getStoreProvider().getExtendableTypes();
            if (this.extensionAllowedTypes == null) {
                this.extensionAllowedTypes = Arrays.asList("nt:base");
            }
        }
        return this.extensionAllowedTypes;
    }

    public Map<String, List<String>> getOverridableProperties() {
        if (this.overridableProperties == null) {
            this.overridableProperties = new HashMap<String, List<String>>();
            List<String> overridablePropertiesString = this.getRepository().getStoreProvider().getOverridableItems();
            if (overridablePropertiesString != null) {
                for (String s : overridablePropertiesString) {
                    String nodeType = StringUtils.substringBefore((String)s, (String)".");
                    String property = StringUtils.substringAfter((String)s, (String)".");
                    if (!this.overridableProperties.containsKey(nodeType)) {
                        this.overridableProperties.put(nodeType, new ArrayList());
                    }
                    this.overridableProperties.get(nodeType).add(property);
                }
            }
        }
        return this.overridableProperties;
    }

    public Map<String, List<String>> getNonOverridableProperties() {
        if (this.nonOverridableProperties == null) {
            this.nonOverridableProperties = new HashMap<String, List<String>>();
            List<String> nonOverridablePropertiesString = this.getRepository().getStoreProvider().getNonOverridableItems();
            if (nonOverridablePropertiesString != null) {
                for (String s : nonOverridablePropertiesString) {
                    String nodeType = StringUtils.substringBefore((String)s, (String)".");
                    String property = StringUtils.substringAfter((String)s, (String)".");
                    if (!this.nonOverridableProperties.containsKey(nodeType)) {
                        this.nonOverridableProperties.put(nodeType, new ArrayList());
                    }
                    this.nonOverridableProperties.get(nodeType).add(property);
                }
            }
        }
        return this.nonOverridableProperties;
    }

    public List<String> getExtensionForbiddenMixins() throws RepositoryException {
        if (this.extensionForbiddenMixins == null) {
            this.extensionForbiddenMixins = this.getRepository().getStoreProvider().getNonExtendableMixins();
            if (this.extensionForbiddenMixins == null) {
                this.extensionForbiddenMixins = Collections.emptyList();
            }
        }
        return this.extensionForbiddenMixins;
    }

    public Map<String, Object> getSessionVariables() {
        return this.sessionVariables;
    }
}

