/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.commons.lang.StringUtils;

public class ExternalData {
    private String id;
    private String tmpId;
    private final String path;
    private final String name;
    private final String type;
    private boolean isNew = false;
    private List<String> mixin;
    private final Map<String, String[]> properties;
    private Map<String, Map<String, String[]>> i18nProperties;
    private Map<String, Binary[]> binaryProperties;
    private Set<String> lazyProperties;
    private Set<String> lazyBinaryProperties;
    private Map<String, Set<String>> lazyI18nProperties;

    public ExternalData(String id, String path, String type, Map<String, String[]> properties) {
        this(id, path, type, properties, false);
    }

    public ExternalData(String id, String path, String type, Map<String, String[]> properties, boolean isNew) {
        this.id = id;
        this.path = path;
        this.name = StringUtils.substringAfterLast((String)path, (String)"/");
        this.type = type;
        this.properties = properties;
        this.isNew = isNew;
        if (isNew) {
            this.tmpId = id;
        }
    }

    public String getId() {
        return this.id;
    }

    protected String getTmpId() {
        return this.tmpId;
    }

    public void setId(String id) throws RepositoryException {
        if (!this.isNew) {
            throw new UnsupportedRepositoryOperationException();
        }
        this.id = id;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public boolean isNew() {
        return this.isNew;
    }

    protected void markSaved() {
        this.isNew = false;
        this.tmpId = null;
    }

    public Map<String, String[]> getProperties() {
        return this.properties;
    }

    public Map<String, Map<String, String[]>> getI18nProperties() {
        return this.i18nProperties;
    }

    public void setI18nProperties(Map<String, Map<String, String[]>> i18nProperties) {
        this.i18nProperties = i18nProperties;
    }

    public Map<String, Binary[]> getBinaryProperties() {
        return this.binaryProperties;
    }

    public void setBinaryProperties(Map<String, Binary[]> binaryProperties) {
        this.binaryProperties = binaryProperties;
    }

    public List<String> getMixin() {
        return this.mixin;
    }

    public void setMixin(List<String> mixin) {
        this.mixin = mixin;
    }

    public Set<String> getLazyProperties() {
        return this.lazyProperties;
    }

    public void setLazyProperties(Set<String> lazyProperties) {
        this.lazyProperties = lazyProperties;
    }

    public Set<String> getLazyBinaryProperties() {
        return this.lazyBinaryProperties;
    }

    public void setLazyBinaryProperties(Set<String> lazyBinaryProperties) {
        this.lazyBinaryProperties = lazyBinaryProperties;
    }

    public Map<String, Set<String>> getLazyI18nProperties() {
        return this.lazyI18nProperties;
    }

    public void setLazyI18nProperties(Map<String, Set<String>> lazyI18nProperties) {
        this.lazyI18nProperties = lazyI18nProperties;
    }
}

