/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external;

import java.util.ArrayList;
import javax.jcr.AccessDeniedException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import javax.jcr.version.VersionException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.jackrabbit.commons.iterator.AccessControlPolicyIteratorAdapter;
import org.apache.jackrabbit.core.security.JahiaPrivilegeRegistry;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.modules.external.ExternalContentStoreProvider;
import org.jahia.modules.external.ExternalDataSource;
import org.jahia.modules.external.ExternalSessionImpl;
import org.jahia.services.usermanager.JahiaUserManagerService;

public class ExternalAccessControlManager
implements AccessControlManager {
    private static final AccessControlPolicy[] POLICIES = new AccessControlPolicy[0];
    private String[] rootNodePrivileges;
    private String[] privileges;
    private boolean readOnly;
    private ExternalDataSource dataSource;
    private JahiaPrivilegeRegistry registry;
    private final ExternalSessionImpl session;
    private String rootUserName;

    public ExternalAccessControlManager(NamespaceRegistry namespaceRegistry, boolean readOnly, ExternalDataSource dataSource, ExternalSessionImpl session) {
        this.readOnly = readOnly;
        this.dataSource = dataSource;
        this.session = session;
        try {
            this.init(namespaceRegistry);
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException((Throwable)e);
        }
    }

    private void init(NamespaceRegistry namespaceRegistry) throws RepositoryException {
        this.registry = new JahiaPrivilegeRegistry(namespaceRegistry);
        this.rootUserName = JahiaUserManagerService.getInstance().getRootUserName();
        if (this.readOnly) {
            this.rootNodePrivileges = new String[]{"{http://www.jcp.org/jcr/1.0}read_default", "{http://www.jcp.org/jcr/1.0}read_live"};
            this.privileges = this.rootNodePrivileges;
        } else {
            this.rootNodePrivileges = new String[]{"{http://www.jcp.org/jcr/1.0}read_default", "{http://www.jcp.org/jcr/1.0}read_live", "{http://www.jcp.org/jcr/1.0}write_default", "{http://www.jcp.org/jcr/1.0}write_live", "{http://www.jcp.org/jcr/1.0}addChildNodes_default", "{http://www.jcp.org/jcr/1.0}addChildNodes_live", "{http://www.jcp.org/jcr/1.0}removeChildNodes_default", "{http://www.jcp.org/jcr/1.0}removeChildNodes_live"};
            this.privileges = new String[]{"{http://www.jcp.org/jcr/1.0}read_default", "{http://www.jcp.org/jcr/1.0}read_live", "{http://www.jcp.org/jcr/1.0}write_default", "{http://www.jcp.org/jcr/1.0}write_live", "{http://www.jcp.org/jcr/1.0}removeNode_default", "{http://www.jcp.org/jcr/1.0}removeNode_live", "{http://www.jcp.org/jcr/1.0}addChildNodes_default", "{http://www.jcp.org/jcr/1.0}addChildNodes_live", "{http://www.jcp.org/jcr/1.0}removeChildNodes_default", "{http://www.jcp.org/jcr/1.0}removeChildNodes_live"};
        }
    }

    public AccessControlPolicyIterator getApplicablePolicies(String absPath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        return AccessControlPolicyIteratorAdapter.EMPTY;
    }

    public AccessControlPolicy[] getEffectivePolicies(String absPath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        return POLICIES;
    }

    public AccessControlPolicy[] getPolicies(String absPath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        return POLICIES;
    }

    public Privilege[] getPrivileges(String absPath) throws PathNotFoundException, RepositoryException {
        ArrayList<Privilege> l = new ArrayList<Privilege>();
        for (String s : this.getPrivilegesNames(absPath)) {
            Privilege privilege = this.registry.getPrivilege(s, null);
            if (privilege == null) continue;
            l.add(privilege);
        }
        return l.toArray(new Privilege[l.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getPrivilegesNames(String absPath) {
        if (this.dataSource instanceof ExternalDataSource.AccessControllable) {
            ExternalContentStoreProvider.setCurrentSession(this.session);
            try {
                String[] stringArray = ((ExternalDataSource.AccessControllable)((Object)this.dataSource)).getPrivilegesNames(this.session.getUserID(), absPath);
                return stringArray;
            }
            finally {
                ExternalContentStoreProvider.removeCurrentSession();
            }
        }
        return absPath.length() == 1 && "/".equals(absPath) ? this.rootNodePrivileges : this.privileges;
    }

    public Privilege[] getSupportedPrivileges(String absPath) throws PathNotFoundException, RepositoryException {
        return JahiaPrivilegeRegistry.getRegisteredPrivileges();
    }

    public boolean hasPrivileges(String absPath, Privilege[] privileges) throws PathNotFoundException, RepositoryException {
        if (privileges == null || privileges.length == 0) {
            return true;
        }
        String userID = this.session.getUserID();
        if (userID.startsWith(" system ") || this.rootUserName.equals(userID)) {
            return true;
        }
        boolean allowed = true;
        Object[] granted = this.getPrivileges(absPath);
        for (Privilege toCheck : privileges) {
            if (toCheck == null || ArrayUtils.contains((Object[])granted, (Object)toCheck)) continue;
            allowed = false;
            break;
        }
        return allowed;
    }

    public Privilege privilegeFromName(String privilegeName) throws AccessControlException, RepositoryException {
        try {
            return this.registry.getPrivilege(privilegeName, null);
        }
        catch (AccessControlException e) {
            if (e.getMessage() != null && e.getMessage().startsWith("Unknown privilege {http://www.jcp.org/jcr/1.0}")) {
                return this.registry.getPrivilege(privilegeName, "default");
            }
            throw e;
        }
    }

    public void removePolicy(String absPath, AccessControlPolicy policy) throws PathNotFoundException, AccessControlException, AccessDeniedException, LockException, VersionException, RepositoryException {
    }

    public void setPolicy(String absPath, AccessControlPolicy policy) throws PathNotFoundException, AccessControlException, AccessDeniedException, LockException, VersionException, RepositoryException {
    }
}

