/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.NoSuchElementException;
import javax.jcr.AccessDeniedException;
import javax.jcr.Binary;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidLifecycleTransitionException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.MergeException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.ActivityViolationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import org.jahia.modules.external.ExtensionItem;
import org.jahia.modules.external.ExtensionProperty;
import org.jahia.modules.external.ExternalContentStoreProvider;
import org.jahia.modules.external.ExternalSessionImpl;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionNode
extends ExtensionItem
implements Node {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionNode.class);
    private Node node;
    private String uuid;
    private String path;
    private ExternalSessionImpl session;

    public ExtensionNode(Node node, String path, ExternalSessionImpl session) {
        super((Item)node, path, session);
        this.node = node;
        this.path = path;
        this.session = session;
    }

    public Node getJcrNode() {
        return this.node;
    }

    public Node addNode(String relPath) throws RepositoryException {
        return this.addNode(relPath, null);
    }

    public Node addNode(String relPath, String primaryNodeTypeName) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException {
        Node subNode = this.node.addNode(relPath, primaryNodeTypeName);
        subNode.addMixin("jmix:externalProviderExtension");
        subNode.setProperty("j:isExternalProviderRoot", false);
        List<Value> values = ExtensionNode.createNodeTypeValues(this.session.getValueFactory(), primaryNodeTypeName);
        subNode.setProperty("j:extendedType", values.toArray(new Value[values.size()]));
        return new ExtensionNode(subNode, this.path + "/" + relPath, this.session);
    }

    public static List<Value> createNodeTypeValues(ValueFactory valueFactory, String primaryNodeTypeName) throws RepositoryException {
        ArrayList<Value> values = new ArrayList<Value>();
        values.add(valueFactory.createValue(primaryNodeTypeName));
        for (ExtendedNodeType type : NodeTypeRegistry.getInstance().getNodeType(primaryNodeTypeName).getSupertypes()) {
            values.add(valueFactory.createValue(type.getName()));
        }
        return values;
    }

    public void orderBefore(String srcChildRelPath, String destChildRelPath) throws UnsupportedRepositoryOperationException, VersionException, ConstraintViolationException, ItemNotFoundException, LockException, RepositoryException {
        this.node.orderBefore(srcChildRelPath, destChildRelPath);
    }

    public Property setProperty(String name, Value value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return new ExtensionProperty(this.node.setProperty(name, value), this.path + "/" + name, this.session, this);
    }

    public Property setProperty(String name, Value value, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return new ExtensionProperty(this.node.setProperty(name, value, type), this.path + "/" + name, this.session, this);
    }

    public Property setProperty(String name, Value[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return new ExtensionProperty(this.node.setProperty(name, values), this.path + "/" + name, this.session, this);
    }

    public Property setProperty(String name, Value[] values, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return new ExtensionProperty(this.node.setProperty(name, values, type), this.path + "/" + name, this.session, this);
    }

    public Property setProperty(String name, String[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return new ExtensionProperty(this.node.setProperty(name, values), this.path + "/" + name, this.session, this);
    }

    public Property setProperty(String name, String[] values, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return new ExtensionProperty(this.node.setProperty(name, values, type), this.path + "/" + name, this.session, this);
    }

    public Property setProperty(String name, String value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return new ExtensionProperty(this.node.setProperty(name, value), this.path + "/" + name, this.session, this);
    }

    public Property setProperty(String name, String value, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return new ExtensionProperty(this.node.setProperty(name, value, type), this.path + "/" + name, this.session, this);
    }

    public Property setProperty(String name, InputStream value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return new ExtensionProperty(this.node.setProperty(name, value), this.path + "/" + name, this.session, this);
    }

    public Property setProperty(String name, Binary value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return new ExtensionProperty(this.node.setProperty(name, value), this.path + "/" + name, this.session, this);
    }

    public Property setProperty(String name, boolean value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return new ExtensionProperty(this.node.setProperty(name, value), this.path + "/" + name, this.session, this);
    }

    public Property setProperty(String name, double value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return new ExtensionProperty(this.node.setProperty(name, value), this.path + "/" + name, this.session, this);
    }

    public Property setProperty(String name, BigDecimal value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return new ExtensionProperty(this.node.setProperty(name, value), this.path + "/" + name, this.session, this);
    }

    public Property setProperty(String name, long value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return new ExtensionProperty(this.node.setProperty(name, value), this.path + "/" + name, this.session, this);
    }

    public Property setProperty(String name, Calendar value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return new ExtensionProperty(this.node.setProperty(name, value), this.path + "/" + name, this.session, this);
    }

    public Property setProperty(String name, Node value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return new ExtensionProperty(this.node.setProperty(name, value), this.path + "/" + name, this.session, this);
    }

    public Node getNode(String relPath) throws PathNotFoundException, RepositoryException {
        return new ExtensionNode(this.node.getNode(relPath), this.path + "/" + relPath, this.session);
    }

    public NodeIterator getNodes() throws RepositoryException {
        return new ExtensionNodeIterator(this.node.getNodes());
    }

    public NodeIterator getNodes(String namePattern) throws RepositoryException {
        return new ExtensionNodeIterator(this.node.getNodes(namePattern));
    }

    public NodeIterator getNodes(String[] nameGlobs) throws RepositoryException {
        return new ExtensionNodeIterator(this.node.getNodes(nameGlobs));
    }

    public Property getProperty(String relPath) throws PathNotFoundException, RepositoryException {
        return new ExtensionProperty(this.node.getProperty(relPath), this.path + "/" + relPath, this.session, this);
    }

    public PropertyIterator getProperties() throws RepositoryException {
        return new ExtensionPropertyIterator(this.node.getProperties());
    }

    public PropertyIterator getProperties(String namePattern) throws RepositoryException {
        return new ExtensionPropertyIterator(this.node.getProperties(namePattern));
    }

    public PropertyIterator getProperties(String[] nameGlobs) throws RepositoryException {
        return new ExtensionPropertyIterator(this.node.getProperties(nameGlobs));
    }

    public Item getPrimaryItem() throws ItemNotFoundException, RepositoryException {
        return new ExtensionItem(this.node.getPrimaryItem(), this.path, this.session);
    }

    public String getUUID() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.getIdentifier();
    }

    public String getIdentifier() throws RepositoryException {
        if (this.uuid == null) {
            ExternalContentStoreProvider storeProvider = this.getSession().getRepository().getStoreProvider();
            this.uuid = storeProvider.getOrCreateInternalIdentifier(this.node.getIdentifier());
        }
        return this.uuid;
    }

    public int getIndex() throws RepositoryException {
        return this.node.getIndex();
    }

    public PropertyIterator getReferences() throws RepositoryException {
        return new ExtensionPropertyIterator(this.node.getReferences());
    }

    public PropertyIterator getReferences(String name) throws RepositoryException {
        return new ExtensionPropertyIterator(this.node.getReferences(name));
    }

    public PropertyIterator getWeakReferences() throws RepositoryException {
        return new ExtensionPropertyIterator(this.node.getWeakReferences());
    }

    public PropertyIterator getWeakReferences(String name) throws RepositoryException {
        return new ExtensionPropertyIterator(this.node.getWeakReferences(name));
    }

    public boolean hasNode(String relPath) throws RepositoryException {
        return this.node.hasNode(relPath);
    }

    public boolean hasProperty(String relPath) throws RepositoryException {
        return this.node.hasProperty(relPath);
    }

    public boolean hasNodes() throws RepositoryException {
        return this.node.hasNodes();
    }

    public boolean hasProperties() throws RepositoryException {
        return this.node.hasProperties();
    }

    public NodeType getPrimaryNodeType() throws RepositoryException {
        return this.node.getPrimaryNodeType();
    }

    public NodeType[] getMixinNodeTypes() throws RepositoryException {
        ArrayList<ExtendedNodeType> nt = new ArrayList<ExtendedNodeType>();
        for (NodeType nodeType : this.node.getMixinNodeTypes()) {
            if (nodeType.getName().equals("jmix:externalProviderExtension")) continue;
            nt.add(NodeTypeRegistry.getInstance().getNodeType(nodeType.getName()));
        }
        return nt.toArray(new NodeType[nt.size()]);
    }

    public boolean isNodeType(String nodeTypeName) throws RepositoryException {
        return this.node.isNodeType(nodeTypeName);
    }

    public void setPrimaryType(String nodeTypeName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        this.node.setPrimaryType(nodeTypeName);
    }

    public void addMixin(String mixinName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        this.node.addMixin(mixinName);
    }

    public void removeMixin(String mixinName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        this.node.removeMixin(mixinName);
    }

    public boolean canAddMixin(String mixinName) throws NoSuchNodeTypeException, RepositoryException {
        return this.node.canAddMixin(mixinName);
    }

    public NodeDefinition getDefinition() throws RepositoryException {
        return this.node.getDefinition();
    }

    public Version checkin() throws VersionException, UnsupportedRepositoryOperationException, InvalidItemStateException, LockException, RepositoryException {
        return this.node.checkin();
    }

    public void checkout() throws UnsupportedRepositoryOperationException, LockException, ActivityViolationException, RepositoryException {
        this.node.checkout();
    }

    public void doneMerge(Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        this.node.doneMerge(version);
    }

    public void cancelMerge(Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        this.node.cancelMerge(version);
    }

    public void update(String srcWorkspace) throws NoSuchWorkspaceException, AccessDeniedException, LockException, InvalidItemStateException, RepositoryException {
        this.node.update(srcWorkspace);
    }

    public NodeIterator merge(String srcWorkspace, boolean bestEffort) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        return new ExtensionNodeIterator(this.node.merge(srcWorkspace, bestEffort));
    }

    public String getCorrespondingNodePath(String workspaceName) throws ItemNotFoundException, NoSuchWorkspaceException, AccessDeniedException, RepositoryException {
        return this.node.getCorrespondingNodePath(workspaceName);
    }

    public NodeIterator getSharedSet() throws RepositoryException {
        return new ExtensionNodeIterator(this.node.getSharedSet());
    }

    public void removeSharedSet() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.node.removeSharedSet();
    }

    public void removeShare() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.node.removeShare();
    }

    public boolean isCheckedOut() throws RepositoryException {
        return this.node.isCheckedOut();
    }

    public void restore(String versionName, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        this.node.restore(versionName, removeExisting);
    }

    public void restore(Version version, boolean removeExisting) throws VersionException, ItemExistsException, InvalidItemStateException, UnsupportedRepositoryOperationException, LockException, RepositoryException {
        this.node.restore(version, removeExisting);
    }

    public void restore(Version version, String relPath, boolean removeExisting) throws PathNotFoundException, ItemExistsException, VersionException, ConstraintViolationException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        this.node.restore(version, relPath, removeExisting);
    }

    public void restoreByLabel(String versionLabel, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        this.node.restoreByLabel(versionLabel, removeExisting);
    }

    public VersionHistory getVersionHistory() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.node.getVersionHistory();
    }

    public Version getBaseVersion() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.node.getBaseVersion();
    }

    public Lock lock(boolean isDeep, boolean isSessionScoped) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        return this.node.lock(isDeep, isSessionScoped);
    }

    public Lock getLock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        return this.node.getLock();
    }

    public void unlock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        this.node.unlock();
    }

    public boolean holdsLock() throws RepositoryException {
        return this.node.holdsLock();
    }

    public boolean isLocked() throws RepositoryException {
        return this.node.isLocked();
    }

    public void followLifecycleTransition(String transition) throws UnsupportedRepositoryOperationException, InvalidLifecycleTransitionException, RepositoryException {
        this.node.followLifecycleTransition(transition);
    }

    public String[] getAllowedLifecycleTransistions() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.node.getAllowedLifecycleTransistions();
    }

    private class ExtensionNodeIterator
    implements NodeIterator {
        private int pos = 0;
        private NodeIterator extensionNodeIterator;
        private Node nextNode;

        public ExtensionNodeIterator(NodeIterator extensionNodeIterator) {
            this.extensionNodeIterator = extensionNodeIterator;
            this.fetchNext();
        }

        private Node fetchNext() {
            this.nextNode = null;
            if (this.extensionNodeIterator != null) {
                while (this.extensionNodeIterator.hasNext()) {
                    try {
                        Node n = this.extensionNodeIterator.nextNode();
                        this.nextNode = new ExtensionNode(n, ExtensionNode.this.getPath() + "/" + n.getName(), ExtensionNode.this.getSession());
                        return this.nextNode;
                    }
                    catch (RepositoryException e) {
                        logger.error("Cannot get node", (Throwable)e);
                    }
                }
            }
            return null;
        }

        public Node nextNode() {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            Node next = this.nextNode;
            this.fetchNext();
            ++this.pos;
            return next;
        }

        public void skip(long skipNum) {
            int i = 0;
            while ((long)i < skipNum) {
                this.nextNode();
                ++i;
            }
        }

        public long getSize() {
            return this.extensionNodeIterator.getSize();
        }

        public long getPosition() {
            return this.pos;
        }

        public boolean hasNext() {
            return this.nextNode != null;
        }

        public Object next() {
            return this.nextNode();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ExtensionPropertyIterator
    implements PropertyIterator {
        private int pos = 0;
        private PropertyIterator extensionPropertiesIterator;
        private Property nextProperty = null;

        ExtensionPropertyIterator(PropertyIterator extensionPropertiesIterator) {
            this.extensionPropertiesIterator = extensionPropertiesIterator;
            this.fetchNext();
        }

        private Property fetchNext() {
            this.nextProperty = null;
            if (this.extensionPropertiesIterator != null) {
                while (this.extensionPropertiesIterator.hasNext()) {
                    Property next = this.extensionPropertiesIterator.nextProperty();
                    try {
                        this.nextProperty = new ExtensionProperty(next, ExtensionNode.this.node.getPath() + "/" + next.getName(), ExtensionNode.this.getSession(), ExtensionNode.this);
                        return this.nextProperty;
                    }
                    catch (RepositoryException repositoryException) {
                    }
                }
            }
            return null;
        }

        public Property nextProperty() {
            if (this.nextProperty == null) {
                throw new NoSuchElementException();
            }
            Property next = this.nextProperty;
            this.fetchNext();
            ++this.pos;
            return next;
        }

        public void skip(long skipNum) {
            int i = 0;
            while ((long)i < skipNum) {
                this.nextProperty();
                ++i;
            }
        }

        public long getSize() {
            return this.extensionPropertiesIterator.getSize();
        }

        public long getPosition() {
            return this.pos;
        }

        public boolean hasNext() {
            return this.nextProperty != null;
        }

        public Object next() {
            return this.nextProperty();
        }

        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

