/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.configuration.configurators;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public final class DatabaseScripts {
    private DatabaseScripts() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getSchemaSQL(File fileObject) throws IOException {
        Properties scriptProperties = new Properties();
        FileInputStream scriptInputStream = new FileInputStream(fileObject.getPath());
        try {
            scriptProperties.load(scriptInputStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)scriptInputStream);
        }
        String scriptLocation = scriptProperties.getProperty("jahia.database.schemascriptdir");
        File parentFile = fileObject.getParentFile();
        File schemaDir = new File(parentFile, scriptLocation);
        List<String> result = DatabaseScripts.getSQLStatementsInDir(schemaDir, ".sql");
        return result;
    }

    public static List<String> getSQLStatementsInDir(File sqlDir, final String extension) throws IOException {
        List<String> curFileSQL;
        int i;
        ArrayList<String> result = new ArrayList<String>();
        File[] schemaFiles = sqlDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (extension != null) {
                    return name.toLowerCase().endsWith(extension);
                }
                return true;
            }
        });
        if (schemaFiles == null) {
            return result;
        }
        ArrayList<File> indexFiles = new ArrayList<File>();
        for (i = 0; i < schemaFiles.length; ++i) {
            File sqlFile = schemaFiles[i];
            if (sqlFile.getName().endsWith("index.sql")) {
                indexFiles.add(sqlFile);
                continue;
            }
            System.out.println("Loading statements from script file " + sqlFile);
            curFileSQL = DatabaseScripts.getScriptFileStatements(sqlFile);
            result.addAll(curFileSQL);
        }
        for (i = 0; i < indexFiles.size(); ++i) {
            File indexFile = (File)indexFiles.get(i);
            System.out.println("Loading statements from index script file " + indexFile);
            curFileSQL = DatabaseScripts.getScriptFileStatements(indexFile);
            result.addAll(curFileSQL);
        }
        return result;
    }

    private static List<String> getScriptFileStatements(File fileObject) throws IOException {
        return org.jahia.commons.DatabaseScripts.getScriptStatements((Reader)new FileReader(fileObject));
    }
}

