/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.runtime;

import io.protostuff.Exclude;
import io.protostuff.Input;
import io.protostuff.Message;
import io.protostuff.Output;
import io.protostuff.Pipe;
import io.protostuff.Schema;
import io.protostuff.Tag;
import io.protostuff.runtime.ArrayFieldMap;
import io.protostuff.runtime.DefaultIdStrategy;
import io.protostuff.runtime.Field;
import io.protostuff.runtime.FieldMap;
import io.protostuff.runtime.HasSchema;
import io.protostuff.runtime.HashFieldMap;
import io.protostuff.runtime.IdStrategy;
import io.protostuff.runtime.RuntimeEnv;
import io.protostuff.runtime.RuntimeFieldFactory;
import io.protostuff.runtime.RuntimePipeSchema;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class RuntimeSchema<T>
implements Schema<T>,
FieldMap<T> {
    public static final int MIN_TAG_VALUE = 1;
    public static final int MAX_TAG_VALUE = 0x1FFFFFFF;
    public static final String ERROR_TAG_VALUE = "Invalid tag number (value must be in range [1, 2^29-1])";
    private static final Set<String> NO_EXCLUSIONS = Collections.emptySet();
    public static final int MIN_TAG_FOR_HASH_FIELD_MAP = 100;
    private final Pipe.Schema<T> pipeSchema;
    private final FieldMap<T> fieldMap;
    private final Class<T> typeClass;
    public final RuntimeEnv.Instantiator<T> instantiator;

    public static <T> boolean map(Class<? super T> baseClass, Class<T> typeClass) {
        if (RuntimeEnv.ID_STRATEGY instanceof DefaultIdStrategy) {
            return ((DefaultIdStrategy)RuntimeEnv.ID_STRATEGY).map(baseClass, typeClass);
        }
        throw new RuntimeException("RuntimeSchema.map is only supported on DefaultIdStrategy");
    }

    public static <T> boolean register(Class<T> typeClass, Schema<T> schema) {
        if (RuntimeEnv.ID_STRATEGY instanceof DefaultIdStrategy) {
            return ((DefaultIdStrategy)RuntimeEnv.ID_STRATEGY).registerPojo(typeClass, schema);
        }
        throw new RuntimeException("RuntimeSchema.register is only supported on DefaultIdStrategy");
    }

    public static <T> boolean register(Class<T> typeClass) {
        if (RuntimeEnv.ID_STRATEGY instanceof DefaultIdStrategy) {
            return ((DefaultIdStrategy)RuntimeEnv.ID_STRATEGY).registerPojo(typeClass);
        }
        throw new RuntimeException("RuntimeSchema.register is only supported on DefaultIdStrategy");
    }

    public static boolean isRegistered(Class<?> typeClass) {
        return RuntimeSchema.isRegistered(typeClass, RuntimeEnv.ID_STRATEGY);
    }

    public static boolean isRegistered(Class<?> typeClass, IdStrategy strategy) {
        return strategy.isRegistered(typeClass);
    }

    public static <T> Schema<T> getSchema(Class<T> typeClass) {
        return RuntimeSchema.getSchema(typeClass, RuntimeEnv.ID_STRATEGY);
    }

    public static <T> Schema<T> getSchema(Class<T> typeClass, IdStrategy strategy) {
        return strategy.getSchemaWrapper(typeClass, true).getSchema();
    }

    static <T> HasSchema<T> getSchemaWrapper(Class<T> typeClass) {
        return RuntimeSchema.getSchemaWrapper(typeClass, RuntimeEnv.ID_STRATEGY);
    }

    static <T> HasSchema<T> getSchemaWrapper(Class<T> typeClass, IdStrategy strategy) {
        return strategy.getSchemaWrapper(typeClass, true);
    }

    public static <T> RuntimeSchema<T> createFrom(Class<T> typeClass) {
        return RuntimeSchema.createFrom(typeClass, NO_EXCLUSIONS, RuntimeEnv.ID_STRATEGY);
    }

    public static <T> RuntimeSchema<T> createFrom(Class<T> typeClass, IdStrategy strategy) {
        return RuntimeSchema.createFrom(typeClass, NO_EXCLUSIONS, strategy);
    }

    public static <T> RuntimeSchema<T> createFrom(Class<T> typeClass, String[] exclusions, IdStrategy strategy) {
        HashSet<String> set = new HashSet<String>();
        for (String exclusion : exclusions) {
            set.add(exclusion);
        }
        return RuntimeSchema.createFrom(typeClass, set, strategy);
    }

    public static <T> RuntimeSchema<T> createFrom(Class<T> typeClass, Set<String> exclusions, IdStrategy strategy) {
        if (typeClass.isInterface() || Modifier.isAbstract(typeClass.getModifiers())) {
            throw new RuntimeException("The root object can neither be an abstract class nor interface: \"" + typeClass.getName());
        }
        Map<String, java.lang.reflect.Field> fieldMap = RuntimeSchema.findInstanceFields(typeClass);
        ArrayList<Field<T>> fields = new ArrayList<Field<T>>(fieldMap.size());
        int i = 0;
        boolean annotated = false;
        for (java.lang.reflect.Field f : fieldMap.values()) {
            String name;
            int fieldMapping;
            if (exclusions.contains(f.getName())) continue;
            if (f.getAnnotation(Deprecated.class) != null) {
                ++i;
                continue;
            }
            Tag tag = f.getAnnotation(Tag.class);
            if (tag == null) {
                if (annotated) {
                    String className = typeClass.getCanonicalName();
                    String fieldName = f.getName();
                    String message = String.format("%s#%s is not annotated with @Tag", className, fieldName);
                    throw new RuntimeException(message);
                }
                fieldMapping = ++i;
                name = f.getName();
            } else {
                if (!annotated && !fields.isEmpty()) {
                    throw new RuntimeException("When using annotation-based mapping, all fields must be annotated with @" + Tag.class.getSimpleName());
                }
                annotated = true;
                fieldMapping = tag.value();
                if (fieldMapping < 1 || fieldMapping > 0x1FFFFFFF) {
                    throw new IllegalArgumentException("Invalid tag number (value must be in range [1, 2^29-1]): " + fieldMapping + " on " + typeClass);
                }
                name = tag.alias().isEmpty() ? f.getName() : tag.alias();
            }
            Field field = RuntimeFieldFactory.getFieldFactory(f.getType(), strategy).create(fieldMapping, name, f, strategy);
            fields.add(field);
        }
        return new RuntimeSchema<T>(typeClass, fields, RuntimeEnv.newInstantiator(typeClass));
    }

    public static <T> RuntimeSchema<T> createFrom(Class<T> typeClass, Map<String, String> declaredFields, IdStrategy strategy) {
        if (typeClass.isInterface() || Modifier.isAbstract(typeClass.getModifiers())) {
            throw new RuntimeException("The root object can neither be an abstract class nor interface: \"" + typeClass.getName());
        }
        ArrayList<Field<T>> fields = new ArrayList<Field<T>>(declaredFields.size());
        int i = 0;
        for (Map.Entry<String, String> entry : declaredFields.entrySet()) {
            java.lang.reflect.Field f;
            try {
                f = typeClass.getDeclaredField(entry.getKey());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Exception on field: " + entry.getKey(), e);
            }
            int mod = f.getModifiers();
            if (Modifier.isStatic(mod) || Modifier.isTransient(mod) || f.getAnnotation(Exclude.class) != null) continue;
            Field field = RuntimeFieldFactory.getFieldFactory(f.getType(), strategy).create(++i, entry.getValue(), f, strategy);
            fields.add(field);
        }
        return new RuntimeSchema<T>(typeClass, fields, RuntimeEnv.newInstantiator(typeClass));
    }

    static Map<String, java.lang.reflect.Field> findInstanceFields(Class<?> typeClass) {
        LinkedHashMap<String, java.lang.reflect.Field> fieldMap = new LinkedHashMap<String, java.lang.reflect.Field>();
        RuntimeSchema.fill(fieldMap, typeClass);
        return fieldMap;
    }

    static void fill(Map<String, java.lang.reflect.Field> fieldMap, Class<?> typeClass) {
        if (Object.class != typeClass.getSuperclass()) {
            RuntimeSchema.fill(fieldMap, typeClass.getSuperclass());
        }
        for (java.lang.reflect.Field f : typeClass.getDeclaredFields()) {
            int mod = f.getModifiers();
            if (Modifier.isStatic(mod) || Modifier.isTransient(mod) || f.getAnnotation(Exclude.class) != null) continue;
            fieldMap.put(f.getName(), f);
        }
    }

    public RuntimeSchema(Class<T> typeClass, Collection<Field<T>> fields, Constructor<T> constructor) {
        this(typeClass, fields, new RuntimeEnv.DefaultInstantiator<T>(constructor));
    }

    public RuntimeSchema(Class<T> typeClass, Collection<Field<T>> fields, RuntimeEnv.Instantiator<T> instantiator) {
        this.fieldMap = this.createFieldMap(fields);
        this.pipeSchema = new RuntimePipeSchema<T>(this, this.fieldMap);
        this.instantiator = instantiator;
        this.typeClass = typeClass;
    }

    private FieldMap<T> createFieldMap(Collection<Field<T>> fields) {
        int lastFieldNumber = 0;
        for (Field<T> field : fields) {
            if (field.number <= lastFieldNumber) continue;
            lastFieldNumber = field.number;
        }
        if (this.preferHashFieldMap(fields, lastFieldNumber)) {
            return new HashFieldMap<T>(fields);
        }
        return new ArrayFieldMap<T>(fields, lastFieldNumber);
    }

    private boolean preferHashFieldMap(Collection<Field<T>> fields, int lastFieldNumber) {
        return lastFieldNumber > 100 && lastFieldNumber >= 2 * fields.size();
    }

    public Pipe.Schema<T> getPipeSchema() {
        return this.pipeSchema;
    }

    @Override
    public Field<T> getFieldByNumber(int n) {
        return this.fieldMap.getFieldByNumber(n);
    }

    @Override
    public Field<T> getFieldByName(String fieldName) {
        return this.fieldMap.getFieldByName(fieldName);
    }

    @Override
    public int getFieldCount() {
        return this.fieldMap.getFieldCount();
    }

    @Override
    public List<Field<T>> getFields() {
        return this.fieldMap.getFields();
    }

    @Override
    public Class<T> typeClass() {
        return this.typeClass;
    }

    @Override
    public String messageName() {
        return this.typeClass.getSimpleName();
    }

    @Override
    public String messageFullName() {
        return this.typeClass.getName();
    }

    @Override
    public String getFieldName(int number) {
        Field<T> field = this.getFieldByNumber(number);
        return field == null ? null : field.name;
    }

    @Override
    public int getFieldNumber(String name) {
        Field<T> field = this.getFieldByName(name);
        return field == null ? 0 : field.number;
    }

    @Override
    public final void mergeFrom(Input input, T message) throws IOException {
        int n = input.readFieldNumber(this);
        while (n != 0) {
            Field<T> field = this.getFieldByNumber(n);
            if (field == null) {
                input.handleUnknownField(n, this);
            } else {
                field.mergeFrom(input, message);
            }
            n = input.readFieldNumber(this);
        }
    }

    @Override
    public final void writeTo(Output output, T message) throws IOException {
        for (Field<T> f : this.getFields()) {
            f.writeTo(output, message);
        }
    }

    @Override
    public boolean isInitialized(T message) {
        return true;
    }

    @Override
    public T newMessage() {
        return this.instantiator.newInstance();
    }

    static <T> Pipe.Schema<T> resolvePipeSchema(Schema<T> schema, Class<? super T> clazz, boolean throwIfNone) {
        if (Message.class.isAssignableFrom(clazz)) {
            try {
                Method m = clazz.getDeclaredMethod("getPipeSchema", new Class[0]);
                return (Pipe.Schema)m.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (RuntimeSchema.class.isAssignableFrom(schema.getClass())) {
            return ((RuntimeSchema)schema).getPipeSchema();
        }
        if (throwIfNone) {
            throw new RuntimeException("No pipe schema for: " + clazz);
        }
        return null;
    }
}

