/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.reactive.client.impl;

import io.reactivex.rxjava3.core.Flowable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.infinispan.query.dsl.Query;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class QueryPublisherImpl<T>
implements Publisher<T> {
    private final ExecutorService executorService;
    private final Query query;

    public QueryPublisherImpl(Query query, ExecutorService executorService) {
        this.query = query;
        this.executorService = executorService;
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        CompletableFuture.supplyAsync(() -> this.query.execute().list(), this.executorService).whenComplete((r, ex) -> {
            if (ex != null) {
                Flowable flowable = Flowable.empty();
                flowable.subscribe(subscriber);
                subscriber.onError(ex.getCause());
            } else {
                Flowable flowable = Flowable.fromIterable((Iterable)r);
                flowable.subscribe(subscriber);
            }
        });
    }
}

