/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.client.impl;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.infinispan.api.Infinispan;
import org.infinispan.api.client.configuration.InfinispanClientConfigImpl;
import org.infinispan.api.configuration.ClientConfig;
import org.infinispan.api.exception.InfinispanConfigurationException;
import org.infinispan.api.exception.InfinispanException;
import org.infinispan.api.marshalling.Marshaller;
import org.infinispan.api.reactive.KeyValueStore;
import org.infinispan.api.reactive.KeyValueStoreConfig;
import org.infinispan.api.reactive.client.impl.KeyValueStoreImpl;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.ProtoSchemaBuilder;

public class InfinispanClientImpl
implements Infinispan {
    private RemoteCacheManager cacheManager;
    private Set<String> files = ConcurrentHashMap.newKeySet();
    private ExecutorService asyncExecutorService;

    public InfinispanClientImpl(ClientConfig infinispanClientConfig) {
        if (!(infinispanClientConfig instanceof InfinispanClientConfigImpl)) {
            throw new InfinispanConfigurationException("Unable to construct InfinispanClientImpl. ClientConfig is not a InfinispanClientConfigImpl");
        }
        InfinispanClientConfigImpl infinispanClientConfigImpl = (InfinispanClientConfigImpl)infinispanClientConfig;
        this.cacheManager = new RemoteCacheManager(infinispanClientConfigImpl.getConfiguration());
        this.asyncExecutorService = this.cacheManager.getAsyncExecutorService();
    }

    public InfinispanClientImpl(RemoteCacheManager remoteCacheManager) {
        this.cacheManager = remoteCacheManager;
        this.asyncExecutorService = this.cacheManager.getAsyncExecutorService();
    }

    public <K, V> CompletionStage<KeyValueStore<K, V>> getKeyValueStore(String name, KeyValueStoreConfig config) {
        return CompletableFuture.supplyAsync(() -> {
            this.addProtobufSchema(config);
            RemoteCache cache = this.cacheManager.getCache(name, false);
            RemoteCache cacheWithReturnValues = this.cacheManager.getCache(name, true);
            return new KeyValueStoreImpl(cache, cacheWithReturnValues);
        }, this.asyncExecutorService);
    }

    public CompletionStage<Void> stop() {
        if (!this.files.isEmpty()) {
            SerializationContext ctx = MarshallerUtil.getSerializationContext((RemoteCacheManager)this.cacheManager);
            this.files.forEach(arg_0 -> ((SerializationContext)ctx).unregisterProtoFile(arg_0));
        }
        this.files.clear();
        return this.cacheManager.stopAsync();
    }

    private synchronized void addProtobufSchema(KeyValueStoreConfig config) {
        String protoFile;
        String fileName = config.getSchemaFileName();
        if (fileName == null) {
            return;
        }
        RemoteCache metadataCache = this.cacheManager.getCache("___protobuf_metadata");
        String file = (String)metadataCache.get((Object)fileName);
        if (file != null) {
            return;
        }
        this.files.add(fileName);
        SerializationContext ctx = MarshallerUtil.getSerializationContext((RemoteCacheManager)this.cacheManager);
        for (Marshaller marshaller : config.getMarshallers()) {
            ctx.registerMarshaller((BaseMarshaller)marshaller);
        }
        ProtoSchemaBuilder protoSchemaBuilder = new ProtoSchemaBuilder();
        try {
            protoFile = protoSchemaBuilder.fileName(fileName).addClass(config.getValueClazz()).packageName(config.getPackageName()).build(ctx);
        }
        catch (IOException e) {
            throw new InfinispanException("Error encountered when adding proto file", (Throwable)e);
        }
        metadataCache.putIfAbsentAsync((Object)fileName, (Object)protoFile);
    }
}

