package org.infinispan.client.hotrod.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.commons.CacheConfigurationException;
import java.lang.String;
import org.jboss.logging.Logger;
import org.jboss.logging.BasicLogger;
import java.util.List;
import java.net.SocketAddress;
import org.infinispan.client.hotrod.exceptions.InvalidResponseException;
import java.lang.IllegalArgumentException;
import javax.annotation.processing.Generated;
import org.infinispan.commons.CacheListenerException;
import io.netty.channel.Channel;
import java.lang.SecurityException;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import java.lang.reflect.Method;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.exceptions.CacheNotTransactionalException;
import java.lang.Exception;
import javax.transaction.xa.Xid;
import java.util.Collection;
import java.lang.Throwable;
import java.lang.Object;
import org.infinispan.client.hotrod.configuration.ExhaustedAction;
import java.util.Arrays;
import org.infinispan.client.hotrod.event.IncorrectClientListenerException;
import java.util.NoSuchElementException;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2023-06-05T10:46:52-0400")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void couldNotFindPropertiesFile(final String propertiesFile) {
        super.log.logf(FQCN, WARN, null, couldNotFindPropertiesFile$str(), propertiesFile);
    }
    protected String couldNotFindPropertiesFile$str() {
        return "ISPN004001: Could not find '%s' file in classpath, using defaults.";
    }
    @Override
    public final void unstartedRemoteCacheManager() {
        super.log.logf(FQCN, INFO, null, unstartedRemoteCacheManager$str());
    }
    protected String unstartedRemoteCacheManager$str() {
        return "ISPN004002: Cannot perform operations on a cache associated with an unstarted RemoteCacheManager. Use RemoteCacheManager.start before using the remote cache.";
    }
    protected String invalidMagicNumber$str() {
        return "ISPN004003: Invalid magic number. Expected %#x and received %#x";
    }
    @Override
    public final InvalidResponseException invalidMagicNumber(final short expectedMagicNumber, final short receivedMagic) {
        final InvalidResponseException result = new InvalidResponseException(String.format(getLoggingLocale(), invalidMagicNumber$str(), expectedMagicNumber, receivedMagic));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void errorFromServer(final String message) {
        super.log.logf(FQCN, WARN, null, errorFromServer$str(), message);
    }
    protected String errorFromServer$str() {
        return "ISPN004005: Error received from the server: %s";
    }
    @Override
    public final void newTopology(final int viewId, final int age, final int topologySize, final Collection<? extends SocketAddress> addresses) {
        super.log.logf(FQCN, INFO, null, newTopology$str(), viewId, age, topologySize, addresses);
    }
    protected String newTopology$str() {
        return "ISPN004006: Server sent new topology view (id=%d, age=%d) containing %d addresses: %s";
    }
    @Override
    public final void exceptionAndNoRetriesLeft(final int retry, final int maxRetries, final Throwable te) {
        super.log.logf(FQCN, ERROR, te, exceptionAndNoRetriesLeft$str(), retry, maxRetries);
    }
    protected String exceptionAndNoRetriesLeft$str() {
        return "ISPN004007: Exception encountered. Retry %d out of %d";
    }
    @Override
    public final void noHasHFunctionConfigured(final int hashFunctionVersion) {
        super.log.logf(FQCN, WARN, null, noHasHFunctionConfigured$str(), hashFunctionVersion);
    }
    protected String noHasHFunctionConfigured$str() {
        return "ISPN004011: No hash function configured for version: %d";
    }
    @Override
    public final void newServerAdded(final SocketAddress server) {
        super.log.logf(FQCN, INFO, null, newServerAdded$str(), server);
    }
    protected String newServerAdded$str() {
        return "ISPN004014: New server added(%s), adding to the pool.";
    }
    @Override
    public final void failedAddingNewServer(final SocketAddress server, final Throwable e) {
        super.log.logf(FQCN, WARN, e, failedAddingNewServer$str(), server);
    }
    protected String failedAddingNewServer$str() {
        return "ISPN004015: Failed adding new server %s";
    }
    @Override
    public final void removingServer(final SocketAddress server) {
        super.log.logf(FQCN, INFO, null, removingServer$str(), server);
    }
    protected String removingServer$str() {
        return "ISPN004016: Server not in cluster anymore(%s), removing from the pool.";
    }
    @Override
    public final void version(final String version) {
        super.log.logf(FQCN, INFO, null, version$str(), version);
    }
    protected String version$str() {
        return "ISPN004021: Infinispan version: %s";
    }
    protected String noSSLTrustManagerConfiguration$str() {
        return "ISPN004024: SSL Enabled but no TrustStore specified";
    }
    @Override
    public final CacheConfigurationException noSSLTrustManagerConfiguration() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), noSSLTrustManagerConfiguration$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingKeyStorePassword$str() {
        return "ISPN004025: A password is required to open the KeyStore '%s'";
    }
    @Override
    public final CacheConfigurationException missingKeyStorePassword(final String keyStore) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingKeyStorePassword$str(), keyStore));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingTrustStorePassword$str() {
        return "ISPN004026: A password is required to open the TrustStore '%s'";
    }
    @Override
    public final CacheConfigurationException missingTrustStorePassword(final String trustStore) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingTrustStorePassword$str(), trustStore));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String xorSSLContext$str() {
        return "ISPN004027: Cannot configure custom KeyStore and/or TrustStore when specifying a SSLContext";
    }
    @Override
    public final CacheConfigurationException xorSSLContext() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), xorSSLContext$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String parseErrorServerAddress$str() {
        return "ISPN004028: Unable to parse server IP address %s";
    }
    @Override
    public final CacheConfigurationException parseErrorServerAddress(final String server) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), parseErrorServerAddress$str(), server));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidMaxRetries$str() {
        return "ISPN004029: Invalid max_retries (value=%s). Value should be greater or equal than zero.";
    }
    @Override
    public final CacheConfigurationException invalidMaxRetries(final int retriesPerServer) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidMaxRetries$str(), retriesPerServer));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidAuthenticationConfiguration$str() {
        return "ISPN004030: Cannot enable authentication without specifying either a username, a token, a client Subject or a CallbackHandler";
    }
    @Override
    public final CacheConfigurationException invalidAuthenticationConfiguration() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidAuthenticationConfiguration$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedMech$str() {
        return "ISPN004031: The selected authentication mechanism '%s' is not among the supported server mechanisms: %s";
    }
    @Override
    public final SecurityException unsupportedMech(final String authMech, final List<String> serverMechs) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), unsupportedMech$str(), authMech, serverMechs));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToUnmarshallBytes$str() {
        return "ISPN004034: Unable to unmarshall bytes %s";
    }
    @Override
    public final HotRodClientException unableToUnmarshallBytes(final String bytes, final Exception e) {
        final HotRodClientException result = new HotRodClientException(String.format(getLoggingLocale(), unableToUnmarshallBytes$str(), bytes), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String exceptionInvokingListener$str() {
        return "ISPN004035: Caught exception [%s] while invoking method [%s] on listener instance: %s";
    }
    @Override
    public final CacheListenerException exceptionInvokingListener(final String name, final Method m, final Object target, final Throwable cause) {
        final CacheListenerException result = new CacheListenerException(String.format(getLoggingLocale(), exceptionInvokingListener$str(), name, m, target), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String incorrectClientListener2$str() {
        return "ISPN004036: Methods annotated with %s must accept exactly one parameter, of assignable from type %s";
    }
    @Override
    public final IncorrectClientListenerException incorrectClientListener(final String annotationName, final Collection<?> allowedParameters) {
        final IncorrectClientListenerException result = new IncorrectClientListenerException(String.format(getLoggingLocale(), incorrectClientListener2$str(), annotationName, allowedParameters));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String incorrectClientListener1$str() {
        return "ISPN004037: Methods annotated with %s should have a return type of void.";
    }
    @Override
    public final IncorrectClientListenerException incorrectClientListener(final String annotationName) {
        final IncorrectClientListenerException result = new IncorrectClientListenerException(String.format(getLoggingLocale(), incorrectClientListener1$str(), annotationName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void unexpectedErrorConsumingEvent(final Object event, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unexpectedErrorConsumingEvent$str(), event);
    }
    protected String unexpectedErrorConsumingEvent$str() {
        return "ISPN004038: Unexpected error consuming event %s";
    }
    @Override
    public final void unableToReadEventFromServer(final Throwable t, final SocketAddress server) {
        super.log.logf(FQCN, WARN, t, unableToReadEventFromServer$str(), server);
    }
    protected String unableToReadEventFromServer$str() {
        return "ISPN004039: Unable to complete reading event from server %s";
    }
    protected String missingClientListenerAnnotation$str() {
        return "ISPN004040: Cache listener class %s must be annotated with org.infinispan.client.hotrod.annotation.ClientListener";
    }
    @Override
    public final IncorrectClientListenerException missingClientListenerAnnotation(final String className) {
        final IncorrectClientListenerException result = new IncorrectClientListenerException(String.format(getLoggingLocale(), missingClientListenerAnnotation$str(), className));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownEvent$str() {
        return "ISPN004041: Unknown event type %s received";
    }
    @Override
    public final HotRodClientException unknownEvent(final short eventTypeId) {
        final HotRodClientException result = new HotRodClientException(String.format(getLoggingLocale(), unknownEvent$str(), eventTypeId));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void unableToSetAccesible(final Method m, final Exception e) {
        super.log.logf(FQCN, ERROR, e, unableToSetAccesible$str(), m);
    }
    protected String unableToSetAccesible$str() {
        return "ISPN004042: Unable to set method %s accessible";
    }
    protected String nearCacheMaxEntriesUndefined$str() {
        return "ISPN004045: When enabling near caching, number of max entries must be configured";
    }
    @Override
    public final CacheConfigurationException nearCacheMaxEntriesUndefined() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), nearCacheMaxEntriesUndefined$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void iterationClosed(final String iterationId) {
        super.log.logf(FQCN, DEBUG, null, iterationClosed$str(), iterationId);
    }
    protected String iterationClosed$str() {
        return "ISPN004046: Successfully closed remote iterator '%s'";
    }
    protected String errorClosingIteration$str() {
        return "ISPN004047: Invalid iteration id '%s'";
    }
    @Override
    public final IllegalStateException errorClosingIteration(final String iterationId) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), errorClosingIteration$str(), iterationId));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorRetrievingNext$str() {
        return "ISPN004048: Invalid iteration id '%s'";
    }
    @Override
    public final NoSuchElementException errorRetrievingNext(final String iterationId) {
        final NoSuchElementException result = new NoSuchElementException(String.format(getLoggingLocale(), errorRetrievingNext$str(), iterationId));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void switchedToCluster(final String clusterName) {
        super.log.logf(FQCN, INFO, null, switchedToCluster$str(), clusterName);
    }
    protected String switchedToCluster$str() {
        return "ISPN004050: Switched to cluster '%s'";
    }
    @Override
    public final void switchedBackToMainCluster() {
        super.log.logf(FQCN, INFO, null, switchedBackToMainCluster$str());
    }
    protected String switchedBackToMainCluster$str() {
        return "ISPN004051: Switched back to main cluster";
    }
    @Override
    public final void manuallySwitchedToCluster(final String clusterName) {
        super.log.logf(FQCN, INFO, null, manuallySwitchedToCluster$str(), clusterName);
    }
    protected String manuallySwitchedToCluster$str() {
        return "ISPN004052: Manually switched to cluster '%s'";
    }
    @Override
    public final void manuallySwitchedBackToMainCluster() {
        super.log.logf(FQCN, INFO, null, manuallySwitchedBackToMainCluster$str());
    }
    protected String manuallySwitchedBackToMainCluster$str() {
        return "ISPN004053: Manually switched back to main cluster";
    }
    protected String missingClusterNameDefinition$str() {
        return "ISPN004054: Name of the failover cluster needs to be specified";
    }
    @Override
    public final CacheConfigurationException missingClusterNameDefinition() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingClusterNameDefinition$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingHostDefinition$str() {
        return "ISPN004055: Host needs to be specified in server definition of failover cluster";
    }
    @Override
    public final CacheConfigurationException missingHostDefinition() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingHostDefinition$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingClusterServersDefinition$str() {
        return "ISPN004056: At least one server address needs to be specified for failover cluster %s";
    }
    @Override
    public final CacheConfigurationException missingClusterServersDefinition(final String siteName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingClusterServersDefinition$str(), siteName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String duplicateClusterDefinition$str() {
        return "ISPN004057: Duplicate failover cluster %s has been specified";
    }
    @Override
    public final CacheConfigurationException duplicateClusterDefinition(final String siteName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), duplicateClusterDefinition$str(), siteName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String clientListenerMustUseRawData$str() {
        return "ISPN004058: The client listener must use raw data when it uses a query as a filter: %s";
    }
    @Override
    public final IncorrectClientListenerException clientListenerMustUseRawData(final String className) {
        final IncorrectClientListenerException result = new IncorrectClientListenerException(String.format(getLoggingLocale(), clientListenerMustUseRawData$str(), className));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String clientListenerMustUseDesignatedFilterConverterFactory$str() {
        return "ISPN004059: The client listener must use the '%s' filter/converter factory";
    }
    @Override
    public final IncorrectClientListenerException clientListenerMustUseDesignatedFilterConverterFactory(final String filterConverterFactoryName) {
        final IncorrectClientListenerException result = new IncorrectClientListenerException(String.format(getLoggingLocale(), clientListenerMustUseDesignatedFilterConverterFactory$str(), filterConverterFactoryName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void ignoringErrorDuringIterationClose(final String iterationId, final Throwable e) {
        super.log.logf(FQCN, WARN, e, ignoringErrorDuringIterationClose$str(), iterationId);
    }
    protected String ignoringErrorDuringIterationClose$str() {
        return "ISPN004061: Ignoring error when closing iteration '%s'";
    }
    @Override
    public final void startedIteration(final String iterationId) {
        super.log.logf(FQCN, DEBUG, null, startedIteration$str(), iterationId);
    }
    protected String startedIteration$str() {
        return "ISPN004062: Started iteration '%s'";
    }
    @Override
    public final void iterationTransportObtained(final SocketAddress address, final String iterationId) {
        super.log.logf(FQCN, DEBUG, null, iterationTransportObtained$str(), address, iterationId);
    }
    protected String iterationTransportObtained$str() {
        return "ISPN004063: Channel to %s obtained for iteration '%s'";
    }
    @Override
    public final void trackingSegmentKey(final String key, final int segment, final boolean isTracked) {
        super.log.logf(FQCN, TRACE, null, trackingSegmentKey$str(), key, segment, isTracked);
    }
    protected String trackingSegmentKey$str() {
        return "ISPN004064: Tracking key %s belonging to segment %d, already tracked? = %b";
    }
    protected String callbackHandlerAndUsernameMutuallyExclusive$str() {
        return "ISPN004067: Cannot specify both a callback handler and a username/token for authentication";
    }
    @Override
    public final CacheConfigurationException callbackHandlerAndUsernameMutuallyExclusive() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), callbackHandlerAndUsernameMutuallyExclusive$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String channelInactive$str() {
        return "ISPN004069: Connection to %s is not active.";
    }
    @Override
    public final TransportException channelInactive(final SocketAddress address1, final SocketAddress address2) {
        final TransportException result = new TransportException(String.format(getLoggingLocale(), channelInactive$str(), address2), address1);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToAddListener$str() {
        return "ISPN004070: Failed to add client listener %s, server responded with status %d";
    }
    @Override
    public final HotRodClientException failedToAddListener(final Object listener, final short status) {
        final HotRodClientException result = new HotRodClientException(String.format(getLoggingLocale(), failedToAddListener$str(), listener, status));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String connectionClosed$str() {
        return "ISPN004071: Connection to %s was closed while waiting for response.";
    }
    @Override
    public final TransportException connectionClosed(final SocketAddress address1, final SocketAddress address2) {
        final TransportException result = new TransportException(String.format(getLoggingLocale(), connectionClosed$str(), address2), address1);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void cannotCreateAsyncThread(final int maxPoolSize) {
        super.log.logf(FQCN, ERROR, null, cannotCreateAsyncThread$str(), maxPoolSize);
    }
    protected String cannotCreateAsyncThread$str() {
        return "ISPN004072: Cannot create another async thread. Please increase 'infinispan.client.hotrod.default_executor_factory.pool_size' (current value is %d).";
    }
    @Override
    public final void epollNotAvailable(final String cause) {
        super.log.logf(FQCN, INFO, null, epollNotAvailable$str(), cause);
    }
    protected String epollNotAvailable$str() {
        return "ISPN004074: Native Epoll transport not available, using NIO instead: %s";
    }
    protected String trustStoreFileAndPathExclusive$str() {
        return "ISPN004075: TrustStoreFileName and TrustStorePath are mutually exclusive";
    }
    @Override
    public final CacheConfigurationException trustStoreFileAndPathExclusive() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), trustStoreFileAndPathExclusive$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownMessageId$str() {
        return "ISPN004076: Unknown message id %d; cannot find matching request";
    }
    @Override
    public final IllegalStateException unknownMessageId(final long messageId) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unknownMessageId$str(), messageId));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorFromUnknownOperation$str() {
        return "ISPN004077: Closing channel %s due to error in unknown operation.";
    }
    @Override
    public final TransportException errorFromUnknownOperation(final Channel channel, final Throwable cause, final SocketAddress address) {
        final TransportException result = new TransportException(String.format(getLoggingLocale(), errorFromUnknownOperation$str(), channel), cause, address);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noMoreOperationsAllowed$str() {
        return "ISPN004078: This channel is about to be closed and does not accept any further operations.";
    }
    @Override
    public final HotRodClientException noMoreOperationsAllowed() {
        final HotRodClientException result = new HotRodClientException(String.format(getLoggingLocale(), noMoreOperationsAllowed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedListenerId$str() {
        return "ISPN004079: Unexpected listenerId %s";
    }
    @Override
    public final IllegalStateException unexpectedListenerId(final String listenerId) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unexpectedListenerId$str(), listenerId));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String operationIsNotAddClientListener$str() {
        return "ISPN004080: Event should use messageId of previous Add Client Listener operation but id is %d and operation is %s";
    }
    @Override
    public final IllegalStateException operationIsNotAddClientListener(final long messageId, final String operation) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), operationIsNotAddClientListener$str(), messageId, operation));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidTransactionMode$str() {
        return "ISPN004082: TransactionMode must be non-null.";
    }
    @Override
    public final CacheConfigurationException invalidTransactionMode() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidTransactionMode$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidTransactionManagerLookup$str() {
        return "ISPN004083: TransactionManagerLookup must be non-null";
    }
    @Override
    public final CacheConfigurationException invalidTransactionManagerLookup() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidTransactionManagerLookup$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cacheDoesNotSupportTransactions$str() {
        return "ISPN004084: Cache %s doesn't support transactions. Please check the documentation how to configure it properly.";
    }
    @Override
    public final CacheNotTransactionalException cacheDoesNotSupportTransactions(final String name) {
        final CacheNotTransactionalException result = new CacheNotTransactionalException(String.format(getLoggingLocale(), cacheDoesNotSupportTransactions$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void invalidTxServerConfig(final String name, final Throwable throwable) {
        super.log.logf(FQCN, ERROR, throwable, invalidTxServerConfig$str(), name);
    }
    protected String invalidTxServerConfig$str() {
        return "ISPN004085: Error checking server configuration for transactional cache %s";
    }
    @Override
    public final void exceptionDuringPrepare(final Xid xid, final Exception e) {
        super.log.logf(FQCN, WARN, e, exceptionDuringPrepare$str(), xid);
    }
    protected String exceptionDuringPrepare$str() {
        return "ISPN004086: Exception caught while preparing transaction %s";
    }
    @Override
    public final void nearCacheMaxIdleUnsupported() {
        super.log.logf(FQCN, WARN, null, nearCacheMaxIdleUnsupported$str());
    }
    protected String nearCacheMaxIdleUnsupported$str() {
        return "ISPN004087: Use of maxIdle expiration with a near cache is unsupported.";
    }
    protected String invalidTransactionTimeout$str() {
        return "ISPN004088: Transactions timeout must be positive";
    }
    @Override
    public final HotRodClientException invalidTransactionTimeout() {
        final HotRodClientException result = new HotRodClientException(String.format(getLoggingLocale(), invalidTransactionTimeout$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String transactionTableNotStarted$str() {
        return "ISPN004089: TransactionTable is not started!";
    }
    @Override
    public final HotRodClientException transactionTableNotStarted() {
        final HotRodClientException result = new HotRodClientException(String.format(getLoggingLocale(), transactionTableNotStarted$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidResponse$str() {
        return "ISPN004090: [%s] Invalid response operation. Expected %#x and received %#x";
    }
    @Override
    public final InvalidResponseException invalidResponse(final String cacheName, final short opRespCode, final double receivedOpCode) {
        final InvalidResponseException result = new InvalidResponseException(String.format(getLoggingLocale(), invalidResponse$str(), cacheName, opRespCode, receivedOpCode));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String jmxRegistrationFailure$str() {
        return "ISPN004091: MBean registration failed";
    }
    @Override
    public final HotRodClientException jmxRegistrationFailure(final Throwable cause) {
        final HotRodClientException result = new HotRodClientException(String.format(getLoggingLocale(), jmxRegistrationFailure$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String jmxUnregistrationFailure$str() {
        return "ISPN004092: MBean unregistration failed";
    }
    @Override
    public final HotRodClientException jmxUnregistrationFailure(final Throwable cause) {
        final HotRodClientException result = new HotRodClientException(String.format(getLoggingLocale(), jmxUnregistrationFailure$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String oauthBearerWithoutToken$str() {
        return "ISPN004093: OAUTHBEARER mechanism selected without providing a token";
    }
    @Override
    public final CacheConfigurationException oauthBearerWithoutToken() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), oauthBearerWithoutToken$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String remoteCacheTemplateNameXorConfiguration$str() {
        return "ISPN004094: Cannot specify both template name and configuration for '%s'";
    }
    @Override
    public final CacheConfigurationException remoteCacheTemplateNameXorConfiguration(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), remoteCacheTemplateNameXorConfiguration$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notaHotRodURI$str() {
        return "ISPN004095: Not a Hot Rod URI: %s";
    }
    @Override
    public final IllegalArgumentException notaHotRodURI(final String uri) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), notaHotRodURI$str(), uri));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidPropertyFormat$str() {
        return "ISPN004096: Invalid property format in URI: %s";
    }
    @Override
    public final IllegalArgumentException invalidPropertyFormat(final String part) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidPropertyFormat$str(), part));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String duplicateCacheConfiguration$str() {
        return "ISPN004097: Illegal attempt to redefine an already existing cache configuration: %s";
    }
    @Override
    public final IllegalArgumentException duplicateCacheConfiguration(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), duplicateCacheConfiguration$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void closingChannelAfterError(final Channel channel, final Throwable t) {
        super.log.logf(FQCN, WARN, t, closingChannelAfterError$str(), channel);
    }
    protected String closingChannelAfterError$str() {
        return "ISPN004098: Closing connection %s due to transport error";
    }
    @Override
    public final void warnPerfRemoteIterationWithoutPagination(final String query) {
        super.log.logf(FQCN, WARN, null, warnPerfRemoteIterationWithoutPagination$str(), query);
    }
    protected String warnPerfRemoteIterationWithoutPagination$str() {
        return "ISPN004099: Remote iteration over the entire result set of query '%s' without using pagination options is inefficient for large result sets. Please consider using 'startOffset' and 'maxResults' options.";
    }
    @Override
    public final void throwableDuringPublisher(final Throwable t) {
        super.log.logf(FQCN, WARN, t, throwableDuringPublisher$str());
    }
    protected String throwableDuringPublisher$str() {
        return "ISPN004100: Error reaching the server during iteration";
    }
    @Override
    public final void deprecatedConfigurationProperty(final String property) {
        super.log.logf(FQCN, WARN, null, deprecatedConfigurationProperty$str(), property);
    }
    protected String deprecatedConfigurationProperty$str() {
        return "ISPN004101: Configuration property '%s' has been deprecated";
    }
    protected String nearCacheMaxEntriesPositiveWithBloom$str() {
        return "ISPN004102: Near cache number of max entries must be a positive number when using bloom filter optimization, it was %d";
    }
    @Override
    public final CacheConfigurationException nearCacheMaxEntriesPositiveWithBloom(final int maxEntries) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), nearCacheMaxEntriesPositiveWithBloom$str(), maxEntries));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String bloomFilterRequiresMaxActiveOneAndWait$str() {
        return "ISPN004103: Near cache with bloom filter requires pool max active to be 1, was %s, and exhausted action to be WAIT, was %s";
    }
    @Override
    public final CacheConfigurationException bloomFilterRequiresMaxActiveOneAndWait(final int maxActive, final ExhaustedAction action) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), bloomFilterRequiresMaxActiveOneAndWait$str(), maxActive, action));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void failedToCreatePredefinedSerializationContextInitializer(final String className, final Throwable throwable) {
        super.log.logf(FQCN, WARN, throwable, failedToCreatePredefinedSerializationContextInitializer$str(), className);
    }
    protected String failedToCreatePredefinedSerializationContextInitializer$str() {
        return "ISPN004104: Failed to load and create an optional ProtoStream serialization context initializer: %s";
    }
    @Override
    public final void revertCacheToInitialServerList(final Collection<String> cacheName) {
        super.log.logf(FQCN, WARN, null, revertCacheToInitialServerList$str(), cacheName);
    }
    protected String revertCacheToInitialServerList$str() {
        return "ISPN004105: Reverting to the initial server list for caches %s";
    }
    @Override
    public final void invalidActiveCountAfterClose(final Channel channel) {
        super.log.logf(FQCN, WARN, null, invalidActiveCountAfterClose$str(), channel);
    }
    protected String invalidActiveCountAfterClose$str() {
        return "ISPN004106: Invalid active count after closing channel %s";
    }
    @Override
    public final void invalidCreatedCountAfterClose(final Channel channel) {
        super.log.logf(FQCN, WARN, null, invalidCreatedCountAfterClose$str(), channel);
    }
    protected String invalidCreatedCountAfterClose$str() {
        return "ISPN004107: Invalid created count after closing channel %s";
    }
    @Override
    public final void ioUringNotAvailable(final String cause) {
        super.log.logf(FQCN, INFO, null, ioUringNotAvailable$str(), cause);
    }
    protected String ioUringNotAvailable$str() {
        return "ISPN004108: Native IOUring transport not available, using NIO instead: %s";
    }
    @Override
    public final void noOpenTelemetryAPI(final Throwable throwable) {
        super.log.logf(FQCN, DEBUG, throwable, noOpenTelemetryAPI$str());
    }
    protected String noOpenTelemetryAPI$str() {
        return "ISPN004109: OpenTelemetry API is not present in the classpath. Client context tracing will not be propagated.";
    }
    @Override
    public final void openTelemetryPropagationEnabled() {
        super.log.logf(FQCN, DEBUG, null, openTelemetryPropagationEnabled$str());
    }
    protected String openTelemetryPropagationEnabled$str() {
        return "ISPN004110: OpenTelemetry API is present in the classpath and the tracing propagation is enabled. Client context tracing will be propagated.";
    }
    @Override
    public final void openTelemetryPropagationDisabled() {
        super.log.logf(FQCN, DEBUG, null, openTelemetryPropagationDisabled$str());
    }
    protected String openTelemetryPropagationDisabled$str() {
        return "ISPN004111: OpenTelemetry API is present in the classpath, but the tracing propagation is not enabled. Client context tracing will not be propagated.";
    }
}
