/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.rest;

import java.util.concurrent.CompletionStage;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.infinispan.cli.activators.ConnectionActivator;
import org.infinispan.cli.commands.rest.RestCliCommand;
import org.infinispan.cli.completers.AvailabilityCompleter;
import org.infinispan.cli.completers.CacheCompleter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.resources.CacheResource;
import org.infinispan.cli.resources.Resource;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;

@GroupCommandDefinition(name="availability", description="Manage availability of clustered caches in network partitions.", activator=ConnectionActivator.class)
public class Availability
extends RestCliCommand {
    @Argument(completer=CacheCompleter.class)
    String cache;
    @Option(shortName=109, completer=AvailabilityCompleter.class)
    String mode;
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
        RestCacheClient cacheClient = client.cache(this.cache != null ? this.cache : CacheResource.cacheName(resource));
        return this.mode == null ? cacheClient.getAvailability() : cacheClient.setAvailability(AvailabilityCompleter.Availability.valueOf(this.mode).toString());
    }
}

