/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.url.extension.urlhandler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;

public class TcpUrlStreamHandlerFactory
implements URLStreamHandlerFactory {
    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        return protocol.equals("tcp") ? new TcpUrlStreamHandler() : null;
    }

    private static class TcpUrlStreamHandler
    extends URLStreamHandler {
        private TcpUrlStreamHandler() {
        }

        @Override
        protected URLConnection openConnection(URL tcpUrl) {
            return new TcpUrlConnection(tcpUrl);
        }

        @Override
        protected void parseURL(URL u, String spec, int start, int limit) {
            super.parseURL(u, spec, start, limit);
            if (u.getPort() <= 0) {
                throw new MalformedURLException("tcp port must be present");
            }
            if (!u.getPath().isEmpty()) {
                throw new MalformedURLException("path cannot be supplied with tcp");
            }
            if (u.getQuery() != null) {
                throw new MalformedURLException("query cannot be supplied with tcp");
            }
            TcpUrlStreamHandler.parseLocal(u.getUserInfo());
        }

        private static InetSocketAddress parseLocal(String user) {
            int localPort;
            String localAddress;
            if (user == null) {
                return null;
            }
            int colon = user.indexOf(58);
            if (colon < 0) {
                localAddress = user;
                localPort = 0;
            } else {
                localAddress = user.substring(0, colon);
                localPort = Integer.parseInt(user.substring(colon + 1));
            }
            return new InetSocketAddress(localAddress, localPort);
        }

        private static class TcpUrlConnection
        extends URLConnection {
            private Socket client;

            private TcpUrlConnection(URL url) {
                super(url);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connect() throws IOException {
                TcpUrlConnection tcpUrlConnection = this;
                synchronized (tcpUrlConnection) {
                    if (!this.connected) {
                        InetSocketAddress isa = new InetSocketAddress(this.url.getHost(), this.url.getPort());
                        this.client = new Socket();
                        this.client.bind(TcpUrlStreamHandler.parseLocal(this.url.getUserInfo()));
                        this.client.connect(isa, this.getConnectTimeout());
                        this.connected = true;
                    }
                }
            }

            @Override
            public InputStream getInputStream() throws IOException {
                this.connect();
                return this.client.getInputStream();
            }

            @Override
            public OutputStream getOutputStream() throws IOException {
                this.connect();
                return this.client.getOutputStream();
            }
        }
    }
}

