/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.license.maven.plugin.compliance;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.regex.Pattern;
import org.apache.maven.model.License;

public class LicenseRegex {
    @XmlElement
    private String name;
    @XmlElement
    private String url;
    @XmlTransient
    private Pattern namePattern;
    @XmlTransient
    private Pattern urlPattern;

    public LicenseRegex() {
    }

    public LicenseRegex(String name, String url) {
        this.name = name;
        this.url = url;
        this.checkRegex();
    }

    @XmlTransient
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlTransient
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void checkRegex() {
        if (this.name != null) {
            this.namePattern = Pattern.compile(this.name, 66);
        }
        if (this.url != null) {
            this.urlPattern = Pattern.compile(this.url, 66);
        }
    }

    public boolean matches(License license) {
        return LicenseRegex.match(license.getUrl(), this.urlPattern) || LicenseRegex.match(license.getName(), this.namePattern);
    }

    private static boolean match(String value, Pattern pattern) {
        return pattern != null && value != null && pattern.matcher(value.strip()).matches();
    }
}

