/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.license.maven.plugin.compliance;

import java.util.List;
import org.apache.maven.model.License;
import org.apache.maven.plugin.logging.Log;
import org.honton.chas.license.maven.plugin.compliance.LicenseRegex;

public class LicenseMatcher {
    private final Log logger;
    private List<LicenseRegex> acceptableLicenses;

    public LicenseMatcher(Log logger, List<LicenseRegex> acceptableLicenses) {
        this.logger = logger;
        this.acceptableLicenses = acceptableLicenses;
        for (LicenseRegex acceptableLicense : acceptableLicenses) {
            acceptableLicense.checkRegex();
        }
    }

    public boolean hasAcceptableLicense(List<License> licenses) {
        for (License license : licenses) {
            if (!this.isAcceptable(license)) continue;
            this.logger.debug((CharSequence)(license.getName() + "/" + license.getUrl() + " is acceptable"));
            return true;
        }
        return false;
    }

    private boolean isAcceptable(License license) {
        for (LicenseRegex acceptableLicense : this.acceptableLicenses) {
            if (acceptableLicense.matches(license)) {
                return true;
            }
            this.logger.debug((CharSequence)(acceptableLicense.getName() + "/" + acceptableLicense.getUrl() + " does not match"));
        }
        return false;
    }
}

