/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.license.maven.plugin;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.License;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.honton.chas.license.maven.plugin.DependencyMatcher;
import org.honton.chas.license.maven.plugin.ScopeMatcher;
import org.honton.chas.license.maven.plugin.compliance.LicenseMatcher;
import org.honton.chas.license.maven.plugin.compliance.LicenseRegex;
import org.honton.chas.license.maven.plugin.compliance.LicenseSet;

@Mojo(name="compliance", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class ComplianceMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Component
    private RepositorySystem repository;
    @Component
    private ProjectBuilder projectBuilder;
    @Component
    private ArtifactResolver artifactResolver;
    @Parameter(property="compliance.skip", defaultValue="false")
    private boolean skipCompliance;
    @Parameter
    private List<LicenseRegex> acceptableLicenses;
    @Parameter(property="compliance.licenses")
    private String acceptableLicenseResources;
    @Parameter
    private List<String> excludes;
    @Parameter(property="compliance.scopes", defaultValue="compile, runtime, provided, test")
    private String scopes;
    private DependencyMatcher excludeMatcher;
    private LicenseMatcher licenseMatcher;
    private ScopeMatcher scopeMatcher;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipCompliance) {
            this.getLog().info((CharSequence)"skipping license compliance");
            return;
        }
        this.scopeMatcher = new ScopeMatcher(this.scopes != null ? this.scopes : "compile, runtime, provided, test");
        if (this.acceptableLicenses == null) {
            this.acceptableLicenses = new ArrayList<LicenseRegex>();
            if (this.acceptableLicenseResources == null) {
                this.acceptableLicenseResources = "osi-permissive";
            }
        }
        if (this.acceptableLicenseResources != null) {
            LicenseSet.loadLicenses(this.acceptableLicenses, this.acceptableLicenseResources);
        }
        this.excludeMatcher = new DependencyMatcher(this.getLog(), this.excludes);
        this.licenseMatcher = new LicenseMatcher(this.getLog(), this.acceptableLicenses);
        for (Dependency dependency : this.project.getDependencies()) {
            this.checkDependency(dependency);
        }
    }

    private void checkDependency(Dependency dependency) throws MojoExecutionException {
        if (!this.scopeMatcher.isMatch(dependency.getScope())) {
            this.getLog().debug((CharSequence)ComplianceMojo.createMessage(dependency, " is not scoped"));
            return;
        }
        if (this.excludeMatcher.isMatch(dependency)) {
            this.getLog().debug((CharSequence)ComplianceMojo.createMessage(dependency, " is excluded"));
            return;
        }
        MavenProject mavenProject = this.getMavenProject(dependency);
        List licenses = mavenProject.getLicenses();
        if (!this.licenseMatcher.hasAcceptableLicense(licenses)) {
            StringBuilder sb = ComplianceMojo.createMessage(new StringBuilder(300), dependency);
            this.expandLicenses(mavenProject, sb);
            throw new MojoExecutionException(sb.toString());
        }
    }

    private void expandLicenses(MavenProject mavenProject, StringBuilder sb) {
        sb.append(" does not have acceptable license [");
        boolean priorLicense = false;
        for (License license : mavenProject.getLicenses()) {
            if (priorLicense) {
                sb.append("},{");
            } else {
                sb.append('{');
                priorLicense = true;
            }
            if (license.getName() != null) {
                sb.append("name:").append(license.getName());
            }
            if (license.getUrl() == null) continue;
            if (license.getName() != null) {
                sb.append(',');
            }
            sb.append("url:").append(license.getUrl());
        }
        if (priorLicense) {
            sb.append('}');
        }
        sb.append(']');
    }

    private MavenProject getMavenProject(Dependency d) throws MojoExecutionException {
        Artifact artifact = this.repository.createProjectArtifact(d.getGroupId(), d.getArtifactId(), d.getVersion());
        try {
            return this.projectBuilder.build(artifact, this.session.getProjectBuildingRequest()).getProject();
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private static StringBuilder createMessage(StringBuilder sb, Dependency d) {
        sb.append(d.getGroupId()).append(':').append(d.getArtifactId()).append(':').append(d.getType() != null ? d.getType() : "jar");
        if (d.getClassifier() != null) {
            sb.append(':').append(d.getClassifier());
        }
        sb.append(':').append(d.getVersion());
        return sb;
    }

    private static String createMessage(Dependency d, String suffix) {
        return ComplianceMojo.createMessage(new StringBuilder(100), d).append(suffix).toString();
    }

    private static String createMessage(String prefix, Dependency d) {
        return ComplianceMojo.createMessage(new StringBuilder(100).append(prefix), d).toString();
    }
}

