/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.bean.impl;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.impl.BeanReferenceRegistryForType;
import org.hibernate.search.engine.environment.bean.impl.ConfigurationBeanRegistry;
import org.hibernate.search.engine.environment.bean.spi.BeanConfigurationContext;
import org.hibernate.search.util.common.impl.Contracts;

final class BeanConfigurationContextImpl
implements BeanConfigurationContext {
    private final Map<Class<?>, BeanReferenceRegistryForType<?>> configuredBeans = new HashMap();

    BeanConfigurationContextImpl() {
    }

    @Override
    public <T> void define(Class<T> exposedType, BeanReference<T> reference) {
        Contracts.assertNotNull(exposedType, (String)"exposedType");
        Contracts.assertNotNull(reference, (String)"reference");
        this.configuredBeans(exposedType).add(reference);
    }

    @Override
    public <T> void define(Class<T> exposedType, String name, BeanReference<T> reference) {
        Contracts.assertNotNull(exposedType, (String)"exposedType");
        Contracts.assertNotNull((Object)name, (String)"name");
        Contracts.assertNotNull(reference, (String)"reference");
        this.configuredBeans(exposedType).add(name, reference);
    }

    ConfigurationBeanRegistry buildRegistry() {
        return new ConfigurationBeanRegistry(new HashMap(this.configuredBeans));
    }

    private <T> BeanReferenceRegistryForType<T> configuredBeans(Class<T> exposedType) {
        return this.configuredBeans.computeIfAbsent(exposedType, ignored -> new BeanReferenceRegistryForType(exposedType));
    }
}

