/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.impl;

import org.hibernate.search.engine.backend.index.spi.IndexManagerImplementor;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.impl.ConfigurationPropertySourceExtractor;
import org.hibernate.search.engine.common.impl.IndexManagerStartContextImpl;
import org.hibernate.search.engine.common.resources.spi.SavedState;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.reporting.spi.RootFailureCollector;
import org.hibernate.search.util.common.reporting.EventContext;

class IndexManagerNonStartedState {
    private final EventContext eventContext;
    private final ConfigurationPropertySourceExtractor propertySourceExtractor;
    private final IndexManagerImplementor indexManager;
    private IndexManagerStartContextImpl startContext;
    private ContextualFailureCollector indexFailureCollector;

    IndexManagerNonStartedState(EventContext eventContext, ConfigurationPropertySourceExtractor propertySourceExtractor, IndexManagerImplementor indexManager) {
        this.eventContext = eventContext;
        this.propertySourceExtractor = propertySourceExtractor;
        this.indexManager = indexManager;
    }

    void closeOnFailure() {
        this.indexManager.stop();
    }

    void preStart(RootFailureCollector rootFailureCollector, BeanResolver beanResolver, ConfigurationPropertySource rootPropertySource, SavedState savedState) {
        this.indexFailureCollector = rootFailureCollector.withContext(this.eventContext);
        ConfigurationPropertySource indexPropertySource = this.propertySourceExtractor.extract(beanResolver, rootPropertySource);
        this.startContext = new IndexManagerStartContextImpl(this.indexFailureCollector, beanResolver, indexPropertySource);
        try {
            this.indexManager.preStart(this.startContext, savedState);
        }
        catch (RuntimeException e) {
            this.indexFailureCollector.add(e);
        }
    }

    IndexManagerImplementor start() {
        try {
            this.indexManager.start(this.startContext);
        }
        catch (RuntimeException e) {
            this.indexFailureCollector.add(e);
        }
        return this.indexManager;
    }
}

