/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.validation;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.FetchMode;
import org.hibernate.QueryException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.processor.validation.MockSessionFactory;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.ListType;
import org.hibernate.type.MapType;
import org.hibernate.type.Type;

public abstract class MockCollectionPersister
implements QueryableCollection {
    private static final @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] ID_COLUMN = new String[]{"id"};
    private static final @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] INDEX_COLUMN = new String[]{"pos"};
    private final @UnknownKeyFor @NonNull @Initialized String role;
    private final @UnknownKeyFor @NonNull @Initialized MockSessionFactory factory;
    private final @UnknownKeyFor @NonNull @Initialized CollectionType collectionType;
    private final @UnknownKeyFor @NonNull @Initialized String ownerEntityName;
    private final @UnknownKeyFor @NonNull @Initialized Type elementType;

    public MockCollectionPersister(@UnknownKeyFor @NonNull @Initialized String role, @UnknownKeyFor @NonNull @Initialized CollectionType collectionType, @UnknownKeyFor @NonNull @Initialized Type elementType, @UnknownKeyFor @NonNull @Initialized MockSessionFactory factory) {
        this.role = role;
        this.collectionType = collectionType;
        this.elementType = elementType;
        this.factory = factory;
        this.ownerEntityName = StringHelper.root((String)role);
    }

    @UnknownKeyFor @NonNull @Initialized String getOwnerEntityName() {
        return this.ownerEntityName;
    }

    public @UnknownKeyFor @NonNull @Initialized String getRole() {
        return this.role;
    }

    public @UnknownKeyFor @NonNull @Initialized String getName() {
        return this.role;
    }

    public @UnknownKeyFor @NonNull @Initialized CollectionType getCollectionType() {
        return this.collectionType;
    }

    public @UnknownKeyFor @NonNull @Initialized EntityPersister getOwnerEntityPersister() {
        return this.factory.getMetamodel().entityPersister(this.ownerEntityName);
    }

    abstract @UnknownKeyFor @NonNull @Initialized Type getElementPropertyType(@UnknownKeyFor @NonNull @Initialized String var1);

    public @UnknownKeyFor @NonNull @Initialized Type toType(@UnknownKeyFor @NonNull @Initialized String propertyName) throws @UnknownKeyFor @NonNull @Initialized QueryException {
        if ("index".equals(propertyName)) {
            return this.getIndexType();
        }
        Type type = this.getElementPropertyType(propertyName);
        if (type == null) {
            throw new QueryException(this.elementType.getName() + " has no mapped " + propertyName);
        }
        return type;
    }

    public @UnknownKeyFor @NonNull @Initialized Type getKeyType() {
        return this.getOwnerEntityPersister().getIdentifierType();
    }

    public @UnknownKeyFor @NonNull @Initialized Type getIndexType() {
        if (this.collectionType instanceof ListType) {
            return this.factory.getTypeConfiguration().getBasicTypeForJavaType(Integer.class);
        }
        if (this.collectionType instanceof MapType) {
            return this.factory.getTypeConfiguration().getBasicTypeForJavaType(String.class);
        }
        return null;
    }

    public @UnknownKeyFor @NonNull @Initialized Type getElementType() {
        return this.elementType;
    }

    public @UnknownKeyFor @NonNull @Initialized Type getIdentifierType() {
        return this.factory.getTypeConfiguration().getBasicTypeForJavaType(Long.class);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasIndex() {
        return this.getCollectionType() instanceof ListType || this.getCollectionType() instanceof MapType;
    }

    public @UnknownKeyFor @NonNull @Initialized EntityPersister getElementPersister() {
        if (this.elementType instanceof EntityType) {
            return this.factory.getMetamodel().entityPersister(this.elementType.getName());
        }
        return null;
    }

    public @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isOneToMany() {
        return this.elementType instanceof EntityType;
    }

    public @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] getCollectionSpaces() {
        return new String[]{this.role};
    }

    public @UnknownKeyFor @NonNull @Initialized String getMappedByProperty() {
        return null;
    }

    public @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] getIndexColumnNames() {
        return INDEX_COLUMN;
    }

    public @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] getIndexColumnNames(@UnknownKeyFor @NonNull @Initialized String alias) {
        return INDEX_COLUMN;
    }

    public @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] getIndexFormulas() {
        return null;
    }

    public @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] getElementColumnNames(@UnknownKeyFor @NonNull @Initialized String alias) {
        return new String[]{""};
    }

    public @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] getElementColumnNames() {
        return new String[]{""};
    }

    public @UnknownKeyFor @NonNull @Initialized FetchMode getFetchMode() {
        return FetchMode.DEFAULT;
    }

    public @UnknownKeyFor @NonNull @Initialized String getTableName() {
        return this.role;
    }

    public @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] getKeyColumnNames() {
        return ID_COLUMN;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isCollection() {
        return true;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean consumesCollectionAlias() {
        return true;
    }

    public @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] toColumns(@UnknownKeyFor @NonNull @Initialized String propertyName) {
        return new String[]{""};
    }
}

